/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.player;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.imviewer.util.player.MoviePlayer;
import org.openmicroscopy.shoola.agents.imviewer.util.player.MoviePlayerUI;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;

class MoviePlayerControl
implements ActionListener,
ChangeListener,
FocusListener,
PropertyChangeListener {
    private static final int PLAY_CMD = 4;
    private static final int PAUSE_CMD = 5;
    private static final int STOP_CMD = 6;
    private static final int MOVIE_TYPE_CMD = 7;
    private static final int EDITOR_CMD = 8;
    private static final int ACROSS_Z_CMD = 9;
    private static final int ACROSS_T_CMD = 10;
    private static final int ACROSS_ZT_CMD = 11;
    private MoviePlayer model;
    private MoviePlayerUI view;

    private void attachButtonListener(AbstractButton button, int id) {
        button.addActionListener(this);
        button.setActionCommand("" + id);
    }

    private void attachFieldListeners(JTextField field) {
        field.addFocusListener(this);
        field.addPropertyChangeListener(this);
    }

    private void initListeners() {
        NumericalTextField editor = this.view.editor;
        editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MoviePlayerControl.this.editorActionHandler();
                }
            }
        });
        this.attachButtonListener(this.view.play, 4);
        this.attachButtonListener(this.view.pause, 5);
        this.attachButtonListener(this.view.stop, 6);
        JComboBox box = this.view.movieTypes;
        box.setActionCommand("7");
        box.addActionListener(this);
        this.view.fps.addChangeListener(this);
        this.attachFieldListeners(this.view.startT);
        this.attachFieldListeners(this.view.endT);
        this.attachFieldListeners(this.view.startZ);
        this.attachFieldListeners(this.view.endZ);
        this.attachButtonListener(this.view.acrossZ, 9);
        this.attachButtonListener(this.view.acrossT, 10);
        this.view.tSlider.addPropertyChangeListener(this);
        this.view.zSlider.addPropertyChangeListener(this);
    }

    private void editorActionHandler() {
        int val = (Integer)this.view.fps.getValue();
        Number n = this.view.editor.getValueAsNumber();
        if (n != null) {
            val = n.intValue();
            this.model.setTimerDelay(val);
            this.view.setTimerDelay(val);
        } else {
            this.view.editor.setText("" + val);
            this.model.setTimerDelay(val);
            this.view.setTimerDelay(val);
        }
    }

    MoviePlayerControl(MoviePlayer model, MoviePlayerUI view) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.view = view;
        this.model = model;
        this.initListeners();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            int index = Integer.parseInt(ae.getActionCommand());
            switch (index) {
                case 10: {
                    if (this.view.acrossZ.isSelected()) {
                        if (this.view.acrossT.isSelected()) {
                            this.model.setMovieIndex(302);
                            break;
                        }
                        this.model.setMovieIndex(300);
                        break;
                    }
                    if (this.view.acrossT.isSelected()) {
                        this.model.setMovieIndex(301);
                        break;
                    }
                    this.view.acrossT.setSelected(true);
                    break;
                }
                case 9: {
                    if (this.view.acrossT.isSelected()) {
                        if (this.view.acrossZ.isSelected()) {
                            this.model.setMovieIndex(302);
                            break;
                        }
                        this.model.setMovieIndex(301);
                        break;
                    }
                    if (this.view.acrossZ.isSelected()) {
                        this.model.setMovieIndex(300);
                        break;
                    }
                    this.view.acrossZ.setSelected(true);
                    break;
                }
                case 11: {
                    this.model.setMovieIndex(302);
                    break;
                }
                case 4: {
                    this.model.setPlayerState(0);
                    break;
                }
                case 5: {
                    this.model.setPlayerState(2);
                    break;
                }
                case 6: {
                    this.model.setPlayerState(1);
                    break;
                }
                case 8: {
                    this.editorActionHandler();
                    break;
                }
                case 7: {
                    int i = ((JComboBox)ae.getSource()).getSelectedIndex();
                    this.model.setMovieType(this.view.getMovieType(i));
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new Error("Invalid Action ID " + ae.getActionCommand(), nfe);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int v = (Integer)this.view.fps.getValue();
        this.model.setTimerDelay(v);
        this.view.setTimerDelay(v);
    }

    @Override
    public void focusLost(FocusEvent e) {
        String edit = this.view.editor.getText();
        String ed = "" + this.model.getTimerDelay();
        if (edit == null || !edit.equals(ed)) {
            this.view.editor.setText(ed);
        }
        String startT = "" + (this.model.getStartT() + 1);
        String endT = "" + (this.model.getEndT() + 1);
        String startVal = this.view.startT.getText();
        String endVal = this.view.endT.getText();
        if (CommonsLangUtils.isBlank(startVal) || !startVal.equals(startT)) {
            this.view.startT.setText(startT);
        }
        if (CommonsLangUtils.isBlank(endVal) || !endVal.equals(endT)) {
            this.view.endT.setText(endT);
        }
        String startZ = "" + (this.model.getStartZ() + 1);
        String endZ = "" + (this.model.getEndZ() + 1);
        startVal = this.view.startZ.getText();
        endVal = this.view.endZ.getText();
        if (CommonsLangUtils.isBlank(startVal) || !startVal.equals(startZ)) {
            this.view.startZ.setText(startZ);
        }
        if (CommonsLangUtils.isBlank(endVal) || !endVal.equals(endZ)) {
            this.view.endZ.setText(endZ);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        Object source = evt.getSource();
        int s = -1;
        int e = -1;
        if ("leftMoved".equals(name)) {
            if (source.equals(this.view.zSlider)) {
                s = this.view.zSlider.getStartValueAsInt();
                this.model.setStartZ(s);
                this.view.setStartZ(s);
            } else if (source.equals(this.view.tSlider)) {
                s = this.view.tSlider.getStartValueAsInt();
                this.model.setStartT(s);
                this.view.setStartT(s);
            }
        } else if ("rightMoved".equals(name)) {
            if (source.equals(this.view.zSlider)) {
                e = this.view.zSlider.getEndValueAsInt();
                this.model.setEndZ(e);
                this.view.setEndZ(e);
            } else if (source.equals(this.view.tSlider)) {
                e = this.view.tSlider.getEndValueAsInt();
                this.model.setEndT(e);
                this.view.setEndT(e);
            }
        } else if ("textUpdated".equals(name)) {
            if (source.equals(this.view.startT)) {
                Number n = this.view.startT.getValueAsNumber();
                if (n == null) {
                    return;
                }
                s = n.intValue() - 1;
                if (s >= this.model.getEndT() || s < 0) {
                    return;
                }
                this.model.setStartT(s);
                this.view.tSlider.setStartValue(s);
            } else if (source.equals(this.view.startZ)) {
                Number n = this.view.startZ.getValueAsNumber();
                if (n == null) {
                    return;
                }
                s = n.intValue() - 1;
                if (s >= this.model.getEndZ() || s < 0) {
                    return;
                }
                this.model.setStartZ(s);
                this.view.zSlider.setStartValue(s);
            } else if (source.equals(this.view.endZ)) {
                Number n = this.view.endZ.getValueAsNumber();
                if (n == null) {
                    return;
                }
                s = n.intValue() - 1;
                if (s <= this.model.getStartZ() || s > this.model.getMaxZ()) {
                    return;
                }
                this.model.setEndZ(s);
                this.view.zSlider.setEndValue(s);
            } else if (source.equals(this.view.endT)) {
                Number n = this.view.endT.getValueAsNumber();
                if (n == null) {
                    return;
                }
                s = n.intValue() - 1;
                if (s <= this.model.getStartT() || s > this.model.getMaxT()) {
                    return;
                }
                this.model.setEndT(s);
                this.view.tSlider.setEndValue(s);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

