/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.List;
import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class ProjectionSaver
extends BatchCallTree {
    private long pixelsID;
    private Object result;
    private BatchCall loadCall;
    private SecurityContext ctx;

    private BatchCall makeRenderProjectedCall(final int startZ, final int endZ, final int stepping, final int algorithm, final List<Integer> channels) {
        return new BatchCall("Preview the projected image."){

            @Override
            public void doCall() throws Exception {
                OmeroImageService rds = ProjectionSaver.this.context.getImageService();
                ProjectionSaver.this.result = rds.renderProjected(ProjectionSaver.this.ctx, ProjectionSaver.this.pixelsID, startZ, endZ, stepping, algorithm, channels);
            }
        };
    }

    private BatchCall makeProjectionCall(final ProjectionParam ref) {
        return new BatchCall("Project the image"){

            @Override
            public void doCall() throws Exception {
                OmeroImageService rds = ProjectionSaver.this.context.getImageService();
                ProjectionSaver.this.result = rds.projectImage(ProjectionSaver.this.ctx, ref);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public ProjectionSaver(SecurityContext ctx, long pixelsID, int startZ, int endZ, int stepping, int type, List<Integer> channels) {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels Id not valid.");
        }
        this.ctx = ctx;
        this.pixelsID = pixelsID;
        this.loadCall = this.makeRenderProjectedCall(startZ, endZ, stepping, type, channels);
    }

    public ProjectionSaver(SecurityContext ctx, ProjectionParam ref) {
        this.ctx = ctx;
        this.loadCall = this.makeProjectionCall(ref);
    }
}

