/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.jhotdraw.app.AbstractApplication;
import org.jhotdraw.app.ApplicationModel;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AboutAction;
import org.jhotdraw.app.action.Actions;
import org.jhotdraw.app.action.ArrangeAction;
import org.jhotdraw.app.action.ClearRecentFilesAction;
import org.jhotdraw.app.action.CloseAction;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DeleteAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.ExitAction;
import org.jhotdraw.app.action.FocusAction;
import org.jhotdraw.app.action.NewAction;
import org.jhotdraw.app.action.OpenAction;
import org.jhotdraw.app.action.OpenRecentAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.PrintAction;
import org.jhotdraw.app.action.RedoAction;
import org.jhotdraw.app.action.SaveAction;
import org.jhotdraw.app.action.SaveAsAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.app.action.ToggleToolBarAction;
import org.jhotdraw.app.action.UndoAction;
import org.jhotdraw.gui.Arrangeable;
import org.jhotdraw.gui.MDIDesktopPane;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.ReversedList;
import org.jhotdraw.util.prefs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMDIApplication
extends AbstractApplication {
    private JFrame parentFrame;
    private JScrollPane scrollPane;
    private MDIDesktopPane desktopPane;
    private Preferences prefs;
    private Project currentProject;
    private LinkedList<Action> toolBarActions;

    protected void initApplicationActions() {
        ApplicationModel mo = this.getModel();
        mo.putAction("about", new AboutAction(this));
        mo.putAction("exit", new ExitAction(this));
        mo.putAction("new", new NewAction(this));
        mo.putAction("open", new OpenAction(this));
        mo.putAction("clearRecentFiles", new ClearRecentFilesAction(this));
        mo.putAction("save", new SaveAction(this));
        mo.putAction("saveAs", new SaveAsAction(this));
        mo.putAction("close", new CloseAction(this));
        mo.putAction("print", new PrintAction(this));
        mo.putAction("undo", new UndoAction(this));
        mo.putAction("redo", new RedoAction(this));
        mo.putAction("cut", new CutAction());
        mo.putAction("copy", new CopyAction());
        mo.putAction("paste", new PasteAction());
        mo.putAction("delete", new DeleteAction());
        mo.putAction("duplicate", new DuplicateAction());
        mo.putAction("selectAll", new SelectAllAction());
        mo.putAction("arrangeVertical", new ArrangeAction(this.desktopPane, Arrangeable.Arrangement.VERTICAL));
        mo.putAction("arrangeHorizontal", new ArrangeAction(this.desktopPane, Arrangeable.Arrangement.HORIZONTAL));
        mo.putAction("arrangeCascade", new ArrangeAction(this.desktopPane, Arrangeable.Arrangement.CASCADE));
    }

    @Override
    protected void initProjectActions(Project p) {
        p.putAction("focus", new FocusAction(p));
    }

    @Override
    public void launch(String[] args) {
        super.launch(args);
    }

    @Override
    public void init() {
        this.initLookAndFeel();
        super.init();
        this.prefs = Preferences.userNodeForPackage(this.getModel() == null ? this.getClass() : this.getModel().getClass());
        this.initLabels();
        this.parentFrame = new JFrame(this.getName());
        this.parentFrame.setDefaultCloseOperation(0);
        this.desktopPane = new MDIDesktopPane();
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.desktopPane);
        this.toolBarActions = new LinkedList();
        this.initApplicationActions();
        this.parentFrame.getContentPane().add(this.wrapDesktopPane(this.scrollPane, this.toolBarActions));
        this.parentFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DefaultMDIApplication.this.getModel().getAction("exit").actionPerformed(new ActionEvent(DefaultMDIApplication.this.parentFrame, 1001, "windowClosing"));
            }
        });
        this.parentFrame.setJMenuBar(this.createMenuBar());
        PreferencesUtil.installFramePrefsHandler(this.prefs, "parentFrame", this.parentFrame);
        this.parentFrame.setVisible(true);
    }

    @Override
    public void configure(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "false");
        System.setProperty("com.apple.macos.useScreenMenuBar", "false");
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        System.setProperty("swing.aatext", "true");
    }

    protected void initLookAndFeel() {
        try {
            String lafName;
            if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
                lafName = UIManager.getCrossPlatformLookAndFeelClassName();
            } else {
                lafName = UIManager.getSystemLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(lafName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (UIManager.getString("OptionPane.css") == null) {
            UIManager.put("OptionPane.css", "");
        }
    }

    @Override
    public void show(final Project p) {
        if (!p.isShowing()) {
            boolean moved;
            p.setShowing(true);
            File file = p.getFile();
            final JInternalFrame f = new JInternalFrame();
            String title = file == null ? this.labels.getString("unnamedFile") : file.getName();
            f.setTitle(this.labels.getFormatted("internalFrameTitle", title, this.getName(), p.getMultipleOpenId()));
            f.setDefaultCloseOperation(0);
            f.setClosable(true);
            f.setMaximizable(true);
            f.setResizable(true);
            f.setIconifiable(false);
            PreferencesUtil.installInternalFramePrefsHandler(this.prefs, "project", f, this.desktopPane);
            Point loc = f.getLocation();
            block2: do {
                moved = false;
                for (Project aProject : this.projects()) {
                    if (aProject == p || !aProject.isShowing() || !SwingUtilities.getRootPane(aProject.getComponent()).getParent().getLocation().equals(loc)) continue;
                    loc.x += 22;
                    loc.y += 22;
                    moved = true;
                    continue block2;
                }
            } while (moved);
            f.setLocation(loc);
            f.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameClosing(InternalFrameEvent evt) {
                    DefaultMDIApplication.this.setCurrentProject(p);
                    DefaultMDIApplication.this.getModel().getAction("close").actionPerformed(new ActionEvent(f, 1001, "windowClosing"));
                }
            });
            p.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if (name.equals("hasUnsavedChanges")) {
                        ((JInternalFrame)f.getRootPane().getParent()).putClientProperty("windowModified", new Boolean(p.hasUnsavedChanges()));
                    } else if (name.equals("file")) {
                        f.setTitle(p.getFile() == null ? "Unnamed" : p.getFile().getName());
                    }
                }
            });
            f.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if (name.equals("selected") && evt.getNewValue().equals(Boolean.TRUE)) {
                        DefaultMDIApplication.this.setCurrentProject(p);
                    }
                }
            });
            f.getContentPane().add(p.getComponent());
            f.setVisible(true);
            this.desktopPane.add(f);
            f.toFront();
            try {
                f.setSelected(true);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
            p.getComponent().requestFocusInWindow();
        }
    }

    @Override
    public void hide(Project p) {
        if (p.isShowing()) {
            JInternalFrame f = (JInternalFrame)SwingUtilities.getRootPane(p.getComponent()).getParent();
            f.setVisible(false);
            f.remove(p.getComponent());
            this.desktopPane.remove(f);
            f.dispose();
        }
    }

    @Override
    public Project getCurrentProject() {
        return this.currentProject;
    }

    public void setCurrentProject(Project newValue) {
        Project oldValue = this.currentProject;
        this.currentProject = newValue;
        this.firePropertyChange("currentProject", oldValue, newValue);
    }

    @Override
    public boolean isSharingToolsAmongProjects() {
        return true;
    }

    @Override
    public Component getComponent() {
        return this.parentFrame;
    }

    protected Component wrapDesktopPane(Component c, LinkedList<Action> toolBarActions) {
        if (this.getModel() != null) {
            int id = 0;
            for (JToolBar tb : new ReversedList<JToolBar>(this.getModel().createToolBars(this, null))) {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)tb, "North");
                panel.add(c, "Center");
                c = panel;
                PreferencesUtil.installToolBarPrefsHandler(this.prefs, "toolbar." + ++id, tb);
                toolBarActions.addFirst(new ToggleToolBarAction(tb, tb.getName()));
            }
        }
        return c;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar mb = new JMenuBar();
        mb.add(this.createFileMenu());
        for (JMenu mm : this.getModel().createMenus(this, null)) {
            mb.add(mm);
        }
        mb.add(this.createWindowMenu());
        mb.add(this.createHelpMenu());
        return mb;
    }

    protected JMenu createFileMenu() {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        ApplicationModel mo = this.getModel();
        JMenuBar mb = new JMenuBar();
        JMenu m = new JMenu();
        labels.configureMenu(m, "file");
        m.add(mo.getAction("new"));
        m.add(mo.getAction("open"));
        final JMenu openRecentMenu = new JMenu();
        labels.configureMenu(openRecentMenu, "openRecent");
        openRecentMenu.add(mo.getAction("clearRecentFiles"));
        this.updateOpenRecentMenu(openRecentMenu);
        m.add(openRecentMenu);
        m.addSeparator();
        m.add(mo.getAction("close"));
        m.add(mo.getAction("save"));
        m.add(mo.getAction("saveAs"));
        if (mo.getAction("export") != null) {
            JMenuItem jMenuItem = m.add(mo.getAction("export"));
        }
        if (mo.getAction("print") != null) {
            m.addSeparator();
            m.add(mo.getAction("print"));
        }
        m.addSeparator();
        m.add(mo.getAction("exit"));
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                ApplicationModel mo = DefaultMDIApplication.this.getModel();
                if (name == "recentFiles") {
                    DefaultMDIApplication.this.updateOpenRecentMenu(openRecentMenu);
                }
            }
        });
        return m;
    }

    private void updateOpenRecentMenu(JMenu openRecentMenu) {
        if (openRecentMenu.getItemCount() > 0) {
            JMenuItem clearRecentFilesItem = openRecentMenu.getItem(openRecentMenu.getItemCount() - 1);
            openRecentMenu.removeAll();
            for (File f : this.recentFiles()) {
                openRecentMenu.add(new OpenRecentAction(this, f));
            }
            if (this.recentFiles().size() > 0) {
                openRecentMenu.addSeparator();
            }
            openRecentMenu.add(clearRecentFilesItem);
        }
    }

    protected JMenu createWindowMenu() {
        JMenu m;
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        ApplicationModel mo = this.getModel();
        final JMenu windowMenu = m = new JMenu();
        labels.configureMenu(m, "window");
        m.add(mo.getAction("arrangeCascade"));
        m.add(mo.getAction("arrangeVertical"));
        m.add(mo.getAction("arrangeHorizontal"));
        m.addSeparator();
        for (Project pr : this.projects()) {
            if (pr.getAction("focus") == null) continue;
            windowMenu.add(pr.getAction("focus"));
        }
        if (this.toolBarActions.size() > 0) {
            m.addSeparator();
            for (Action a : this.toolBarActions) {
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                Actions.configureJCheckBoxMenuItem(cbmi, a);
                m.add(cbmi);
            }
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                ApplicationModel mo = DefaultMDIApplication.this.getModel();
                if (name == "projectCount") {
                    JMenu m = windowMenu;
                    m.removeAll();
                    m.add(mo.getAction("arrangeCascade"));
                    m.add(mo.getAction("arrangeVertical"));
                    m.add(mo.getAction("arrangeHorizontal"));
                    m.addSeparator();
                    for (Project pr : DefaultMDIApplication.this.projects()) {
                        if (pr.getAction("focus") == null) continue;
                        m.add(pr.getAction("focus"));
                    }
                    if (DefaultMDIApplication.this.toolBarActions.size() > 0) {
                        m.addSeparator();
                        for (Action a : DefaultMDIApplication.this.toolBarActions) {
                            JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                            Actions.configureJCheckBoxMenuItem(cbmi, a);
                            m.add(cbmi);
                        }
                    }
                }
            }
        });
        return m;
    }

    protected JMenu createHelpMenu() {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        ApplicationModel mo = this.getModel();
        JMenu m = new JMenu();
        labels.configureMenu(m, labels.getString("help"));
        m.add(mo.getAction("about"));
        return m;
    }
}

