/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientKeepAlive
implements Runnable,
IObservable {
    private static Logger log = LoggerFactory.getLogger(ClientKeepAlive.class);
    private AtomicReference<OMEROMetadataStoreClient> client = new AtomicReference();
    private final ArrayList<IObserver> observers = new ArrayList();
    private AtomicBoolean notified = new AtomicBoolean(false);

    @Override
    public void run() {
        OMEROMetadataStoreClient client2 = this.client.get();
        if (client2 == null) {
            log.warn("No client for keep alive");
            return;
        }
        try {
            log.debug("pinging");
            client2.ping();
        }
        catch (Throwable t) {
            log.error("Exception while executing ping(), logging Connector out: ", t);
            try {
                this.notifyLogout();
                client2.logout();
            }
            catch (Exception e) {
                log.error("Nested error on client.logout() while handling exception from ping()", (Throwable)e);
            }
        }
    }

    public void notifyLogout() {
        if (this.notified.compareAndSet(false, true)) {
            this.notifyObservers(new ImportEvent.LOGGED_OUT());
        }
    }

    public OMEROMetadataStoreClient getClient() {
        return this.client.get();
    }

    public void setClient(OMEROMetadataStoreClient client2) {
        this.client.set(client2);
    }

    @Override
    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    @Override
    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    @Override
    public void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            try {
                observer.update(this, event);
            }
            catch (Exception e) {
                log.error(e.toString());
            }
        }
    }
}

