/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.configuration;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import ome.model.units.UnitEnum;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.MDEHelper;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleConfiguration;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleController;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleList;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleTreeElement;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.XMLWriter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.configuration.TagNames;

public class MDEConfiguration {
    LinkedHashMap<String, ModuleList> hConfiguration;
    public static final String UNIVERSAL = "Universal";
    HashMap<String, ModuleContent> oDefinition;
    LinkedHashMap<String, HashMap<String, ModuleConfiguration>> oConfiguration;
    private HashMap<String, UnitEnum> defaultUnitMap;
    private DefaultMutableTreeNode standardTree;
    private String configPath;

    public MDEConfiguration(String configPath) {
        this.defaultUnitMap = new HashMap();
        this.configPath = configPath;
        for (Map.Entry<String, UnitEnum> entry : TagNames.omeUnitEnumsDef.entrySet()) {
            this.defaultUnitMap.put(entry.getKey(), entry.getValue());
        }
        this.parse(configPath);
        ModuleController c = ModuleController.getInstance();
        if (this.oDefinition == null || this.oDefinition.isEmpty()) {
            ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] can't parse object definitions from conf file!");
            this.oDefinition = c.initDefaultOMEObjects();
        }
    }

    public void addDefaultUnit(String unitSymbol, String className, String tagName, String parent) {
        UnitEnum u;
        if (this.defaultUnitMap != null && !this.defaultUnitMap.containsKey(parent + "::" + tagName) && (u = TagNames.getUnitEnum(className, unitSymbol)) != null) {
            this.defaultUnitMap.put(parent + "::" + tagName, u);
        }
    }

    public String getStandardUnitSymbolByName(String parent, String tagName) {
        if (this.defaultUnitMap != null && this.defaultUnitMap.containsKey(parent + "::" + tagName) && this.defaultUnitMap.get(parent + "::" + tagName) != null) {
            return this.defaultUnitMap.get(parent + "::" + tagName).getSymbol();
        }
        return "";
    }

    public MDEConfiguration(MDEConfiguration orig) {
        this.hConfiguration = new LinkedHashMap();
        this.oConfiguration = new LinkedHashMap();
        this.oDefinition = new HashMap();
        if (orig.hConfiguration != null) {
            for (Map.Entry<String, Object> entry : orig.hConfiguration.entrySet()) {
                this.hConfiguration.put(entry.getKey(), new ModuleList((ModuleList)entry.getValue()));
            }
        }
        if (orig.oDefinition != null) {
            for (Map.Entry<String, Object> entry : orig.oDefinition.entrySet()) {
                this.oDefinition.put(entry.getKey(), new ModuleContent((ModuleContent)entry.getValue()));
            }
        }
        if (orig.oConfiguration != null) {
            for (Map.Entry<String, Object> entry : orig.oConfiguration.entrySet()) {
                HashMap<String, ModuleConfiguration> list = new HashMap<String, ModuleConfiguration>();
                if (entry.getValue() != null) {
                    for (Map.Entry c : ((HashMap)entry.getValue()).entrySet()) {
                        list.put((String)c.getKey(), new ModuleConfiguration((ModuleConfiguration)c.getValue()));
                    }
                }
                this.oConfiguration.put(entry.getKey(), list);
            }
        }
        this.defaultUnitMap = new HashMap();
        if (orig.defaultUnitMap != null) {
            for (Map.Entry<String, Object> entry : orig.defaultUnitMap.entrySet()) {
                String uClass = TagNames.getUnitClassFromSymbol(((UnitEnum)entry.getValue()).getSymbol()) != null ? TagNames.getUnitClassFromSymbol(((UnitEnum)entry.getValue()).getSymbol()).getName() : null;
                UnitEnum uEnum = TagNames.getUnitEnum(uClass, ((UnitEnum)entry.getValue()).getSymbol());
                this.defaultUnitMap.put(entry.getKey(), uEnum);
            }
        }
    }

    public void initPredefinitionsForMicroscope(String micName, ModuleList conf) {
        if (this.hConfiguration != null) {
            this.hConfiguration.put(micName, conf);
        }
        if (!this.oConfiguration.containsKey(micName)) {
            this.oConfiguration.put(micName, this.getDefaultProperties());
        }
    }

    private HashMap<String, ModuleConfiguration> getDefaultProperties() {
        if (this.oDefinition == null) {
            return null;
        }
        HashMap<String, ModuleConfiguration> list = new HashMap<String, ModuleConfiguration>();
        for (Map.Entry<String, ModuleContent> entry : this.oDefinition.entrySet()) {
            if (entry.getValue() == null) continue;
            list.put(entry.getKey(), entry.getValue().getProperties());
        }
        return list;
    }

    public void setPredefinitionsForMicroscope(String micName, String objectName, List<ModuleContent> predefineObjectList) {
        if (this.hConfiguration != null) {
            ModuleList hardware = this.hConfiguration.get(micName);
            if (hardware == null) {
                hardware = new ModuleList();
            }
            hardware.put(objectName, predefineObjectList);
            this.hConfiguration.put(micName, hardware);
        }
    }

    public void removeAllPredefsForMicroscope(String micName) {
        if (this.hConfiguration != null && !micName.equals(UNIVERSAL)) {
            this.hConfiguration.remove(micName);
        }
    }

    public void removePredefsOfObjectForMicroscope(String objType, String micName) {
        ModuleList list;
        if (this.hConfiguration != null && !micName.equals(UNIVERSAL) && (list = this.hConfiguration.get(micName)) != null) {
            list.remove(objType);
            this.hConfiguration.put(micName, list);
        }
    }

    public ModuleList getPredefinitions(String micName) {
        if (this.hConfiguration != null && !this.hConfiguration.isEmpty()) {
            return this.hConfiguration.get(micName);
        }
        return null;
    }

    public HashMap<String, ModuleConfiguration> getConfiguratedObjects(String micName) {
        if (this.oConfiguration != null && !this.oConfiguration.isEmpty()) {
            return this.oConfiguration.get(micName);
        }
        return null;
    }

    public void removeObjectForMicroscope(String objName, String mic) {
        if (this.oConfiguration == null || this.oConfiguration.get(mic) == null) {
            return;
        }
        this.oConfiguration.get(mic).remove(objName);
        if (this.hConfiguration == null || this.hConfiguration.get(mic) == null) {
            return;
        }
        this.hConfiguration.get(mic).remove(objName);
    }

    public void addConfiguration(String micName, String objectType, ModuleConfiguration conf) {
        if (this.oConfiguration == null) {
            this.oConfiguration = new LinkedHashMap();
        }
        if (this.oConfiguration.get(micName) == null) {
            HashMap<String, ModuleConfiguration> list = new HashMap<String, ModuleConfiguration>();
            list.put(objectType, conf);
            this.oConfiguration.put(micName, list);
        } else if (!this.configurationExists(micName, objectType)) {
            this.oConfiguration.get(micName).put(objectType, conf);
        }
    }

    public void setConfiguration(String micName, String objectType, ModuleConfiguration conf) {
        if (this.oConfiguration == null) {
            this.oConfiguration = new LinkedHashMap();
        }
        if (this.oConfiguration.get(micName) == null) {
            HashMap<String, ModuleConfiguration> list = new HashMap<String, ModuleConfiguration>();
            list.put(objectType, conf);
            this.oConfiguration.put(micName, list);
        } else {
            this.oConfiguration.get(micName).put(objectType, conf);
        }
    }

    public boolean contentExists(String type) {
        return this.oDefinition != null && this.oDefinition.get(type) != null;
    }

    public Boolean isContainer(String type) {
        if (this.oDefinition == null || this.oDefinition.get(type) == null) {
            return null;
        }
        return this.oDefinition.get(type).isContainer();
    }

    public boolean configurationExists(String micName, String type) {
        if (micName.equals(UNIVERSAL) && this.oDefinition != null && this.oDefinition.get(type) != null) {
            return true;
        }
        return this.oConfiguration != null && this.oConfiguration.get(micName) != null && this.oConfiguration.get(micName).containsKey(type);
    }

    public void addConfiguration(String micName, HashMap<String, ModuleConfiguration> contList) {
        if (this.oConfiguration == null) {
            this.oConfiguration = new LinkedHashMap();
        }
        this.oConfiguration.put(micName, contList);
        if (this.hConfiguration == null) {
            this.hConfiguration = new LinkedHashMap();
        }
        if (!this.hConfiguration.containsKey(micName)) {
            this.hConfiguration.put(micName, null);
        }
    }

    private void printDefinedObjects() {
        if (this.oDefinition == null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "-- PRINT Content List: list is empty");
        } else {
            for (Map.Entry<String, ModuleContent> entry : this.oDefinition.entrySet()) {
                if (entry.getValue() != null && entry.getValue().getList() != null) {
                    entry.getValue().print();
                    continue;
                }
                ImporterAgent.getRegistry().getLogger().debug((Object)this, "-- PRINT ModuleContent: Content " + entry.getKey() + " elements: 0");
            }
        }
    }

    public ModuleConfiguration getConfiguration(String micName, String type) {
        if (this.oConfiguration != null && !this.oConfiguration.isEmpty() && this.oConfiguration.get(micName) != null) {
            return this.oConfiguration.get(micName).get(type);
        }
        return null;
    }

    public ModuleContent getContent(String micName, String type) {
        if (this.oDefinition == null || this.oDefinition.get(type) == null) {
            if (!type.equals("OME-Model")) {
                ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] content of type " + type + " NOT exists!");
            }
            return null;
        }
        if (micName.equals(UNIVERSAL)) {
            return new ModuleContent(this.oDefinition.get(type));
        }
        ModuleContent content = new ModuleContent(this.oDefinition.get(type));
        if (this.oConfiguration != null && !this.oConfiguration.isEmpty()) {
            HashMap<String, ModuleConfiguration> map = this.oConfiguration.get(micName);
            if (map == null || map.get(type) == null) {
                ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] Configurator: does not exists:  content of type: " + type + "::" + micName);
                return null;
            }
            content.setProperties(map.get(type));
            return content;
        }
        ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] Configurator: objectConfiguration is empty");
        return null;
    }

    private HashMap<String, ModuleContent> getContentList(String micName) {
        if (this.oDefinition == null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] NO object specifications exists!");
            return null;
        }
        if (micName.equals(UNIVERSAL)) {
            return this.oDefinition;
        }
        if (this.oConfiguration != null && !this.oConfiguration.isEmpty() && this.oConfiguration.get(micName) != null) {
            HashMap<String, ModuleContent> list = new HashMap<String, ModuleContent>();
            for (Map.Entry<String, ModuleConfiguration> entry : this.oConfiguration.get(micName).entrySet()) {
                ModuleContent cont = new ModuleContent(this.oDefinition.get(entry.getKey()));
                cont.setProperties(entry.getValue());
                list.put(entry.getKey(), cont);
            }
            return list;
        }
        return null;
    }

    public HashMap<String, ModuleContent> getAvailableContentList(String mic) {
        return this.getContentList(mic);
    }

    public String[] getMicNames() {
        if (this.oConfiguration != null) {
            return this.oConfiguration.keySet().toArray(new String[this.oConfiguration.size()]);
        }
        return null;
    }

    public void parse(String configPath) {
        XMLWriter writer = new XMLWriter();
        writer.parseConfiguration(configPath);
        this.hConfiguration = writer.getHardwareConfiguration();
        this.oConfiguration = writer.getObjectConfiguration();
        this.oDefinition = writer.getObjectDefinition();
    }

    public void writeToFile(String configPath) {
        XMLWriter writer = new XMLWriter();
        writer.saveToXML(this.hConfiguration, this.oDefinition, this.oConfiguration, configPath);
    }

    public String[] getNameOfObjects() {
        if (this.oDefinition == null || this.oDefinition.isEmpty()) {
            return null;
        }
        return this.oDefinition.keySet().toArray(new String[this.oDefinition.size()]);
    }

    public DefaultMutableTreeNode getTree(String micName) {
        if (micName.equals(UNIVERSAL)) {
            return this.getStandardTree(micName);
        }
        return this.getCustomTree(micName);
    }

    public void printObjects(String mic) {
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "------------  Objects for " + mic + " -------------");
        if (mic.equals(UNIVERSAL)) {
            for (Map.Entry<String, ModuleContent> entry : this.oDefinition.entrySet()) {
                ImporterAgent.getRegistry().getLogger().debug((Object)this, "\t" + entry.getKey());
            }
        } else {
            if (this.oConfiguration == null || !this.oConfiguration.containsKey(mic) || this.oConfiguration.get(mic) == null) {
                ImporterAgent.getRegistry().getLogger().debug((Object)this, "\tNONE");
                return;
            }
            for (Map.Entry<String, ModuleConfiguration> entry : this.oConfiguration.get(mic).entrySet()) {
                ImporterAgent.getRegistry().getLogger().debug((Object)this, "\t" + entry.getKey());
            }
        }
    }

    public void createNewObject(String mic, String obj) {
    }

    private DefaultMutableTreeNode getCustomTree(String micName) {
        DefaultMutableTreeNode cTree = this.getStandardTree(UNIVERSAL);
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] load custom tree for " + micName);
        HashMap<String, ModuleConfiguration> confMap = this.getConfiguratedObjects(micName);
        if (confMap != null) {
            for (Map.Entry<String, ModuleConfiguration> entry : confMap.entrySet()) {
                String pType;
                List<DefaultMutableTreeNode> insertAtNodeList;
                if (entry.getValue() == null || !entry.getValue().isInsertInTree() || (insertAtNodeList = MDEHelper.getChildsByType(cTree, pType = entry.getValue().getInsertPoint())) == null) continue;
                for (DefaultMutableTreeNode insertAtNode : insertAtNodeList) {
                    if (MDEHelper.getListOfChilds(entry.getKey(), insertAtNode) != null) continue;
                    ModuleContent c = this.getContent(micName, entry.getKey());
                    if (!pType.equals("OME-Model") && !this.configurationExists(micName, pType) || c == null || !c.hasParent(pType)) continue;
                    ModuleTreeElement choice = null;
                    choice = c.getList() == null ? new ModuleTreeElement(c, insertAtNode) : new ModuleTreeElement(entry.getKey(), null, "", c, insertAtNode);
                    insertAtNode.add(new DefaultMutableTreeNode(choice));
                }
            }
        }
        return cTree;
    }

    private DefaultMutableTreeNode getStandardTree(String micName) {
        ModuleTreeElement exp;
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] load standard tree for " + micName);
        DefaultMutableTreeNode tree = new DefaultMutableTreeNode(new ModuleTreeElement(null, null));
        ModuleTreeElement img = this.createElement("OME:Image", this.standardTree, micName);
        if (img != null) {
            ModuleTreeElement channel;
            ModuleTreeElement imgEnv;
            DefaultMutableTreeNode image = new DefaultMutableTreeNode(img);
            tree.add(image);
            ModuleTreeElement obj = this.createElement("OME:Objective", image, micName);
            if (obj != null) {
                image.add(new DefaultMutableTreeNode(obj));
            }
            if ((imgEnv = this.createElement("OME:ImagingEnvironment", image, micName)) != null) {
                image.add(new DefaultMutableTreeNode(imgEnv));
            }
            if ((channel = this.createElement("OME:Channel", image, micName)) != null) {
                ModuleTreeElement lp;
                ModuleTreeElement lightSrc;
                DefaultMutableTreeNode ch = new DefaultMutableTreeNode(channel);
                image.add(ch);
                ModuleTreeElement detector = this.createElement("OME:Detector", ch, micName);
                if (detector != null) {
                    ch.add(new DefaultMutableTreeNode(detector));
                }
                if ((lightSrc = this.createElement("OME:LightSource", ch, micName)) != null) {
                    DefaultMutableTreeNode lightSrcNode = new DefaultMutableTreeNode(lightSrc);
                    ch.add(lightSrcNode);
                    ModuleTreeElement laser = this.createElement("OME:Laser", lightSrcNode, micName);
                    if (laser != null) {
                        lightSrcNode.add(new DefaultMutableTreeNode(laser));
                    }
                }
                if ((lp = this.createElement("OME:LightPath", ch, micName)) != null) {
                    ModuleTreeElement lpEm;
                    ModuleTreeElement dich;
                    DefaultMutableTreeNode lpNode = new DefaultMutableTreeNode(lp);
                    ch.add(lpNode);
                    ModuleTreeElement lpEx = this.createElement("OME:ExcitationFilter", lpNode, micName);
                    if (lpEx != null) {
                        DefaultMutableTreeNode lpExNode = new DefaultMutableTreeNode(lpEx);
                        lpNode.add(lpExNode);
                        ModuleTreeElement filterEx = this.createElement("OME:Filter", lpExNode, micName);
                        if (filterEx != null) {
                            lpExNode.add(new DefaultMutableTreeNode(filterEx));
                        }
                    }
                    if ((dich = this.createElement("OME:Dichroic", lpNode, micName)) != null) {
                        lpNode.add(new DefaultMutableTreeNode(dich));
                    }
                    if ((lpEm = this.createElement("OME:EmissionFilter", lpNode, micName)) != null) {
                        DefaultMutableTreeNode lpEmNode = new DefaultMutableTreeNode(lpEm);
                        lpNode.add(lpEmNode);
                        ModuleTreeElement filterEm = this.createElement("OME:Filter", lpEmNode, micName);
                        if (filterEm != null) {
                            lpEmNode.add(new DefaultMutableTreeNode(filterEm));
                        }
                    }
                }
            }
        }
        if ((exp = this.createElement("OME:Experiment", this.standardTree, micName)) != null) {
            DefaultMutableTreeNode experiment = new DefaultMutableTreeNode(exp);
            tree.add(experiment);
        }
        return tree;
    }

    public ModuleTreeElement createElement(String type, DefaultMutableTreeNode parent, String micName) {
        if (this.getContent(UNIVERSAL, type) == null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] No object content configurate for type  " + type + "[MDEConfiguration::createElement]");
            return null;
        }
        return new ModuleTreeElement(type, null, "", this.getContent(micName, type), parent);
    }
}

