/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer;

import omero.gateway.SecurityContext;
import omero.gateway.model.ExperimenterData;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.DataHandlerView;
import org.openmicroscopy.shoola.env.data.views.DataManagerView;
import org.openmicroscopy.shoola.env.data.views.HierarchyBrowsingView;
import org.openmicroscopy.shoola.env.data.views.ImageDataView;
import org.openmicroscopy.shoola.env.data.views.MetadataHandlerView;

public abstract class DataLoader
extends DSCallAdapter {
    protected final ImViewer viewer;
    protected final Registry registry;
    protected final ImageDataView ivView;
    protected final DataHandlerView dhView;
    protected final MetadataHandlerView mhView;
    protected final DataManagerView dmView;
    protected final HierarchyBrowsingView hiBrwView;
    protected final SecurityContext ctx;

    protected DataLoader(ImViewer viewer, SecurityContext ctx) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        if (ctx == null) {
            throw new NullPointerException("No security context.");
        }
        this.viewer = viewer;
        this.ctx = ctx;
        this.registry = ImViewerAgent.getRegistry();
        this.ivView = (ImageDataView)this.registry.getDataServicesView(ImageDataView.class);
        this.dhView = (DataHandlerView)this.registry.getDataServicesView(DataHandlerView.class);
        this.mhView = (MetadataHandlerView)this.registry.getDataServicesView(MetadataHandlerView.class);
        this.dmView = (DataManagerView)this.registry.getDataServicesView(DataManagerView.class);
        this.hiBrwView = (HierarchyBrowsingView)this.registry.getDataServicesView(HierarchyBrowsingView.class);
    }

    protected long getCurrentUserID() {
        return ((ExperimenterData)this.registry.lookup("/current_user/details")).getId();
    }

    @Override
    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    @Override
    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
        this.registry.getUserNotifier().notifyInfo("Data Retrieval Cancellation", info);
    }

    @Override
    public void handleException(Throwable exc) {
        int state = this.viewer.getState();
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print("State: " + state);
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        if (state != 7) {
            this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
        }
        this.viewer.discard();
    }

    public abstract void load();

    public abstract void cancel();
}

