/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.env.data.model.DataObject;
import org.openmicroscopy.shoola.util.image.geom.Factory;

public class ThumbnailData
implements DataObject {
    private long userID;
    private long imageID;
    private BufferedImage thumbnail;
    private boolean validImage;
    private ImageData image;
    private Boolean requirePyramid;
    private omero.gateway.model.DataObject refObject;
    private Exception error;

    public ThumbnailData(long imageID, Image thumbnail, long userID, boolean validImage) {
        if (imageID <= 0L) {
            throw new IllegalArgumentException("Non-positive image id: " + imageID + ".");
        }
        this.imageID = imageID;
        this.thumbnail = ThumbnailData.toBufferedImage(thumbnail);
        this.userID = userID;
        this.validImage = validImage;
        this.requirePyramid = null;
    }

    public ThumbnailData(long imageID, Image thumbnail, boolean validImage) {
        this(imageID, thumbnail, -1L, validImage);
    }

    public ThumbnailData(omero.gateway.model.DataObject refOjbect, Image thumbnail, boolean validImage) {
        if (refOjbect == null) {
            throw new IllegalArgumentException("No object.");
        }
        if (!(refOjbect instanceof ImageData)) {
            throw new IllegalArgumentException("Type not valid.");
        }
        this.refObject = refOjbect;
        this.validImage = validImage;
        this.thumbnail = ThumbnailData.toBufferedImage(thumbnail);
        this.requirePyramid = null;
    }

    public ThumbnailData(omero.gateway.model.DataObject refOjbect, Boolean requirePyramid) {
        this(refOjbect, null, false);
        this.requirePyramid = requirePyramid;
    }

    public ThumbnailData(omero.gateway.model.DataObject refOjbect, BufferedImage thumbnail) {
        this(refOjbect, (Image)thumbnail, true);
    }

    public void setBackOffForPyramid(Boolean requirePyramid) {
        this.requirePyramid = requirePyramid;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    public Exception getError() {
        return this.error;
    }

    public void setImage(ImageData image) {
        this.image = image;
    }

    @Override
    public DataObject makeNew() {
        BufferedImage pixClone = null;
        if (this.thumbnail != null) {
            pixClone = new BufferedImage(this.thumbnail.getWidth(), this.thumbnail.getHeight(), this.thumbnail.getType());
            Graphics2D g2D = pixClone.createGraphics();
            g2D.drawImage(this.thumbnail, null, 0, 0);
        }
        ThumbnailData data = this.refObject != null ? (this.requirePyramid != null ? new ThumbnailData(this.refObject, this.requirePyramid) : new ThumbnailData(this.refObject, (Image)pixClone, this.validImage)) : new ThumbnailData(this.imageID, pixClone, this.validImage);
        data.setImage(this.image);
        return data;
    }

    public boolean isValidImage() {
        return this.validImage;
    }

    public long getUserID() {
        return this.userID;
    }

    public long getImageID() {
        return this.imageID;
    }

    public BufferedImage getThumbnail() {
        return this.thumbnail;
    }

    public ImageData getImage() {
        return this.image;
    }

    public omero.gateway.model.DataObject getRefObject() {
        return this.refObject;
    }

    public Boolean requirePyramid() {
        if (this.requirePyramid != null) {
            return (boolean)this.requirePyramid;
        }
        return null;
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        return Factory.createImage(img);
    }
}

