/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import ome.model.IObject;
import ome.model.internal.Permissions;
import ome.model.meta.ExperimenterGroup;
import ome.security.ACLVoter;
import ome.security.basic.LightAdminPrivileges;
import ome.services.delete.Deletion;
import ome.services.graphs.GraphPathBean;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphTraversal;
import ome.services.graphs.GroupPredicate;
import ome.services.util.ReadOnlyStatus;
import ome.system.EventContext;
import ome.system.Roles;
import omero.cmd.Chgrp2;
import omero.cmd.Chgrp2Response;
import omero.cmd.ERR;
import omero.cmd.GraphException;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Response;
import omero.cmd.graphs.BaseGraphTraversalProcessor;
import omero.cmd.graphs.GraphHelper;
import omero.cmd.graphs.GraphUtil;
import omero.cmd.graphs.WrappableRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class Chgrp2I
extends Chgrp2
implements IRequest,
ReadOnlyStatus.IsAware,
WrappableRequest<Chgrp2> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Chgrp2I.class);
    private static final ImmutableMap<String, String> ALL_GROUPS_CONTEXT = ImmutableMap.of((Object)"omero.group", (Object)"-1");
    private static final Set<GraphPolicy.Ability> REQUIRED_ABILITIES = ImmutableSet.of((Object)((Object)GraphPolicy.Ability.OWN));
    private final ACLVoter aclVoter;
    private final Roles securityRoles;
    private final GraphPathBean graphPathBean;
    private final LightAdminPrivileges adminPrivileges;
    private final Deletion deletionInstance;
    private final Set<Class<? extends IObject>> targetClasses;
    private GraphPolicy graphPolicy;
    private final SetMultimap<String, String> unnullable;
    private final ApplicationContext applicationContext;
    private List<Function<GraphPolicy, GraphPolicy>> graphPolicyAdjusters = new ArrayList<Function<GraphPolicy, GraphPolicy>>();
    private Helper helper;
    private GraphHelper graphHelper;
    private GraphTraversal graphTraversal;
    private InternalProcessor internalProcessor;
    private GraphTraversal.PlanExecutor unlinker;
    private GraphTraversal.PlanExecutor processor;
    private int targetObjectCount = 0;
    private int deletedObjectCount = 0;
    private int movedObjectCount = 0;

    public Chgrp2I(ACLVoter aclVoter, Roles securityRoles, GraphPathBean graphPathBean, LightAdminPrivileges adminPrivileges, Deletion deletionInstance, Set<Class<? extends IObject>> targetClasses, GraphPolicy graphPolicy, SetMultimap<String, String> unnullable, ApplicationContext applicationContext) {
        this.aclVoter = aclVoter;
        this.securityRoles = securityRoles;
        this.graphPathBean = graphPathBean;
        this.adminPrivileges = adminPrivileges;
        this.deletionInstance = deletionInstance;
        this.targetClasses = targetClasses;
        this.graphPolicy = graphPolicy;
        this.unnullable = unnullable;
        this.applicationContext = applicationContext;
    }

    @Override
    public Map<String, String> getCallContext() {
        return new HashMap<String, String>((Map<String, String>)ALL_GROUPS_CONTEXT);
    }

    @Override
    public void init(Helper helper) {
        if (LOGGER.isDebugEnabled()) {
            GraphUtil.ParameterReporter arguments = new GraphUtil.ParameterReporter();
            arguments.addParameter("groupId", this.groupId);
            arguments.addParameter("targetObjects", this.targetObjects);
            arguments.addParameter("childOptions", (Object)this.childOptions);
            arguments.addParameter("dryRun", this.dryRun);
            LOGGER.debug("request: " + arguments);
        }
        this.helper = helper;
        helper.setSteps(this.dryRun ? 4 : 6);
        this.graphHelper = new GraphHelper(helper, this.graphPathBean);
        EventContext eventContext = helper.getEventContext();
        boolean isChgrpPrivilege = this.graphHelper.checkIsAdministrator(this.adminPrivileges.getPrivilege("Chgrp"));
        if (!isChgrpPrivilege && !eventContext.getMemberOfGroupsList().contains(this.groupId)) {
            IllegalArgumentException e = new IllegalArgumentException("not a member of the chgrp destination group");
            throw helper.cancel(new ERR(), (Throwable)e, "not-in-group", new String[0]);
        }
        ExperimenterGroup destinationGroup = (ExperimenterGroup)helper.getSession().get(ExperimenterGroup.class, (Serializable)Long.valueOf(this.groupId));
        Permissions destinationGroupPermissions = destinationGroup.getDetails().getPermissions();
        boolean isToGroupReadable = destinationGroupPermissions.isGranted(Permissions.Role.GROUP, Permissions.Right.READ);
        if (!isToGroupReadable) {
            this.graphPolicy.setCondition("to_private");
        }
        Set<Object> requiredAbilities = isChgrpPrivilege ? Collections.emptySet() : REQUIRED_ABILITIES;
        this.graphPolicy.registerPredicate(new GroupPredicate(this.securityRoles));
        this.internalProcessor = new InternalProcessor(requiredAbilities);
        this.graphTraversal = this.graphHelper.prepareGraphTraversal(this.childOptions, requiredAbilities, this.graphPolicy, this.graphPolicyAdjusters, this.aclVoter, this.graphPathBean, this.unnullable, this.internalProcessor, this.dryRun);
        if (isChgrpPrivilege) {
            this.graphTraversal.setOwnsAll();
        }
        this.graphPolicyAdjusters = null;
    }

    @Override
    public Object step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        try {
            switch (step) {
                case 0: {
                    SetMultimap<String, Long> targetMultimap = this.graphHelper.getTargetMultimap(this.targetClasses, this.targetObjects);
                    this.targetObjectCount += targetMultimap.size();
                    return this.graphTraversal.planOperation(targetMultimap, true, true);
                }
                case 1: {
                    this.graphTraversal.assertNoPolicyViolations();
                    return null;
                }
                case 2: {
                    this.processor = this.graphTraversal.processTargets();
                    return null;
                }
                case 3: {
                    this.unlinker = this.graphTraversal.unlinkTargets(true);
                    this.graphTraversal = null;
                    return null;
                }
                case 4: {
                    this.unlinker.execute();
                    return null;
                }
                case 5: {
                    this.processor.execute();
                    return null;
                }
            }
            IllegalArgumentException e = new IllegalArgumentException("model object graph operation has no step " + step);
            throw this.helper.cancel(new ERR(), (Throwable)e, "bad-step", new String[0]);
        }
        catch (HandleI.Cancel c) {
            throw c;
        }
        catch (ome.services.graphs.GraphException ge) {
            GraphException graphERR = new GraphException();
            graphERR.message = ge.message;
            throw this.helper.cancel((ERR)graphERR, (Throwable)ge, "graph-fail", new String[0]);
        }
        catch (Throwable t) {
            throw this.helper.cancel(new ERR(), t, "graph-fail", new String[0]);
        }
    }

    @Override
    public void finish() {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (step == 0) {
            Map.Entry result = (Map.Entry)object;
            if (!this.dryRun) {
                try {
                    this.internalProcessor.deleteFiles(this.deletionInstance);
                }
                catch (Exception e) {
                    this.helper.cancel(new ERR(), (Throwable)e, "file-delete-fail", new String[0]);
                }
            }
            Map<String, List<Long>> movedObjects = GraphUtil.copyMultimapForResponse((SetMultimap<String, Long>)((SetMultimap)result.getKey()));
            Map<String, List<Long>> deletedObjects = GraphUtil.copyMultimapForResponse((SetMultimap<String, Long>)((SetMultimap)result.getValue()));
            this.movedObjectCount += ((SetMultimap)result.getKey()).size();
            this.deletedObjectCount += ((SetMultimap)result.getValue()).size();
            Chgrp2Response response = new Chgrp2Response(movedObjects, deletedObjects);
            this.helper.setResponseIfNull(response);
            this.helper.info("in " + (this.dryRun ? "mock " : "") + "chgrp to " + this.groupId + " of " + this.targetObjectCount + ", moved " + this.movedObjectCount + " and deleted " + this.deletedObjectCount + " in total", new Object[0]);
            if (LOGGER.isDebugEnabled()) {
                GraphUtil.ParameterReporter arguments = new GraphUtil.ParameterReporter();
                arguments.addParameter("includedObjects", response.includedObjects);
                arguments.addParameter("deletedObjects", response.deletedObjects);
                LOGGER.debug("response: " + arguments);
            }
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    @Override
    public void copyFieldsTo(Chgrp2 request) {
        GraphUtil.copyFields(this, request);
        request.groupId = this.groupId;
    }

    @Override
    public void adjustGraphPolicy(Function<GraphPolicy, GraphPolicy> adjuster) {
        if (this.graphPolicyAdjusters == null) {
            throw new IllegalStateException("request is already initialized");
        }
        this.graphPolicyAdjusters.add(adjuster);
    }

    @Override
    public int getStepProvidingCompleteResponse() {
        return 0;
    }

    @Override
    public GraphPolicy.Action getActionForStarting() {
        return GraphPolicy.Action.INCLUDE;
    }

    @Override
    public Map<String, List<Long>> getStartFrom(Response response) {
        return ((Chgrp2Response)response).includedObjects;
    }

    @Override
    public boolean isReadOnly(ReadOnlyStatus readOnly) {
        return this.dryRun;
    }

    private final class InternalProcessor
    extends BaseGraphTraversalProcessor {
        private final Logger LOGGER;
        private final ExperimenterGroup group;
        private final Set<GraphPolicy.Ability> requiredAbilities;

        public InternalProcessor(Set<GraphPolicy.Ability> requiredAbilities) {
            super(Chgrp2I.this.helper.getSession());
            this.LOGGER = LoggerFactory.getLogger(InternalProcessor.class);
            this.group = new ExperimenterGroup(Long.valueOf(Chgrp2I.this.groupId), false);
            this.requiredAbilities = requiredAbilities;
        }

        @Override
        public void deleteInstances(String className, Collection<Long> ids) throws ome.services.graphs.GraphException {
            super.deleteInstances(className, ids);
            Chgrp2I.this.graphHelper.publishEventLog(Chgrp2I.this.applicationContext, "DELETE", className, ids);
        }

        @Override
        public void processInstances(String className, Collection<Long> ids) throws ome.services.graphs.GraphException {
            String update = "UPDATE " + className + " SET details.group = :group WHERE id IN (:ids)";
            int count = this.session.createQuery(update).setParameter("group", (Object)this.group).setParameterList("ids", ids).executeUpdate();
            Chgrp2I.this.graphHelper.publishEventLog(Chgrp2I.this.applicationContext, "UPDATE", className, ids);
            if (count != ids.size()) {
                this.LOGGER.warn("not all the objects of type " + className + " could be processed");
            }
        }

        @Override
        public Set<GraphPolicy.Ability> getRequiredPermissions() {
            return this.requiredAbilities;
        }
    }
}

