/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.plaf.basic.ComboPopup;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.CheckableItem;

public class CheckComboBox<E extends CheckableItem>
extends JComboBox<E> {
    private static String ITEM_DELIMETER = ";";
    private boolean keepOpen;
    private transient ActionListener listener;

    protected CheckComboBox() {
    }

    protected CheckComboBox(ComboBoxModel<E> model) {
        super(model);
    }

    protected CheckComboBox(String[] values) {
        CheckableItem[] m = new CheckableItem[values.length];
        for (int i = 0; i < values.length; ++i) {
            m[i] = new CheckableItem(values[i], false);
        }
        this.setModel(new DefaultComboBoxModel<CheckableItem>(m));
    }

    public void init_selectedValues(String[] values) {
        if (values == null || values.length == 0) {
            return;
        }
        List<String> t = values.length == 1 ? Arrays.asList(values[0].split(ITEM_DELIMETER + " ")) : Arrays.asList(values);
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!t.contains(((CheckableItem)this.getItemAt(i)).toString())) continue;
            ((CheckableItem)this.getItemAt(i)).setSelected(true);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 20);
    }

    @Override
    public void updateUI() {
        this.setRenderer(null);
        this.removeActionListener(this.listener);
        super.updateUI();
        this.listener = e -> {
            if (((long)e.getModifiers() & 0x10L) != 0L) {
                this.updateItem(this.getSelectedIndex());
                this.keepOpen = true;
            }
        };
        JLabel label = new JLabel(" ");
        JCheckBox check = new JCheckBox(" ");
        this.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            if (index < 0) {
                String txt = CheckComboBox.getCheckedItemString(list.getModel());
                label.setText(txt.isEmpty() ? " " : txt);
                return label;
            }
            check.setText(Objects.toString(value, ""));
            check.setSelected(value.isSelected());
            if (isSelected) {
                check.setBackground(list.getSelectionBackground());
                check.setForeground(list.getSelectionForeground());
            } else {
                check.setBackground(list.getBackground());
                check.setForeground(list.getForeground());
            }
            return check;
        });
        this.addActionListener(this.listener);
        this.getInputMap(0).put(KeyStroke.getKeyStroke(32, 0), "checkbox-select");
        this.getActionMap().put("checkbox-select", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Accessible a = CheckComboBox.this.getAccessibleContext().getAccessibleChild(0);
                if (a instanceof ComboPopup) {
                    CheckComboBox.this.updateItem(((ComboPopup)((Object)a)).getList().getSelectedIndex());
                }
            }
        });
    }

    private static <E extends CheckableItem> String getCheckedItemString(ListModel<E> model) {
        return IntStream.range(0, model.getSize()).mapToObj(model::getElementAt).filter(CheckableItem::isSelected).map(Objects::toString).sorted().collect(Collectors.joining(ITEM_DELIMETER + " "));
    }

    protected void updateItem(int index) {
        if (this.isPopupVisible()) {
            CheckableItem item;
            item.setSelected(!(item = (CheckableItem)this.getItemAt(index)).isSelected());
            this.setSelectedIndex(-1);
            this.setSelectedItem(item);
        }
    }

    @Override
    public void setPopupVisible(boolean v) {
        if (this.keepOpen) {
            this.keepOpen = false;
        } else {
            super.setPopupVisible(v);
        }
    }

    public String[] getSelectedItemsAsArray() {
        return CheckComboBox.getCheckedItemString(this.getModel()).split(ITEM_DELIMETER);
    }

    public String getSelectedItemsAsString() {
        return CheckComboBox.getCheckedItemString(this.getModel());
    }
}

