/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openmicroscopy.shoola.agents.metadata.util.FigureCanvas;
import org.openmicroscopy.shoola.agents.metadata.util.FigureDialog;
import org.openmicroscopy.shoola.agents.util.ui.ChannelButton;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class FigureComponent
extends JPanel
implements PropertyChangeListener {
    static final Dimension DEFAULT_SIZE = new Dimension(16, 16);
    private FigureCanvas canvas;
    private JLayeredPane pane;
    private JTextField field;
    private JCheckBox box;
    private List<ChannelButton> buttons;
    private BufferedImage image;
    private BufferedImage greyImage;
    private BufferedImage displayedImage;
    private FigureDialog model;
    private boolean single;

    private void initComponents(String name) {
        this.field = new JTextField(name);
        Font f = this.field.getFont();
        this.field.setFont(f.deriveFont(f.getStyle(), 10.0f));
        this.field.setColumns(8);
        this.canvas = new FigureCanvas();
        this.pane = new JLayeredPane();
        this.pane.add((Component)this.canvas, (Object)0);
        this.box = new JCheckBox("Channel names");
        this.box.setToolTipText("Label the merged panel with channel names if selected. Otherwise label with 'Merged'.");
        this.box.setBorder(null);
    }

    private void buildGUI() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        Iterator<ChannelButton> i = this.buttons.iterator();
        while (i.hasNext()) {
            p.add(i.next());
            p.add(Box.createHorizontalStrut(2));
        }
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        if (!this.single) {
            controls.add(UIUtilities.buildComponentPanel(this.box, 5, 4));
        } else {
            controls.add(this.field);
        }
        controls.add(UIUtilities.buildComponentPanel(p));
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)UIUtilities.buildComponentPanel(controls, 0, 0), "North");
        this.add((Component)UIUtilities.buildComponentPanelCenter(this.pane), "Center");
    }

    FigureComponent(FigureDialog model, Color color, String name, int index) {
        this.model = model;
        this.single = true;
        ChannelButton b = new ChannelButton("", color, index);
        b.setPreferredSize(DEFAULT_SIZE);
        b.addPropertyChangeListener(this);
        this.buttons = new ArrayList<ChannelButton>();
        this.buttons.add(b);
        this.initComponents(name);
        this.buildGUI();
    }

    FigureComponent(FigureDialog model, List<ChannelButton> channels) {
        this.model = model;
        this.single = false;
        this.buttons = channels;
        this.initComponents("Merged");
        this.buildGUI();
    }

    void addToView(JComponent component) {
        if (component != null) {
            Dimension d = this.pane.getPreferredSize();
            component.setPreferredSize(d);
            component.setSize(d);
            this.pane.add((Component)component, (Object)1);
        }
    }

    String getLabel() {
        String value = this.field.getText();
        if (value == null || value.trim().length() == 0) {
            if (this.single) {
                ChannelButton b = this.buttons.get(0);
                return "" + b.getChannelIndex();
            }
            return "Merged";
        }
        return value.trim();
    }

    boolean isChannelsName() {
        if (this.single) {
            return false;
        }
        return this.box.isSelected();
    }

    void resetImage(boolean grey) {
        if (this.image == null || !this.single) {
            return;
        }
        ChannelButton button = this.buttons.get(0);
        Color color = button.getColor();
        if (grey) {
            if (this.greyImage == null) {
                int r = color.getRed();
                int g = color.getGreen();
                int b = color.getBlue();
                int mask = -1;
                if (r == 255 && g == 0 && b == 0) {
                    mask = 0xFF0000;
                } else if (r == 0 && g == 255 && b == 0) {
                    mask = 65280;
                } else if (r == 0 && g == 0 && b == 255) {
                    mask = 255;
                }
                if (mask != -1) {
                    DataBuffer buf = this.image.getRaster().getDataBuffer();
                    this.greyImage = Factory.createBandImage(buf, this.image.getWidth(), this.image.getHeight(), mask, mask, mask);
                } else {
                    this.greyImage = this.model.createSingleGreyScaleImage(button.getChannelIndex());
                }
            }
            this.displayedImage = this.greyImage;
        } else {
            this.displayedImage = this.image;
        }
        this.canvas.setImage(this.displayedImage);
    }

    void setOriginalImage(BufferedImage image) {
        this.image = image;
        this.displayedImage = image;
        this.greyImage = null;
        this.canvas.setImage(image);
    }

    void setCanvasSize(int width, int height) {
        Dimension d = new Dimension(width, height);
        this.pane.setPreferredSize(d);
        this.pane.setSize(d);
        Component[] comps = this.pane.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setPreferredSize(d);
            comps[i].setSize(d);
        }
    }

    boolean isSelected() {
        if (this.buttons.size() != 1) {
            return false;
        }
        ChannelButton b = this.buttons.get(0);
        return b.isSelected();
    }

    void setSelected(boolean selected) {
        if (this.buttons.size() != 1) {
            return;
        }
        ChannelButton b = this.buttons.get(0);
        b.setSelected(selected);
        b.repaint();
    }

    List<ChannelButton> getChannels() {
        return this.buttons;
    }

    BufferedImage getDisplayedImage() {
        return this.displayedImage;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.field.setEnabled(enabled);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ChannelButton button;
        Map m;
        Boolean b;
        String name = evt.getPropertyName();
        if ("channelSelected".equals(name) && this.single && (b = (Boolean)(m = (Map)evt.getNewValue()).get((button = this.buttons.get(0)).getChannelIndex())) != null) {
            button.setSelected(b);
            this.model.setChannelSelection(button.getChannelIndex(), b, false);
            this.canvas.setImageVisible(b);
        }
    }
}

