/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import omero.gateway.model.DataObject;
import omero.gateway.model.FolderData;
import org.apache.commons.lang3.StringUtils;

public class SelectionDialog
extends JDialog
implements ActionListener {
    public static String OBJECT_SELECTION_PROPERTY = "OBJECT_SELECTION_PROPERTY";
    public static String NONE_SELECTION_PROPERTY = "NONE_SELECTION_PROPERTY";
    private Collection<DataObject> selection;
    private String text;
    private JButton okButton;
    private JButton cancelButton;
    private JList list;
    private boolean addNoneItem = false;

    public SelectionDialog(Collection<DataObject> selection, String title, String text) {
        this(null, false, selection, title, text, false);
    }

    public SelectionDialog(Collection<DataObject> selection, String title, String text, boolean addNoneItem) {
        this(null, false, selection, title, text, addNoneItem);
    }

    public SelectionDialog(Frame owner, Collection<DataObject> selection, String title, String text, boolean addNoneItem) {
        this(owner, false, selection, title, text, addNoneItem);
    }

    public SelectionDialog(Frame owner, boolean modal, Collection<DataObject> selection, String title, String text, boolean addNoneItem) {
        super(owner, modal);
        this.setTitle(title);
        this.selection = selection;
        this.text = text;
        this.addNoneItem = addNoneItem;
        this.initUI();
    }

    void initUI() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(3, 3));
        if (StringUtils.isNotEmpty((CharSequence)this.text)) {
            p.add((Component)new JLabel(this.text), "North");
        }
        Object[] items = null;
        int i = -1;
        if (this.addNoneItem) {
            items = new DataObjectWrapper[this.selection.size() + 1];
            items[0] = new DataObjectWrapper();
            i = 1;
        } else {
            items = new DataObjectWrapper[this.selection.size()];
            i = 0;
        }
        Iterator<DataObject> it = this.selection.iterator();
        while (it.hasNext()) {
            items[i++] = new DataObjectWrapper(it.next());
        }
        Arrays.sort(items);
        this.list = new JList<Object>(items);
        p.add((Component)new JScrollPane(this.list), "Center");
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton("Ok");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        p.add((Component)buttonPanel, "South");
        p.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.getContentPane().add(p);
        this.pack();
        this.setSize(300, 400);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataObjectWrapper obj;
        if (e.getSource() == this.okButton && (obj = (DataObjectWrapper)this.list.getSelectedValue()) != null) {
            if (obj.object == null) {
                this.firePropertyChange(NONE_SELECTION_PROPERTY, true, false);
            } else {
                this.firePropertyChange(OBJECT_SELECTION_PROPERTY, null, obj.object);
            }
        }
        this.setVisible(false);
    }

    class DataObjectWrapper
    implements Comparable<DataObjectWrapper> {
        DataObject object;

        DataObjectWrapper() {
        }

        DataObjectWrapper(DataObject object) {
            this.object = object;
        }

        public String toString() {
            if (this.object == null) {
                return "--NONE--";
            }
            if (this.object instanceof FolderData) {
                return ((FolderData)this.object).getFolderPathString();
            }
            return this.object.toString();
        }

        @Override
        public int compareTo(DataObjectWrapper o) {
            if (this.object == null) {
                return -1;
            }
            if (o.object == null) {
                return 1;
            }
            if (this.object instanceof FolderData) {
                return ((FolderData)this.object).getFolderPathString().toLowerCase().compareTo(((FolderData)o.object).getFolderPathString().toLowerCase());
            }
            return 0;
        }
    }
}

