/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import omero.RType;
import omero.cmd.OriginalMetadataResponse;
import org.openmicroscopy.shoola.env.data.util.ModelMapper;
import org.openmicroscopy.shoola.util.CommonsLangUtils;

public class OriginalMetadataParser {
    private final File file;

    private String writeMap(Map<String, RType> map, String separator) {
        if (map == null || map.size() == 0) {
            return null;
        }
        if (CommonsLangUtils.isBlank(separator)) {
            separator = " ";
        }
        TreeSet<String> sortedSet = new TreeSet<String>(map.keySet());
        Iterator<String> j = sortedSet.iterator();
        StringBuffer buffer = new StringBuffer();
        while (j.hasNext()) {
            Object l;
            String key = j.next();
            buffer.append(key);
            buffer.append(separator);
            Object v = ModelMapper.convertRTypeToJava(map.get(key));
            if (v instanceof List) {
                l = (List)v;
                Iterator k = l.iterator();
                while (k.hasNext()) {
                    buffer.append(k.next());
                    buffer.append(" ");
                }
            } else if (v instanceof Map) {
                l = (Map)v;
                for (Map.Entry e : l.entrySet()) {
                    buffer.append((String)e.getKey());
                    buffer.append(separator);
                    buffer.append(e.getValue());
                }
            } else {
                buffer.append(v.toString());
            }
            buffer.append(System.getProperty("line.separator"));
        }
        return buffer.toString();
    }

    public OriginalMetadataParser(File file) {
        if (file == null) {
            throw new IllegalArgumentException("No file to write the content to.");
        }
        this.file = file;
    }

    public void read(OriginalMetadataResponse response) throws Exception {
        this.read(response, null);
    }

    public void read(OriginalMetadataResponse response, String separator) throws Exception {
        Writer writer = null;
        BufferedWriter bufferWriter = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, true), "UTF-8");
            bufferWriter = new BufferedWriter(writer);
            StringBuffer buffer = new StringBuffer();
            String value = this.writeMap(response.globalMetadata, separator);
            if (value != null) {
                buffer.append("[GlobalMetadata]");
                buffer.append(System.getProperty("line.separator"));
                buffer.append(this.writeMap(response.globalMetadata, separator));
                buffer.append(System.getProperty("line.separator"));
            }
            if ((value = this.writeMap(response.seriesMetadata, separator)) != null) {
                buffer.append("[SeriesMetadata]");
                buffer.append(System.getProperty("line.separator"));
                buffer.append(this.writeMap(response.seriesMetadata, separator));
            }
            bufferWriter.write(buffer.toString());
        }
        catch (Exception e) {
            throw new Exception("An error while reading/writing the content.");
        }
        finally {
            if (bufferWriter != null) {
                bufferWriter.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }
}

