/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import omero.gateway.SecurityContext;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.DownloadArchivedActivityParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.ArchivedLoader;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class DownloadArchivedActivity
extends ActivityComponent {
    private static final String DESCRIPTION_CREATED = "Original Image(s) downloaded";
    private static final String DESCRIPTION_CANCEL = "Download Original Image cancelled";
    private static final String DESCRIPTION_NO_ARCHIVED = "No Image downloaded";
    private static final String OPTION_NO_ARCHIVED = "Check logs for details";
    private DownloadArchivedActivityParam parameters;

    DownloadArchivedActivity(UserNotifier viewer, Registry registry, SecurityContext ctx, DownloadArchivedActivityParam parameters) {
        super(viewer, registry, ctx);
        if (parameters == null) {
            throw new IllegalArgumentException("No parameters");
        }
        this.parameters = parameters;
        this.initialize("Downloading Original Image(s)", parameters.getIcon());
        File f = parameters.getLocation();
        if (f.isFile() || !f.exists()) {
            f = f.getParentFile();
        }
        this.messageLabel.setText("in " + f.getAbsolutePath());
        this.parameters = parameters;
    }

    @Override
    protected UserNotifierLoader createLoader() {
        File f = this.parameters.getLocation();
        this.loader = new ArchivedLoader(this.viewer, this.registry, this.ctx, this.parameters.getImages(), f, this.parameters.isOverride(), this.parameters.isZip(), this);
        return this.loader;
    }

    @Override
    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    @Override
    protected void notifyActivityEnd() {
        List files = (List)this.result;
        if (CollectionUtils.isEmpty((Collection)files)) {
            this.type.setText(DESCRIPTION_NO_ARCHIVED);
            this.messageLabel.setText(OPTION_NO_ARCHIVED);
            return;
        }
        this.type.setText(DESCRIPTION_CREATED);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>into ");
        HashSet<String> locations = new HashSet<String>();
        Pattern p = Pattern.compile("(.+Fileset_\\d+).*");
        for (File f : files) {
            Matcher m = p.matcher(f.getAbsolutePath());
            if (m.matches()) {
                locations.add(m.group(1));
                continue;
            }
            locations.add(f.getAbsolutePath());
        }
        ArrayList sorted = new ArrayList(locations);
        Collections.sort(sorted);
        for (String loc : sorted) {
            buffer.append(loc + "<br/>");
        }
        buffer.append("</html>");
        this.messageLabel.setText(buffer.toString());
    }

    @Override
    protected void notifyActivityError() {
    }
}

