/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourSlider;
import org.openmicroscopy.shoola.util.ui.colourpicker.LookupTableItem;
import org.openmicroscopy.shoola.util.ui.colourpicker.LookupTableListRenderer;
import org.openmicroscopy.shoola.util.ui.colourpicker.RGBControl;

public class ColourSwatchUI
extends JPanel {
    private RGBControl control;
    private JList colourlist;
    private JScrollPane scrollpane;
    private ColourSlider alphaSlider;
    private ChangeListener alphaChangeListener;
    private ListSelectionListener selectionListener;
    private JTextField alphaTextbox;
    private JLabel alphaLabel;
    private ActionListener alphaTextboxActionListener;
    private boolean active;
    private Object[] items;

    private void createAlphaSlider() {
        Color s1 = this.control.getColour();
        Color s = new Color(s1.getRed(), s1.getGreen(), s1.getBlue(), 0);
        Color e1 = this.control.getColour();
        Color e = new Color(e1.getRed(), s1.getGreen(), s1.getBlue(), 255);
        this.alphaSlider = new ColourSlider(0, 255, s, e);
        this.alphaSlider.setValue((int)((double)this.control.getAlpha() * 255.0));
        this.alphaChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ColourSlider src = (ColourSlider)changeEvent.getSource();
                ColourSwatchUI.this.control.setAlpha((float)src.getValue() / 255.0f);
            }
        };
        this.alphaSlider.addChangeListener(this.alphaChangeListener);
    }

    private void createAlphaTextbox() {
        this.alphaLabel = new JLabel("Alpha");
        this.alphaTextbox = new JTextField("" + (int)(this.control.getAlpha() * 255.0f));
        this.alphaTextbox.setColumns(2);
        this.alphaTextboxActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextField src = (JTextField)actionEvent.getSource();
                try {
                    int value = Integer.parseInt(src.getText());
                    if (value >= 0 && value <= 255) {
                        ColourSwatchUI.this.control.setAlpha((float)value / 255.0f);
                    } else {
                        ColourPicker.invalidColorValue();
                        ColourSwatchUI.this.alphaTextbox.setText("" + (int)(ColourSwatchUI.this.control.getAlpha() * 255.0f));
                    }
                }
                catch (NumberFormatException e) {
                    ColourPicker.invalidColorValue();
                    ColourSwatchUI.this.alphaTextbox.setText("" + (int)(ColourSwatchUI.this.control.getAlpha() * 255.0f));
                }
            }
        };
        this.alphaTextbox.addActionListener(this.alphaTextboxActionListener);
    }

    private LookupTableItem[] createColours() {
        LookupTableItem[] result = new LookupTableItem[RGBControl.PREDEFINED_COLORS.values().size()];
        int i = 0;
        for (Map.Entry<String, Color> e : RGBControl.PREDEFINED_COLORS.entrySet()) {
            result[i++] = new LookupTableItem(e.getValue(), e.getKey());
        }
        return result;
    }

    private LookupTableItem[] createLutsArray() {
        ArrayList<LookupTableItem> list = new ArrayList<LookupTableItem>();
        if (CollectionUtils.isNotEmpty(this.control.getAvailableLookupTables())) {
            Iterator<String> it = this.control.getAvailableLookupTables().iterator();
            while (it.hasNext()) {
                list.add(new LookupTableItem(it.next()));
            }
        }
        Collections.sort(list);
        LookupTableItem[] lutsArray = new LookupTableItem[list.size()];
        lutsArray = list.toArray(lutsArray);
        return lutsArray;
    }

    private int findIndex() {
        if (CommonsLangUtils.isNotEmpty(this.control.getLUT())) {
            String lut = this.control.getLUT();
            for (int i = 0; i < this.items.length; ++i) {
                LookupTableItem item = (LookupTableItem)this.items[i];
                if (!item.hasLookupTable() || !item.getFilename().equals(lut)) continue;
                return i;
            }
        } else {
            Color c = this.control.getColour();
            for (int i = 0; i < this.items.length; ++i) {
                LookupTableItem item = (LookupTableItem)this.items[i];
                if (item.hasLookupTable() || item.getColor().getRed() != c.getRed() || item.getColor().getBlue() != c.getBlue() || item.getColor().getGreen() != c.getGreen()) continue;
                return i;
            }
        }
        return -1;
    }

    private void createUI() {
        this.createAlphaSlider();
        this.createAlphaTextbox();
        Object[] colorItems = this.createColours();
        Object[] lutItems = this.createLutsArray();
        this.items = ArrayUtils.add((Object[])colorItems, (Object)LookupTableItem.SEPARATOR);
        this.items = ArrayUtils.addAll((Object[])this.items, (Object[])lutItems);
        this.colourlist = new JList<Object>(this.items);
        this.colourlist.setCellRenderer(new LookupTableListRenderer());
        this.colourlist.setSelectionMode(0);
        this.colourlist.setLayoutOrientation(0);
        this.colourlist.setVisibleRowCount(-1);
        int index = this.findIndex();
        if (index >= 0) {
            this.colourlist.setSelectedIndex(index);
            this.colourlist.ensureIndexIsVisible(index);
        }
        this.selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ColourSwatchUI.this.colourlist.getValueIsAdjusting()) {
                    return;
                }
                LookupTableItem obj = (LookupTableItem)ColourSwatchUI.this.colourlist.getSelectedValue();
                if (obj.hasLookupTable()) {
                    ColourSwatchUI.this.control.setLUT(obj.getFilename());
                } else {
                    ColourSwatchUI.this.control.setLUT(null);
                    ColourSwatchUI.this.control.setColour(obj.getColor());
                }
            }
        };
        this.colourlist.addListSelectionListener(this.selectionListener);
        this.scrollpane = new JScrollPane(this.colourlist);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 80.0;
        gbc.weighty = 580.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.scrollpane, gbc);
        gbc.gridy = 1;
        gbc.weightx = 80.0;
        gbc.weighty = 5.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.alphaLabel, gbc);
        gbc.gridy = 2;
        this.add((Component)this.alphaSlider, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 20.0;
        this.add((Component)this.alphaTextbox, gbc);
    }

    ColourSwatchUI(RGBControl c) {
        if (c == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.control = c;
        this.createUI();
        this.active = false;
    }

    void revert() {
        this.colourlist.removeListSelectionListener(this.selectionListener);
        this.colourlist.clearSelection();
        int index = this.findIndex();
        if (index >= 0) {
            this.colourlist.setSelectedIndex(index);
            this.colourlist.ensureIndexIsVisible(index);
        }
        this.colourlist.addListSelectionListener(this.selectionListener);
    }

    void setActive(boolean act) {
        this.active = act;
    }

    void refresh() {
        if (!this.active) {
            return;
        }
        this.removeListeners();
        this.updateSliders();
        this.updateTextboxes();
        this.revert();
        this.addListeners();
        this.repaint();
    }

    void addListeners() {
        this.alphaSlider.addChangeListener(this.alphaChangeListener);
        this.alphaTextbox.addActionListener(this.alphaTextboxActionListener);
    }

    void removeListeners() {
        this.alphaSlider.removeChangeListener(this.alphaChangeListener);
        this.alphaTextbox.removeActionListener(this.alphaTextboxActionListener);
    }

    void updateAlphaSlider() {
        this.removeListeners();
        boolean disable = CommonsLangUtils.isNotEmpty(this.control.getLUT());
        if (disable) {
            this.alphaSlider.setRGBStart(Color.WHITE);
            this.alphaSlider.setRGBEnd(Color.WHITE);
        } else {
            Color c = this.control.getColour();
            Color s = new Color(c.getRed(), c.getGreen(), c.getBlue(), 0);
            Color e = new Color(c.getRed(), c.getGreen(), c.getBlue(), 255);
            this.alphaSlider.setRGBStart(s);
            this.alphaSlider.setRGBEnd(e);
        }
        this.alphaLabel.setEnabled(!disable);
        this.alphaSlider.setEnabled(!disable);
        this.alphaTextbox.setEnabled(!disable);
        this.addListeners();
    }

    void updateSliders() {
        this.updateAlphaSlider();
    }

    void updateTextboxes() {
        this.alphaTextbox.setText("" + (int)(this.control.getAlpha() * 255.0f));
    }
}

