/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import omero.model.Length;
import omero.model.enums.UnitsLength;
import org.openmicroscopy.shoola.util.filter.file.BMPFilter;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;
import org.openmicroscopy.shoola.util.filter.file.JPEGFilter;
import org.openmicroscopy.shoola.util.filter.file.PNGFilter;
import org.openmicroscopy.shoola.util.filter.file.TIFFFilter;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.image.io.TIFFEncoder;
import org.openmicroscopy.shoola.util.image.io.WriterImage;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.NotificationDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import org.openmicroscopy.shoola.util.ui.lens.LensAction;
import org.openmicroscopy.shoola.util.ui.lens.LensController;
import org.openmicroscopy.shoola.util.ui.lens.LensMenu;
import org.openmicroscopy.shoola.util.ui.lens.LensModel;
import org.openmicroscopy.shoola.util.ui.lens.LensUI;
import org.openmicroscopy.shoola.util.ui.lens.ZoomAction;
import org.openmicroscopy.shoola.util.ui.lens.ZoomWindow;

public class LensComponent
extends AbstractComponent {
    public static final String LENS_LOCATION_PROPERTY = "lensLocation";
    public static final int LENS_DEFAULT_WIDTH = 50;
    public static final float DEFAULT_ZOOM = 2.0f;
    private static final List<FileFilter> FILTERS = new ArrayList<FileFilter>();
    private LensUI lens;
    private LensMenu menu;
    private LensController lensController;
    private ZoomWindow zoomWindow;
    private LensModel lensModel = new LensModel(null);

    void setDisplayInPixels(boolean b) {
        this.zoomWindow.setDisplayInPixels(b);
        this.zoomWindow.setLensXY(this.lens.getX(), this.lens.getY());
        this.zoomWindow.setLensWidthHeight(this.lens.getWidth(), this.lens.getHeight());
    }

    void setLensSize(int width, int height) {
        this.lensController.setLensSize(width, height);
    }

    void updateLensLocation() {
        Rectangle bounds = this.lensModel.getLensScaledBounds();
        this.firePropertyChange(LENS_LOCATION_PROPERTY, null, bounds);
        this.zoomWindow.paintImage();
    }

    void updateLensSize() {
        int w = this.lensModel.getWidth();
        int h = this.lensModel.getHeight();
        int index = LensAction.sizeToIndex(w, h);
        this.menu.setSelectedSize(index);
        this.zoomWindow.setSelectedSize(index);
    }

    public void setZoomFactor(float zoomFactor) {
        this.lensController.setZoomFactor(zoomFactor);
        int index = ZoomAction.factorToIndex(zoomFactor);
        this.menu.setZoomIndex(index);
        this.zoomWindow.setZoomIndex(index);
    }

    void lensMouseWheelMoved(int tick) {
        float zoomFactor = this.lensModel.getZoomFactor();
        zoomFactor -= 0.1f * (float)tick;
        if ((zoomFactor = (float)Math.round(zoomFactor * 10.0f) / 10.0f) < 1.0f) {
            zoomFactor = 1.0f;
        }
        if (zoomFactor > 10.0f) {
            zoomFactor = 10.0f;
        }
        this.setZoomFactor(zoomFactor);
    }

    public LensComponent(JFrame parent, int lensWidth, int lensHeight) {
        this.zoomWindow = new ZoomWindow(parent, this, this.lensModel);
        this.lens = new LensUI(this, lensWidth, lensHeight);
        this.lensController = new LensController(this.lensModel, this.lens, this.zoomWindow);
        this.lensModel.setWidth(lensWidth);
        this.lensModel.setHeight(lensHeight);
        this.lensModel.setImageZoomFactor(2.0f);
        this.lens.addController(this.lensController);
        this.lens.setLensColour(this.lensModel.getLensPreferredColour());
        this.menu = new LensMenu(this);
        this.lens.setPopupMenu(this.menu.getPopupMenu());
        this.zoomWindow.setJMenuBar(this.menu.getMenubar());
        this.setZoomFactor(2.0f);
    }

    public LensComponent(JFrame parent) {
        this(parent, 50, 50);
    }

    void saveAs() {
        FileChooser d = new FileChooser((JFrame)this.zoomWindow.getParent(), 1, "Save As", "Save the image displayed in the Zoom Window as JPEG, PNG, etc.", FILTERS, false, true);
        d.setSelectedFile(UIUtilities.removeFileExtension(this.lensModel.getImageName()));
        d.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!(evt.getSource() instanceof FileChooser)) {
                    return;
                }
                FileChooser fileChooser = (FileChooser)evt.getSource();
                String name = evt.getPropertyName();
                if ("approveSelection".equals(name)) {
                    NotificationDialog dialog;
                    String message;
                    String title;
                    MessageBox msg;
                    int option;
                    File[] files = (File[])evt.getNewValue();
                    File file = files[0];
                    FileFilter filter = fileChooser.getSelectedFilter();
                    String format = "";
                    if (filter instanceof CustomizedFileFilter) {
                        format = ((CustomizedFileFilter)filter).getExtension();
                    }
                    if (!filter.accept(file)) {
                        Object filePath = file.getAbsolutePath();
                        filePath = (String)filePath + "." + format;
                        file = new File((String)filePath);
                    }
                    JFrame frame = (JFrame)LensComponent.this.zoomWindow.getParent();
                    if (file.exists() && (option = (msg = new MessageBox(frame, title = "File Exists", message = "An image with the same namealready exists. Do you want to overwrite it?")).centerMsgBox()) != 1) {
                        return;
                    }
                    BufferedImage image = LensComponent.this.getZoomedImage();
                    IconManager icons = IconManager.getInstance();
                    try {
                        if ("tif".equals(format)) {
                            TIFFEncoder encoder = new TIFFEncoder(Factory.createImage(image), new DataOutputStream(new FileOutputStream(file)));
                            WriterImage.saveImage(encoder);
                        } else {
                            WriterImage.saveImage(file, image, format);
                        }
                    }
                    catch (Exception e) {
                        dialog = new NotificationDialog(frame, "Save As", "An error occurred while saving the image.", (Icon)icons.getIcon(150));
                        dialog.pack();
                        UIUtilities.centerAndShow(dialog);
                        return;
                    }
                    dialog = new NotificationDialog(frame, "Save As", "The image has been successfully saved in\n" + file.getParent(), (Icon)icons.getIcon(29));
                    dialog.pack();
                    UIUtilities.centerAndShow(dialog);
                }
            }
        });
        UIUtilities.centerAndShow(d);
    }

    public void setLensPreferredColour() {
        this.lens.setLensColour(this.lensModel.getLensPreferredColour());
    }

    public void zoomWindowClosed() {
        this.zoomWindow.setVisible(false);
        this.lens.setVisible(false);
    }

    public void setXYPixelMicron(Length x, Length y) {
        this.zoomWindow.setXYPixelMicron(x, y);
        this.menu.setMicronsMenuEnabled(!x.getUnit().equals((Object)UnitsLength.PIXEL) && !y.getUnit().equals((Object)UnitsLength.PIXEL));
    }

    public void setPlaneImage(BufferedImage img) {
        this.lensModel.setPlaneImage(img);
        this.zoomWindow.paintImage();
    }

    public void setVisible(boolean makeVisible) {
        this.lens.setVisible(makeVisible);
        this.zoomWindow.setVisible(makeVisible);
    }

    public void setImageZoomFactor(float imageZoomFactor) {
        this.lensModel.setImageZoomFactor(imageZoomFactor);
        this.lens.setImageZoomFactor();
    }

    public void setLensLocation(int x, int y) {
        this.lensController.setLensLocation(x, y);
    }

    public BufferedImage getZoomedImage() {
        return this.lensModel.getZoomedImage();
    }

    public JComponent getLensUI() {
        return this.lens;
    }

    public boolean isVisible() {
        return this.lens.isVisible() && this.zoomWindow.isVisible();
    }

    public void setLensLocation(Point loc) {
        this.setLensLocation(loc.x, loc.y);
    }

    public Dimension getLensScaledSize() {
        return this.lensModel.getLensScaledSize();
    }

    public Point getLensScaledLocation() {
        return this.lensModel.getLensScaledLocation();
    }

    public void setLensColour(Color color) {
        if (color == null) {
            return;
        }
        this.lens.setLensColour(color);
    }

    public Rectangle getLensScaledBounds() {
        return this.lensModel.getLensScaledBounds();
    }

    public Point getLensLocation() {
        return this.lensModel.getLensLocation();
    }

    public Component getZoomWindow() {
        return this.zoomWindow;
    }

    public BufferedImage createZoomedImage(BufferedImage image) {
        if (image == null) {
            return null;
        }
        return this.lensModel.createZoomedImage(image);
    }

    public void resetLens(BufferedImage image, float f, int x, int y) {
        this.lensModel.setImageZoomFactor(f);
        this.lensModel.setPlaneImage(image);
        this.lensModel.setLensLocation(x, y);
        this.lens.setImageZoomFactor();
        this.lensController.setLensLocation(x, y);
        this.setLensSize(this.lensModel.getWidth(), this.lensModel.getHeight());
        this.zoomWindow.paintImage();
        if (!this.zoomWindow.isVisible()) {
            this.zoomWindow.setSize(ZoomWindow.DEFAULT_SIZE);
        }
    }

    public void resetDataBuffered() {
        this.lensModel.resetDataBuffer();
    }

    public void setBackgroundColor(Color color) {
        this.lensModel.setBackgroundColor(color);
        this.zoomWindow.updateBackgroundColor();
    }

    public void setImageName(String imageName) {
        this.lensModel.setImageName(imageName);
    }

    static {
        FILTERS.add(new BMPFilter());
        FILTERS.add(new JPEGFilter());
        FILTERS.add(new PNGFilter());
        FILTERS.add(new TIFFFilter());
    }
}

