/*
 * Decompiled with CFR 0.152.
 */
package ome.services.query;

import java.util.Collection;
import ome.conditions.ApiUsageException;
import ome.parameters.QueryParameter;
import ome.services.query.QueryParameterDef;

public class CollectionQueryParameterDef
extends QueryParameterDef {
    public Class elementType;

    public CollectionQueryParameterDef(String name, boolean optional, Class elementType) {
        super(name, Collection.class, optional);
        this.elementType = elementType;
    }

    @Override
    public void errorIfInvalid(QueryParameter parameter) {
        super.errorIfInvalid(parameter);
        if (!this.optional && ((Collection)parameter.value).size() < 1) {
            throw new ApiUsageException("Requried collection parameters may not be empty.");
        }
        if (parameter.value != null) {
            for (Object element : (Collection)parameter.value) {
                if (element == null) {
                    throw new ApiUsageException("Null elements are not allowed in parameter collections");
                }
                if (this.elementType.isAssignableFrom(element.getClass())) continue;
                throw new ApiUsageException("Elements of type " + element.getClass().getName() + " are not allowed in collections of type " + this.elementType.getName());
            }
        }
    }
}

