/*
 * Decompiled with CFR 0.152.
 */
package ome.services.search;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import ome.conditions.ApiUsageException;
import ome.model.annotations.Annotation;
import ome.model.annotations.BooleanAnnotation;
import ome.model.annotations.CommentAnnotation;
import ome.model.annotations.DoubleAnnotation;
import ome.model.annotations.FileAnnotation;
import ome.model.annotations.LongAnnotation;
import ome.model.annotations.TagAnnotation;
import ome.model.annotations.TermAnnotation;
import ome.model.annotations.TextAnnotation;
import ome.model.annotations.TimestampAnnotation;
import ome.model.annotations.XmlAnnotation;
import ome.model.core.OriginalFile;
import ome.services.search.SearchAction;
import ome.services.search.SearchValues;
import ome.system.ServiceFactory;
import ome.tools.hibernate.QueryBuilder;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class AnnotatedWith
extends SearchAction {
    private static final Logger log = LoggerFactory.getLogger(AnnotatedWith.class);
    private static final long serialVersionUID = 1L;
    private final Annotation[] annotation;
    private final String[] path;
    private final Class[] annCls;
    private final Class[] type;
    private final Object[] value;
    private final boolean[] fetch;
    private final List<Class> fetchAnnotationsCopy = new ArrayList<Class>();
    private final boolean useNamespace;
    private final boolean useLike;
    private final Class cls;

    public AnnotatedWith(SearchValues values, Annotation[] annotation, boolean useNamespace, boolean useLike) {
        super(values);
        this.annotation = annotation;
        this.useNamespace = useNamespace;
        this.useLike = useLike;
        if (values.onlyTypes == null || values.onlyTypes.size() != 1) {
            throw new ApiUsageException("Searches by annotated with are currently limited to a single type\nPlese use Search.onlyType()");
        }
        this.cls = values.onlyTypes.get(0);
        if (annotation == null || annotation.length == 0) {
            throw new ApiUsageException("Must specify at least one annotation.");
        }
        this.path = new String[annotation.length];
        this.annCls = new Class[annotation.length];
        this.type = new Class[annotation.length];
        this.value = new Object[annotation.length];
        this.fetch = new boolean[annotation.length];
        this.fetchAnnotationsCopy.addAll(values.fetchAnnotations);
        for (int i = 0; i < annotation.length; ++i) {
            if (annotation[i] instanceof TextAnnotation) {
                this.annCls[i] = annotation[i] instanceof CommentAnnotation ? CommentAnnotation.class : (annotation[i] instanceof TagAnnotation ? TagAnnotation.class : (annotation[i] instanceof TermAnnotation ? TermAnnotation.class : (annotation[i] instanceof XmlAnnotation ? XmlAnnotation.class : TextAnnotation.class)));
                this.type[i] = String.class;
                this.path[i] = "textValue";
                this.value[i] = ((TextAnnotation)annotation[i]).getTextValue();
            } else if (annotation[i] instanceof BooleanAnnotation) {
                this.annCls[i] = BooleanAnnotation.class;
                this.type[i] = Boolean.class;
                this.path[i] = "boolValue";
                this.value[i] = ((BooleanAnnotation)annotation[i]).getBoolValue();
            } else if (annotation[i] instanceof TimestampAnnotation) {
                this.annCls[i] = TimestampAnnotation.class;
                this.type[i] = Timestamp.class;
                this.path[i] = "timeValue";
                this.value[i] = ((TimestampAnnotation)annotation[i]).getTimeValue();
            } else if (annotation[i] instanceof FileAnnotation) {
                this.annCls[i] = FileAnnotation.class;
                this.type[i] = OriginalFile.class;
                this.path[i] = "file";
                this.value[i] = ((FileAnnotation)annotation[i]).getFile();
            } else if (annotation[i] instanceof DoubleAnnotation) {
                this.annCls[i] = DoubleAnnotation.class;
                this.type[i] = Double.class;
                this.path[i] = "doubleValue";
                this.value[i] = ((DoubleAnnotation)annotation[i]).getDoubleValue();
            } else if (annotation[i] instanceof LongAnnotation) {
                this.annCls[i] = LongAnnotation.class;
                this.type[i] = Long.class;
                this.path[i] = "longValue";
                this.value[i] = ((LongAnnotation)annotation[i]).getLongValue();
            } else {
                throw new ApiUsageException("Unsupported annotation type:" + annotation);
            }
            for (Class ac : values.fetchAnnotations) {
                if (!this.annCls[i].isAssignableFrom(ac)) continue;
                this.fetch[i] = true;
                this.fetchAnnotationsCopy.remove(ac);
            }
            if (this.value[i] != null) continue;
            this.fetchAnnotationsCopy.add(this.annCls[i]);
        }
    }

    @Transactional(readOnly=true)
    public Object doWork(Session session, ServiceFactory sf) {
        int i;
        String[] link = new String[this.annotation.length];
        String[] ann = new String[this.annotation.length];
        QueryBuilder qb = new QueryBuilder();
        qb.select("this");
        qb.from(this.cls.getName(), "this");
        for (i = 0; i < ann.length; ++i) {
            if (this.value[i] == null) continue;
            link[i] = qb.unique_alias("link");
            ann[i] = link[i] + "_child";
            qb.join("this.annotationLinks", link[i], false, this.fetch[i]);
            qb.join(link[i] + ".child", ann[i], false, this.fetch[i]);
        }
        for (i = 0; i < this.fetchAnnotationsCopy.size(); ++i) {
            qb.join("this.annotationLinks", "fetchannlink" + i, false, true);
            qb.join("fetchannlink" + i + ".child", "fetchannchild" + i, false, true);
        }
        qb.where();
        for (i = 0; i < this.fetchAnnotationsCopy.size(); ++i) {
            qb.and("fetchannchild" + i + ".class = " + this.fetchAnnotationsCopy.get(i).getSimpleName());
        }
        this.ids(qb, "this.");
        this.ownerOrGroup(this.cls, qb, "this.");
        this.createdOrModified(this.cls, qb, "this.");
        for (int j = 0; j < this.annotation.length; ++j) {
            if (this.useNamespace) {
                AnnotatedWith.notNullOrLikeOrEqual(qb, ann[j] + ".ns", this.type[j], this.annotation[j].getNs(), this.useLike, this.values.caseSensitive);
            }
            if (this.value[j] != null) {
                AnnotatedWith.notNullOrLikeOrEqual(qb, ann[j] + "." + this.path[j], this.type[j], this.value[j], this.useLike, this.values.caseSensitive);
            }
            this.annotatedBetween(qb, ann[j] + ".");
            this.annotatedBy(qb, ann[j] + ".");
        }
        for (String orderBy : this.values.orderBy) {
            String orderByPath = AnnotatedWith.orderByPath(orderBy);
            boolean ascending = AnnotatedWith.orderByAscending(orderBy);
            qb.order("this." + orderByPath, ascending);
        }
        log.debug(qb.toString());
        Query query = qb.query(session);
        if (this.timeout != null) {
            query.setTimeout(this.timeout.intValue());
        }
        return query.list();
    }
}

