/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.externalize;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.externalize.RelDotWriter;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="RelDotWriter", generator="Immutables")
final class ImmutableRelDotWriter {
    private ImmutableRelDotWriter() {
    }

    @CheckReturnValue
    @Generated(from="RelDotWriter.WriteOption", generator="Immutables")
    @Immutable
    static final class WriteOption
    implements RelDotWriter.WriteOption {
        private final int maxNodeLabelLength;
        private final int maxNodeLabelPerLine;
        private final @org.checkerframework.checker.nullness.qual.Nullable Predicate<RelNode> nodePredicate;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();
        private static final WriteOption INSTANCE = WriteOption.validate(new WriteOption());

        private WriteOption() {
            this.nodePredicate = null;
            this.maxNodeLabelLength = this.initShim.maxNodeLabelLength();
            this.maxNodeLabelPerLine = this.initShim.maxNodeLabelPerLine();
            this.initShim = null;
        }

        private WriteOption(Builder builder) {
            this.nodePredicate = builder.nodePredicate;
            if (builder.maxNodeLabelLengthIsSet()) {
                this.initShim.withMaxNodeLabelLength(builder.maxNodeLabelLength);
            }
            if (builder.maxNodeLabelPerLineIsSet()) {
                this.initShim.withMaxNodeLabelPerLine(builder.maxNodeLabelPerLine);
            }
            this.maxNodeLabelLength = this.initShim.maxNodeLabelLength();
            this.maxNodeLabelPerLine = this.initShim.maxNodeLabelPerLine();
            this.initShim = null;
        }

        private WriteOption(int maxNodeLabelLength, int maxNodeLabelPerLine, @org.checkerframework.checker.nullness.qual.Nullable Predicate<RelNode> nodePredicate) {
            this.maxNodeLabelLength = maxNodeLabelLength;
            this.maxNodeLabelPerLine = maxNodeLabelPerLine;
            this.nodePredicate = nodePredicate;
            this.initShim = null;
        }

        private int maxNodeLabelLengthInitialize() {
            return RelDotWriter.WriteOption.super.maxNodeLabelLength();
        }

        private int maxNodeLabelPerLineInitialize() {
            return RelDotWriter.WriteOption.super.maxNodeLabelPerLine();
        }

        @Override
        public int maxNodeLabelLength() {
            InitShim shim = this.initShim;
            return shim != null ? shim.maxNodeLabelLength() : this.maxNodeLabelLength;
        }

        @Override
        public int maxNodeLabelPerLine() {
            InitShim shim = this.initShim;
            return shim != null ? shim.maxNodeLabelPerLine() : this.maxNodeLabelPerLine;
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable Predicate<RelNode> nodePredicate() {
            return this.nodePredicate;
        }

        public final WriteOption withMaxNodeLabelLength(int value) {
            if (this.maxNodeLabelLength == value) {
                return this;
            }
            return WriteOption.validate(new WriteOption(value, this.maxNodeLabelPerLine, this.nodePredicate));
        }

        public final WriteOption withMaxNodeLabelPerLine(int value) {
            if (this.maxNodeLabelPerLine == value) {
                return this;
            }
            return WriteOption.validate(new WriteOption(this.maxNodeLabelLength, value, this.nodePredicate));
        }

        public final WriteOption withNodePredicate(@org.checkerframework.checker.nullness.qual.Nullable Predicate<RelNode> value) {
            if (this.nodePredicate == value) {
                return this;
            }
            return WriteOption.validate(new WriteOption(this.maxNodeLabelLength, this.maxNodeLabelPerLine, value));
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof WriteOption && this.equalTo((WriteOption)another);
        }

        private boolean equalTo(WriteOption another) {
            return this.maxNodeLabelLength == another.maxNodeLabelLength && this.maxNodeLabelPerLine == another.maxNodeLabelPerLine && Objects.equals(this.nodePredicate, another.nodePredicate);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.maxNodeLabelLength;
            h += (h << 5) + this.maxNodeLabelPerLine;
            h += (h << 5) + Objects.hashCode(this.nodePredicate);
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"WriteOption").omitNullValues().add("maxNodeLabelLength", this.maxNodeLabelLength).add("maxNodeLabelPerLine", this.maxNodeLabelPerLine).add("nodePredicate", this.nodePredicate).toString();
        }

        public static WriteOption of() {
            return INSTANCE;
        }

        private static WriteOption validate(WriteOption instance) {
            return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
        }

        public static WriteOption copyOf(RelDotWriter.WriteOption instance) {
            if (instance instanceof WriteOption) {
                return (WriteOption)instance;
            }
            return WriteOption.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="RelDotWriter.WriteOption", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long OPT_BIT_MAX_NODE_LABEL_LENGTH = 1L;
            private static final long OPT_BIT_MAX_NODE_LABEL_PER_LINE = 2L;
            private long optBits;
            private int maxNodeLabelLength;
            private int maxNodeLabelPerLine;
            @Nullable
            private @org.checkerframework.checker.nullness.qual.Nullable Predicate<RelNode> nodePredicate;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(RelDotWriter.WriteOption instance) {
                Objects.requireNonNull(instance, "instance");
                this.withMaxNodeLabelLength(instance.maxNodeLabelLength());
                this.withMaxNodeLabelPerLine(instance.maxNodeLabelPerLine());
                @org.checkerframework.checker.nullness.qual.Nullable Predicate<RelNode> nodePredicateValue = instance.nodePredicate();
                if (nodePredicateValue != null) {
                    this.withNodePredicate(nodePredicateValue);
                }
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withMaxNodeLabelLength(int maxNodeLabelLength) {
                this.maxNodeLabelLength = maxNodeLabelLength;
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withMaxNodeLabelPerLine(int maxNodeLabelPerLine) {
                this.maxNodeLabelPerLine = maxNodeLabelPerLine;
                this.optBits |= 2L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withNodePredicate(@org.checkerframework.checker.nullness.qual.Nullable Predicate<RelNode> nodePredicate) {
                this.nodePredicate = nodePredicate;
                return this;
            }

            public WriteOption build() {
                return WriteOption.validate(new WriteOption(this));
            }

            private boolean maxNodeLabelLengthIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private boolean maxNodeLabelPerLineIsSet() {
                return (this.optBits & 2L) != 0L;
            }
        }

        @Generated(from="RelDotWriter.WriteOption", generator="Immutables")
        private final class InitShim {
            private byte maxNodeLabelLengthBuildStage = 0;
            private int maxNodeLabelLength;
            private byte maxNodeLabelPerLineBuildStage = 0;
            private int maxNodeLabelPerLine;

            private InitShim() {
            }

            int maxNodeLabelLength() {
                if (this.maxNodeLabelLengthBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.maxNodeLabelLengthBuildStage == 0) {
                    this.maxNodeLabelLengthBuildStage = (byte)-1;
                    this.maxNodeLabelLength = WriteOption.this.maxNodeLabelLengthInitialize();
                    this.maxNodeLabelLengthBuildStage = 1;
                }
                return this.maxNodeLabelLength;
            }

            void withMaxNodeLabelLength(int maxNodeLabelLength) {
                this.maxNodeLabelLength = maxNodeLabelLength;
                this.maxNodeLabelLengthBuildStage = 1;
            }

            int maxNodeLabelPerLine() {
                if (this.maxNodeLabelPerLineBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.maxNodeLabelPerLineBuildStage == 0) {
                    this.maxNodeLabelPerLineBuildStage = (byte)-1;
                    this.maxNodeLabelPerLine = WriteOption.this.maxNodeLabelPerLineInitialize();
                    this.maxNodeLabelPerLineBuildStage = 1;
                }
                return this.maxNodeLabelPerLine;
            }

            void withMaxNodeLabelPerLine(int maxNodeLabelPerLine) {
                this.maxNodeLabelPerLine = maxNodeLabelPerLine;
                this.maxNodeLabelPerLineBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.maxNodeLabelLengthBuildStage == -1) {
                    attributes.add("maxNodeLabelLength");
                }
                if (this.maxNodeLabelPerLineBuildStage == -1) {
                    attributes.add("maxNodeLabelPerLine");
                }
                return "Cannot build WriteOption, attribute initializers form cycle " + attributes;
            }
        }
    }
}

