/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.Liner;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElbowLiner
implements Liner,
DOMStorable {
    private double shoulderSize;

    public ElbowLiner() {
        this(20.0);
    }

    public ElbowLiner(double slantSize) {
        this.shoulderSize = slantSize;
    }

    @Override
    public Collection<Handle> createHandles(BezierPath path) {
        return null;
    }

    @Override
    public void lineout(ConnectionFigure figure) {
        int eoutcode;
        int soutcode;
        Rectangle2D.Double eb;
        Rectangle2D.Double sb;
        Point2D.Double ep;
        Point2D.Double sp;
        BezierPath path = ((LineConnectionFigure)figure).getBezierPath();
        Connector start = figure.getStartConnector();
        Connector end = figure.getEndConnector();
        if (start == null || end == null || path == null) {
            return;
        }
        if (figure.getStartFigure() == figure.getEndFigure()) {
            while (path.size() < 5) {
                path.add(1, new BezierPath.Node(0.0, 0.0));
            }
            while (path.size() > 5) {
                path.remove(1);
            }
            sp = start.findStart(figure);
            ep = end.findEnd(figure);
            sb = start.getBounds();
            eb = end.getBounds();
            soutcode = sb.outcode(sp);
            if (soutcode == 0) {
                soutcode = Geom.outcode(sb, eb);
            }
            if ((eoutcode = eb.outcode(ep)) == 0) {
                eoutcode = Geom.outcode(sb, eb);
            }
            ((BezierPath.Node)path.get(0)).moveTo(sp);
            ((BezierPath.Node)path.get(path.size() - 1)).moveTo(ep);
            switch (soutcode) {
                case 2: {
                    eoutcode = 1;
                    break;
                }
                case 4: {
                    eoutcode = 2;
                    break;
                }
                case 8: {
                    eoutcode = 4;
                    break;
                }
                case 1: {
                    eoutcode = 8;
                    break;
                }
                default: {
                    eoutcode = 2;
                    soutcode = 4;
                }
            }
            ((BezierPath.Node)path.get(1)).moveTo(sp.x + this.shoulderSize, sp.y);
            if ((soutcode & 4) != 0) {
                ((BezierPath.Node)path.get(1)).moveTo(sp.x + this.shoulderSize, sp.y);
            } else if ((soutcode & 1) != 0) {
                ((BezierPath.Node)path.get(1)).moveTo(sp.x - this.shoulderSize, sp.y);
            } else if ((soutcode & 8) != 0) {
                ((BezierPath.Node)path.get(1)).moveTo(sp.x, sp.y + this.shoulderSize);
            } else {
                ((BezierPath.Node)path.get(1)).moveTo(sp.x, sp.y - this.shoulderSize);
            }
            if ((eoutcode & 4) != 0) {
                ((BezierPath.Node)path.get(3)).moveTo(ep.x + this.shoulderSize, ep.y);
            } else if ((eoutcode & 1) != 0) {
                ((BezierPath.Node)path.get(3)).moveTo(ep.x - this.shoulderSize, ep.y);
            } else if ((eoutcode & 8) != 0) {
                ((BezierPath.Node)path.get(3)).moveTo(ep.x, ep.y + this.shoulderSize);
            } else {
                ((BezierPath.Node)path.get(3)).moveTo(ep.x, ep.y - this.shoulderSize);
            }
            switch (soutcode) {
                case 4: {
                    ((BezierPath.Node)path.get(2)).moveTo(((BezierPath.Node)path.get((int)1)).x[0], ((BezierPath.Node)path.get((int)3)).y[0]);
                    break;
                }
                case 2: {
                    ((BezierPath.Node)path.get(2)).moveTo(((BezierPath.Node)path.get((int)1)).y[0], ((BezierPath.Node)path.get((int)3)).x[0]);
                    break;
                }
                case 1: {
                    ((BezierPath.Node)path.get(2)).moveTo(((BezierPath.Node)path.get((int)1)).x[0], ((BezierPath.Node)path.get((int)3)).y[0]);
                    break;
                }
                default: {
                    ((BezierPath.Node)path.get(2)).moveTo(((BezierPath.Node)path.get((int)1)).y[0], ((BezierPath.Node)path.get((int)3)).x[0]);
                    break;
                }
            }
        } else {
            sp = start.findStart(figure);
            ep = end.findEnd(figure);
            path.clear();
            path.add(new BezierPath.Node(sp.x, sp.y));
            if (sp.x == ep.x || sp.y == ep.y) {
                path.add(new BezierPath.Node(ep.x, ep.y));
            } else {
                sb = start.getBounds();
                sb.x += 5.0;
                sb.y += 5.0;
                sb.width -= 10.0;
                sb.height -= 10.0;
                eb = end.getBounds();
                eb.x += 5.0;
                eb.y += 5.0;
                eb.width -= 10.0;
                eb.height -= 10.0;
                soutcode = sb.outcode(sp);
                if (soutcode == 0) {
                    soutcode = Geom.outcode(sb, eb);
                }
                if ((eoutcode = eb.outcode(ep)) == 0) {
                    eoutcode = Geom.outcode(eb, sb);
                }
                if ((soutcode & 0xA) != 0 && (eoutcode & 0xA) != 0) {
                    path.add(new BezierPath.Node(sp.x, (sp.y + ep.y) / 2.0));
                    path.add(new BezierPath.Node(ep.x, (sp.y + ep.y) / 2.0));
                } else if ((soutcode & 5) != 0 && (eoutcode & 5) != 0) {
                    path.add(new BezierPath.Node((sp.x + ep.x) / 2.0, sp.y));
                    path.add(new BezierPath.Node((sp.x + ep.x) / 2.0, ep.y));
                } else if (soutcode == 8 && eoutcode == 1) {
                    path.add(new BezierPath.Node(sp.x, ep.y));
                } else {
                    path.add(new BezierPath.Node(ep.x, sp.y));
                }
                path.add(new BezierPath.Node(ep.x, ep.y));
            }
        }
        for (BezierPath.Node node : path) {
            node.setMask(0);
        }
        path.invalidatePath();
    }

    @Override
    public void read(DOMInput in) {
    }

    @Override
    public void write(DOMOutput out) {
    }

    @Override
    public Liner clone() {
        try {
            return (Liner)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            InternalError error = new InternalError(ex.getMessage());
            error.initCause(ex);
            throw error;
        }
    }
}

