/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.ArrayList;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ProjectData;
import org.openmicroscopy.shoola.agents.treeviewer.DataTreeViewerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.event.AgentEventListener;

public class ExistingObjectsSaver
extends DataTreeViewerLoader {
    private DataObject parent;
    private Set children;
    private CallHandle handle;

    private void checkParent(DataObject o) {
        if (o instanceof ProjectData || o instanceof DatasetData) {
            return;
        }
        throw new IllegalArgumentException("Data object not supported.");
    }

    public ExistingObjectsSaver(TreeViewer viewer, SecurityContext ctx, DataObject parent, Set children) {
        super(viewer, ctx);
        if (parent == null) {
            throw new IllegalArgumentException("Data object cannot be null");
        }
        if (children == null || children.size() == 0) {
            throw new IllegalArgumentException("No children to add.");
        }
        this.checkParent(parent);
        this.parent = parent;
        this.children = children;
    }

    @Override
    public void load() {
        ArrayList<DataObject> l = new ArrayList<DataObject>();
        l.add(this.parent);
        this.handle = this.dmView.addExistingObjects(this.ctx, l, this.children, (AgentEventListener)this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 2) {
            return;
        }
        this.viewer.getSelectedBrowser().refreshLoggedExperimenterData();
    }
}

