/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import omero.gateway.SecurityContext;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.data.events.ExitApplication;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ExitApplicationAction
extends TreeViewerAction {
    public static final String NAME = "Quit the application...";
    public static final String DESCRIPTION = "Exit the application.";
    public static final String NAME_AS_PLUGIN = "Quit the plugin...";
    public static final String DESCRIPTION_AS_PLUGIN = "Exit the plugin.";

    @Override
    protected void onDisplayMode() {
        this.setEnabled(true);
    }

    public ExitApplicationAction(TreeViewer model) {
        super(model);
        this.setEnabled(true);
        if (!TreeViewerAgent.isRunAsPlugin()) {
            this.putValue("Name", NAME);
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        } else {
            this.putValue("Name", NAME_AS_PLUGIN);
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_AS_PLUGIN));
        }
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(38));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.model.cancel();
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        ExitApplication a = new ExitApplication(false);
        GroupData group = this.model.getSelectedGroup();
        if (group != null) {
            a.setSecurityContext(new SecurityContext(group.getId()));
        }
        bus.post(a);
    }
}

