/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class GroupSelectionAction
extends TreeViewerAction {
    public static final String NAME = "Switch Group";
    public static final String NAME_ADD = "Add Group...";
    public static final String DESCRIPTION = "Select the sole group to display in the tree.";
    public static final String DESCRIPTION_ADD = "Select the group to add to the tree.";
    private GroupData group;
    private boolean add;

    private void setPermissions() {
        IconManager im = IconManager.getInstance();
        ImageIcon icon = im.getIcon(112);
        String desc = "";
        switch (this.group.getPermissions().getPermissionsLevel()) {
            case 0: {
                desc = "Private Group";
                icon = im.getIcon(130);
                break;
            }
            case 1: {
                desc = "Collaborators can only read your data.";
                icon = im.getIcon(131);
                break;
            }
            case 2: {
                desc = "Collaborators can read and annotate your data.";
                icon = im.getIcon(132);
                break;
            }
            case 3: {
                desc = "Collaborators can read, annotate, delete, etc., your data.";
                icon = im.getIcon(164);
                break;
            }
            case 4: {
                desc = "Public";
                icon = im.getIcon(133);
                break;
            }
            case 5: {
                desc = "Public";
                icon = im.getIcon(133);
            }
        }
        this.putValue("SmallIcon", icon);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(desc));
    }

    @Override
    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        this.setEnabled(browser.getState() == 15);
    }

    public GroupSelectionAction(TreeViewer model, GroupData group, boolean add) {
        super(model);
        if (group == null) {
            throw new IllegalArgumentException("No group specified.");
        }
        this.group = group;
        this.add = add;
        this.name = group.getName();
        this.putValue("Name", this.name);
        this.setPermissions();
    }

    public boolean isSameGroup(long groupID) {
        return this.group.getId() == groupID;
    }

    public long getGroupId() {
        return this.group.getId();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.model.retrieveUserGroups(null, this.group);
    }
}

