/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import org.openmicroscopy.shoola.agents.util.ui.JComboBoxImageObject;

public class JComboBoxImageRenderer
extends DefaultListCellRenderer {
    private List<String> tooltips;

    public void setTooltips(List<String> tooltips) {
        this.tooltips = tooltips;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        int h;
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (index > -1 && value != null && this.tooltips != null && this.tooltips.size() > index) {
            list.setToolTipText(this.tooltips.get(index));
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        String txt = "";
        Icon icon = null;
        if (value instanceof ImageIcon) {
            icon = (ImageIcon)value;
            txt = ((ImageIcon)value).getDescription();
        } else if (value instanceof JComboBoxImageObject) {
            JComboBoxImageObject object = (JComboBoxImageObject)value;
            icon = object.getIcon();
            txt = object.getText();
        }
        label.setIcon(icon);
        label.setText(txt);
        int max = h = label.getFontMetrics(label.getFont()).getHeight();
        if (icon != null) {
            max = Math.max(h, icon.getIconHeight()) + 4;
        }
        Dimension d = label.getPreferredSize();
        label.setPreferredSize(new Dimension(d.width, max));
        return label;
    }
}

