/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.print.Pageable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.app.AbstractProject;
import org.jhotdraw.app.action.ExportableProject;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingPageable;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.draw.ImageInputFormat;
import org.jhotdraw.draw.ImageOutputFormat;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.draw.TextInputFormat;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.gui.PlacardScrollPaneLayout;
import org.jhotdraw.samples.svg.SVGDrawing;
import org.jhotdraw.samples.svg.SVGPropertiesPanel;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;
import org.jhotdraw.samples.svg.io.ImageMapOutputFormat;
import org.jhotdraw.samples.svg.io.SVGOutputFormat;
import org.jhotdraw.samples.svg.io.SVGZInputFormat;
import org.jhotdraw.samples.svg.io.SVGZOutputFormat;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGProject
extends AbstractProject
implements ExportableProject {
    protected JFileChooser exportChooser;
    private UndoRedoManager undo;
    private DrawingEditor editor;
    private HashMap<FileFilter, InputFormat> fileFilterInputFormatMap;
    private HashMap<FileFilter, OutputFormat> fileFilterOutputFormatMap;
    private GridConstrainer visibleConstrainer = new GridConstrainer(10.0, 10.0);
    private GridConstrainer invisibleConstrainer = new GridConstrainer(1.0, 1.0);
    private Preferences prefs;
    private SVGPropertiesPanel propertiesPanel;
    private JScrollPane scrollPane;
    private DefaultDrawingView view;

    public void init() {
        super.init();
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        this.initComponents();
        JPanel zoomButtonPanel = new JPanel(new BorderLayout());
        this.scrollPane.setLayout(new PlacardScrollPaneLayout());
        this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setEditor(new DefaultDrawingEditor());
        this.undo = new UndoRedoManager();
        this.view.setDrawing(this.createDrawing());
        this.view.getDrawing().addUndoableEditListener(this.undo);
        this.initActions();
        this.undo.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SVGProject.this.setHasUnsavedChanges(SVGProject.this.undo.hasSignificantEdits());
            }
        });
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JPanel placardPanel = new JPanel(new BorderLayout());
        AbstractButton pButton = ButtonFactory.createZoomButton(this.view);
        pButton.putClientProperty("Quaqua.Button.style", "placard");
        pButton.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        pButton.setFont(UIManager.getFont("SmallSystemFont"));
        placardPanel.add((Component)pButton, "West");
        pButton = ButtonFactory.createToggleGridButton(this.view);
        pButton.putClientProperty("Quaqua.Button.style", "placard");
        pButton.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        pButton.setFont(UIManager.getFont("SmallSystemFont"));
        labels.configureToolBarButton(pButton, "alignGridSmall");
        placardPanel.add((Component)pButton, "East");
        this.scrollPane.add((Component)placardPanel, "LOWER_LEFT_CORNER");
        this.propertiesPanel.setVisible(this.prefs.getBoolean("propertiesPanelVisible", false));
        this.propertiesPanel.setView(this.view);
    }

    protected Drawing createDrawing() {
        SVGDrawing drawing = new SVGDrawing();
        LinkedList<InputFormat> inputFormats = new LinkedList<InputFormat>();
        inputFormats.add(new SVGZInputFormat());
        inputFormats.add(new ImageInputFormat(new SVGImageFigure()));
        inputFormats.add(new ImageInputFormat(new SVGImageFigure(), "JPG", "Joint Photographics Experts Group (JPEG)", "jpg", 1));
        inputFormats.add(new ImageInputFormat(new SVGImageFigure(), "GIF", "Graphics Interchange Format (GIF)", "gif", 2));
        inputFormats.add(new TextInputFormat(new SVGTextFigure()));
        drawing.setInputFormats(inputFormats);
        LinkedList<OutputFormat> outputFormats = new LinkedList<OutputFormat>();
        outputFormats.add(new SVGOutputFormat());
        outputFormats.add(new SVGZOutputFormat());
        outputFormats.add(new ImageOutputFormat());
        outputFormats.add(new ImageOutputFormat("JPG", "Joint Photographics Experts Group (JPEG)", "jpg", 1));
        outputFormats.add(new ImageOutputFormat("BMP", "Windows Bitmap (BMP)", "bmp", 13));
        outputFormats.add(new ImageMapOutputFormat());
        drawing.setOutputFormats(outputFormats);
        return drawing;
    }

    public Pageable createPageable() {
        return new DrawingPageable(this.view.getDrawing());
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    public void setEditor(DrawingEditor newValue) {
        DrawingEditor oldValue = this.editor;
        if (oldValue != null) {
            oldValue.remove(this.view);
        }
        this.editor = newValue;
        this.propertiesPanel.setEditor(this.editor);
        if (newValue != null) {
            newValue.add(this.view);
        }
    }

    private void initActions() {
        this.putAction("undo", this.undo.getUndoAction());
        this.putAction("redo", this.undo.getRedoAction());
    }

    protected void setHasUnsavedChanges(boolean newValue) {
        super.setHasUnsavedChanges(newValue);
        this.undo.setHasSignificantEdits(newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File f) throws IOException {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(f));
            new SVGOutputFormat().write(f, this.view.getDrawing());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void read(File f) throws IOException {
        try {
            JFileChooser fc = this.getOpenChooser();
            final Drawing drawing = this.createDrawing();
            InputFormat sf = this.fileFilterInputFormatMap.get(fc.getFileFilter());
            if (sf == null) {
                sf = drawing.getInputFormats().get(0);
            }
            sf.read(f, drawing);
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    SVGProject.this.view.getDrawing().removeUndoableEditListener(SVGProject.this.undo);
                    SVGProject.this.view.setDrawing(drawing);
                    SVGProject.this.view.getDrawing().addUndoableEditListener(SVGProject.this.undo);
                    SVGProject.this.undo.discardAllEdits();
                }
            });
        }
        catch (InterruptedException e) {
            InternalError error = new InternalError();
            e.initCause(e);
            throw error;
        }
        catch (InvocationTargetException e) {
            InternalError error = new InternalError();
            error.initCause(e);
            throw error;
        }
    }

    public DrawingEditor getDrawingEditor() {
        return this.editor;
    }

    public Drawing getDrawing() {
        return this.view.getDrawing();
    }

    public void setEnabled(boolean newValue) {
        this.view.setEnabled(newValue);
        super.setEnabled(newValue);
    }

    public void setPropertiesPanelVisible(boolean newValue) {
        boolean oldValue = this.propertiesPanel.isVisible();
        this.propertiesPanel.setVisible(newValue);
        this.firePropertyChange("propertiesPanelVisible", oldValue, newValue);
        this.prefs.putBoolean("propertiesPanelVisible", newValue);
        this.validate();
    }

    public boolean isPropertiesPanelVisible() {
        return this.propertiesPanel.isVisible();
    }

    public void clear() {
        this.view.setDrawing(new SVGDrawing());
        this.undo.discardAllEdits();
    }

    protected JFileChooser createOpenChooser() {
        final JFileChooser c = super.createOpenChooser();
        this.fileFilterInputFormatMap = new HashMap();
        FileFilter firstFF = null;
        for (InputFormat format : this.view.getDrawing().getInputFormats()) {
            FileFilter ff = format.getFileFilter();
            if (firstFF == null) {
                firstFF = ff;
            }
            this.fileFilterInputFormatMap.put(ff, format);
            c.addChoosableFileFilter(ff);
        }
        c.setFileFilter(firstFF);
        c.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("fileFilterChanged")) {
                    InputFormat inputFormat = (InputFormat)SVGProject.this.fileFilterInputFormatMap.get(evt.getNewValue());
                    c.setAccessory(inputFormat == null ? null : inputFormat.getInputFormatAccessory());
                }
            }
        });
        return c;
    }

    protected JFileChooser createSaveChooser() {
        JFileChooser c;
        block0: {
            c = super.createSaveChooser();
            this.fileFilterOutputFormatMap = new HashMap();
            Iterator<OutputFormat> i$ = this.view.getDrawing().getOutputFormats().iterator();
            if (!i$.hasNext()) break block0;
            OutputFormat format = i$.next();
            FileFilter ff = format.getFileFilter();
            this.fileFilterOutputFormatMap.put(ff, format);
            c.addChoosableFileFilter(ff);
        }
        return c;
    }

    protected JFileChooser createExportChooser() {
        JFileChooser c = new JFileChooser();
        this.fileFilterOutputFormatMap = new HashMap();
        FileFilter currentFilter = null;
        for (OutputFormat format : this.view.getDrawing().getOutputFormats()) {
            FileFilter ff = format.getFileFilter();
            this.fileFilterOutputFormatMap.put(ff, format);
            c.addChoosableFileFilter(ff);
            if (!ff.getDescription().equals(this.prefs.get("projectExportFormat", ""))) continue;
            currentFilter = ff;
        }
        if (currentFilter != null) {
            c.setFileFilter(currentFilter);
        }
        c.setSelectedFile(new File(this.prefs.get("projectExportFile", System.getProperty("user.home"))));
        return c;
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.view = new DefaultDrawingView();
        this.propertiesPanel = new SVGPropertiesPanel();
        this.setLayout(new BorderLayout());
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setViewportView(this.view);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.propertiesPanel, "South");
    }

    public JFileChooser getExportChooser() {
        if (this.exportChooser == null) {
            this.exportChooser = this.createExportChooser();
        }
        return this.exportChooser;
    }

    public void export(File f, FileFilter filter, Component accessory) throws IOException {
        OutputFormat format = this.fileFilterOutputFormatMap.get(filter);
        if (!f.getName().endsWith("." + format.getFileExtension())) {
            f = new File(f.getPath() + "." + format.getFileExtension());
        }
        format.write(f, this.view.getDrawing());
        this.prefs.put("projectExportFile", f.getPath());
        this.prefs.put("projectExportFormat", filter.getDescription());
    }

    public void setGridVisible(boolean newValue) {
        boolean oldValue = this.isGridVisible();
        GridConstrainer c = newValue ? this.visibleConstrainer : this.invisibleConstrainer;
        this.view.setConstrainer(c);
        this.firePropertyChange("gridVisible", oldValue, newValue);
        this.prefs.putBoolean("project.gridVisible", newValue);
    }

    public boolean isGridVisible() {
        return this.view.getConstrainer() == this.visibleConstrainer;
    }

    public double getScaleFactor() {
        return this.view.getScaleFactor();
    }

    public void setScaleFactor(double newValue) {
        double oldValue = this.getScaleFactor();
        this.view.setScaleFactor(newValue);
        this.firePropertyChange("scaleFactor", oldValue, newValue);
        this.prefs.putDouble("project.scaleFactor", newValue);
    }
}

