/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.ChannelData;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.util.CommonsLangUtils;

public class ChannelMetadataLoader
extends BatchCallTree {
    private Object results;
    private BatchCall loadCall;

    private BatchCall makeBatchCall(final SecurityContext ctx, final long pixelsID, final long userID) {
        return new BatchCall("Loading channel Metadata: "){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService os = ChannelMetadataLoader.this.context.getMetadataService();
                List<ChannelData> l = os.getChannelsMetadata(ctx, pixelsID);
                if (userID >= 0L) {
                    OmeroImageService svc = ChannelMetadataLoader.this.context.getImageService();
                    List<RndProxyDef> rnd = svc.getRenderingSettingsFor(ctx, pixelsID, userID);
                    HashMap<ChannelData, Object> channels = new HashMap<ChannelData, Object>();
                    Iterator<ChannelData> i = l.iterator();
                    if (rnd != null && rnd.size() > 0) {
                        RndProxyDef ref = rnd.get(0);
                        while (i.hasNext()) {
                            ChannelData channel = i.next();
                            if (CommonsLangUtils.isNotEmpty(ref.getLookupTable(channel.getIndex()))) {
                                channels.put(channel, ref.getLookupTable(channel.getIndex()));
                                continue;
                            }
                            channels.put(channel, ref.getChannelColor(channel.getIndex()));
                        }
                    } else {
                        while (i.hasNext()) {
                            channels.put(i.next(), null);
                        }
                    }
                    ChannelMetadataLoader.this.results = channels;
                } else {
                    ChannelMetadataLoader.this.results = l;
                }
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.results;
    }

    public ChannelMetadataLoader(SecurityContext ctx, long pixelsID, long userID) {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels ID not valid.");
        }
        this.loadCall = this.makeBatchCall(ctx, pixelsID, userID);
    }
}

