/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.chooser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.env.data.model.FileObject;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class FileElement {
    private FileObject file;
    private String name;
    private long length;
    private boolean toggleContainer;
    private int type;
    private GroupData group;
    private ExperimenterData user;

    FileElement(FileObject file, int type, GroupData group, ExperimenterData user) {
        if (file == null) {
            throw new IllegalArgumentException("No file set");
        }
        this.file = file;
        this.type = type;
        this.group = group;
        this.user = user;
        this.length = -1L;
        if (type == 1) {
            this.toggleContainer = false;
        }
    }

    void setToggleContainer(boolean toggleContainer) {
        this.toggleContainer = toggleContainer;
    }

    boolean isToggleContainer() {
        if (this.type == 1) {
            return false;
        }
        return this.toggleContainer;
    }

    int getType() {
        return this.type;
    }

    long getFileLength() {
        if (this.length > 0L) {
            return this.length;
        }
        return this.file.getLength();
    }

    String getFileLengthAsString() {
        long l = this.getFileLength();
        if (l > 0L) {
            return UIUtilities.formatFileSize(l);
        }
        if (l == 0L) {
            return "empty";
        }
        return "--";
    }

    boolean isDirectory() {
        if (this.file.getFile() instanceof File) {
            File f = (File)this.file.getFile();
            if (f.isFile()) {
                return false;
            }
            File[] list = f.listFiles();
            return list != null && list.length != 0;
        }
        return false;
    }

    List<File> getFiles() {
        if (!this.isDirectory()) {
            return null;
        }
        File f = (File)this.file.getFile();
        File[] list = f.listFiles();
        ArrayList<File> files = new ArrayList<File>();
        if (list == null || list.length == 0) {
            return files;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isDirectory()) continue;
            files.add(list[i]);
        }
        return files;
    }

    String getName() {
        if (this.name == null) {
            return this.file.getName();
        }
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public FileObject getFile() {
        return this.file;
    }

    public GroupData getGroup() {
        return this.group;
    }

    public String toString() {
        return this.getName();
    }

    public ExperimenterData getUser() {
        return this.user;
    }
}

