/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import omero.model.Length;
import omero.model.enums.UnitsLength;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.imviewer.browser.GridUI;
import org.openmicroscopy.shoola.agents.imviewer.browser.ProjectionUI;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

class BrowserComponent
extends AbstractComponent
implements Browser {
    private BrowserModel model;
    private BrowserControl controller;
    private BrowserUI view;
    private GridUI gridView;
    private ProjectionUI projectionView;

    BrowserComponent(BrowserModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new BrowserControl();
        model.getParentModel().addPropertyChangeListener(this.controller);
        this.view = new BrowserUI();
        this.gridView = new GridUI();
        this.projectionView = new ProjectionUI();
        this.view.setSibling(1, this.gridView);
        this.view.setSibling(2, this.projectionView);
    }

    void initialize() {
        this.model.initialize(this);
        this.controller.initialize(this, this.view);
        this.view.initialize(this.controller, this.model);
        this.gridView.initialize(this.model, this.view);
        this.projectionView.initialize(this.model, this.view);
    }

    @Override
    public JComponent getUI() {
        return this.view;
    }

    @Override
    public void setRenderedImage(Object image) {
        if (image == null) {
            throw new IllegalArgumentException("Image cannot be null.");
        }
        boolean hasImage = this.model.hasImage();
        if (!(image instanceof BufferedImage)) {
            throw new IllegalArgumentException("Image type not supported.");
        }
        this.model.setRenderedImage((BufferedImage)image);
        if (!hasImage) {
            this.view.locateScrollBars();
        }
        this.paintImage();
    }

    private void paintImage() {
        this.view.paintMainImage();
        this.viewSplitImages();
    }

    @Override
    public BufferedImage getDisplayedImage() {
        return this.model.getDisplayedImage();
    }

    @Override
    public BufferedImage getRenderedImage() {
        return this.model.getRenderedImage();
    }

    @Override
    public void removeComponent(JComponent c, int index) {
        if (c == null) {
            throw new IllegalArgumentException("Component cannot be null.");
        }
        switch (index) {
            case 0: {
                this.view.removeComponentFromLayer(c);
                break;
            }
            case 1: {
                this.gridView.removeComponentFromLayer(c);
                break;
            }
            case 2: {
                this.projectionView.removeComponentFromLayer(c);
            }
        }
    }

    @Override
    public void addComponent(JComponent c, int index, boolean reset) {
        if (c == null) {
            throw new IllegalArgumentException("Component cannot be null.");
        }
        switch (index) {
            case 0: {
                this.view.addComponentToLayer(c, reset);
                break;
            }
            case 1: {
                this.gridView.addComponentToLayer(c);
                break;
            }
            case 2: {
                this.projectionView.addComponentToLayer(c);
            }
        }
    }

    @Override
    public void setZoomFactor(double factor, boolean reset) {
        int index = this.model.getSelectedIndex();
        if (factor != -1.0) {
            if (factor < 0.25) {
                factor = 0.25;
            } else if (factor > 3.0) {
                factor = 3.0;
            }
            this.model.setZoomFactor(factor);
            if (!reset) {
                if (index == 0) {
                    this.view.zoomImage();
                } else if (index == 2) {
                    this.projectionView.zoomImage(true);
                }
            }
        } else {
            BufferedImage img = null;
            Dimension viewport = null;
            if (index == 0) {
                img = this.model.getRenderedImage();
                viewport = this.view.getViewportSize();
            } else if (index == 2) {
                img = this.model.getProjectedImage();
                viewport = this.projectionView.getViewportSize();
            }
            if (img != null) {
                int width = img.getWidth();
                int height = img.getHeight();
                double zoomFactorX = 0.0;
                if (width > 0) {
                    zoomFactorX = viewport.getWidth() / (double)width;
                }
                double zoomFactorY = 0.0;
                if (height > 0) {
                    zoomFactorY = viewport.getHeight() / (double)height;
                }
                factor = Math.min(zoomFactorX, zoomFactorY);
            }
            this.model.setZoomFactor(factor);
            if (!(reset || index != 0 && index != 2)) {
                this.view.zoomImage();
                this.projectionView.zoomImage(true);
            }
        }
    }

    @Override
    public void setSelectedResolutionLevelZoomFactor(double ratio) {
        this.model.setZoomFactor(ratio);
    }

    @Override
    public double getZoomFactor() {
        return this.model.getZoomFactor();
    }

    @Override
    public String getTitle() {
        return this.model.getTitle();
    }

    @Override
    public Icon getIcon() {
        return this.model.getIcon();
    }

    @Override
    public void setComponentsSize(int w, int h) {
        this.view.setComponentsSize(w, h);
        this.view.setPreferredSize(new Dimension(w + 5, h + 5));
        this.gridView.setGridSize();
        this.projectionView.setComponentsSize(w, h);
    }

    @Override
    public void setUnitBar(boolean b) {
        if (b == this.model.isUnitBar()) {
            return;
        }
        this.model.setUnitBar(b);
        this.view.repaint();
        int index = this.model.getSelectedIndex();
        if (index == 1) {
            this.gridView.repaint();
        } else if (index == 2) {
            this.projectionView.repaint();
        }
    }

    @Override
    public void setUnitBarSize(double size, UnitsLength unit) {
        double oldUnit = this.model.getUnitInRefUnits();
        this.model.setUnitBarSize(size, unit);
        Rectangle viewRect = this.view.getViewport().getBounds();
        if ((double)viewRect.width >= this.model.getUnitBarSize()) {
            this.view.repaint();
            int index = this.model.getSelectedIndex();
            if (index == 1) {
                this.gridView.repaint();
            } else if (index == 2) {
                this.projectionView.repaint();
            }
            return;
        }
        if (viewRect.width > 0) {
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Scale bar size", "A scale bar of the selected size: " + size + "\ncannot be displayed on the image. Please select a new size.");
            this.model.setUnitBarSize(oldUnit, unit);
        }
    }

    @Override
    public boolean isUnitBar() {
        return this.model.isUnitBar();
    }

    @Override
    public String getUnitBarValue() {
        return this.model.getUnitBarValue();
    }

    @Override
    public double getUnitBarSize() {
        return this.model.getUnitBarSize();
    }

    @Override
    public Color getUnitBarColor() {
        return this.model.getUnitBarColor();
    }

    @Override
    public void setUnitBarColor(Color color) {
        if (this.model.getUnitBarColor().equals(color)) {
            return;
        }
        this.model.setUnitBarColor(color);
        this.view.repaint();
        int index = this.model.getSelectedIndex();
        if (index == 1) {
            this.gridView.repaint();
        } else if (index == 2) {
            this.projectionView.repaint();
        }
    }

    @Override
    public void scrollTo(Rectangle bounds, boolean blockIncrement) {
        if (bounds == null) {
            return;
        }
        this.view.scrollTo(bounds, blockIncrement);
    }

    @Override
    public void onComponentResized() {
        this.view.onComponentResized();
    }

    @Override
    public void setBackgroundColor(Color color) {
        if (this.model.getBackgroundColor().equals(color)) {
            return;
        }
        this.model.setBackgroundColor(color);
        this.view.getViewport().setBackground(color);
        int index = this.model.getSelectedIndex();
        if (index == 1) {
            this.gridView.getViewport().setBackground(color);
        } else if (index == 2) {
            this.projectionView.getViewport().setBackground(color);
        }
    }

    @Override
    public Color getBackgroundColor() {
        return this.model.getBackgroundColor();
    }

    @Override
    public JComponent getGridView() {
        return this.gridView;
    }

    @Override
    public JComponent getProjectionView() {
        return this.projectionView;
    }

    @Override
    public void setSelectedPane(int index) {
        switch (index) {
            case 1: {
                if (this.model.hasNoGridImages()) {
                    this.model.setGridImages();
                }
                this.gridView.paintImage();
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                this.view.zoomImage();
            }
        }
    }

    @Override
    public Icon getGridViewIcon() {
        return this.model.getGridViewIcon();
    }

    @Override
    public String getGridViewTitle() {
        return this.model.getGridViewTitle();
    }

    @Override
    public Icon getProjectionViewIcon() {
        return this.model.getProjectionViewIcon();
    }

    @Override
    public String getProjectionViewTitle() {
        return this.model.getProjectionViewTitle();
    }

    @Override
    public void viewSplitImages() {
        if (this.model.getSelectedIndex() != 1) {
            return;
        }
        this.model.setGridImages();
        if (this.gridView != null) {
            this.gridView.repaint();
        }
    }

    @Override
    public BufferedImage getGridImage() {
        if (this.model.getCombinedImage() != null) {
            return this.gridView.getGridImage();
        }
        this.model.setGridImages();
        return this.gridView.getGridImage();
    }

    @Override
    public Point isOnImageInGrid(Rectangle rect) {
        return this.gridView.isOnImageInGrid(rect);
    }

    @Override
    public double getRatio() {
        return this.model.getRatio();
    }

    @Override
    public void setGridRatio(double r) {
        this.model.setGridRatio(r);
        this.gridView.setGridRatio();
    }

    @Override
    public double getGridRatio() {
        return this.model.getGridRatio();
    }

    @Override
    public void initializeMagnificationFactor(double f) {
        this.model.setZoomFactor(f);
    }

    @Override
    public void setRenderProjected(Object image) {
        if (image == null) {
            throw new IllegalArgumentException("Image cannot be null.");
        }
        if (image instanceof BufferedImage) {
            this.model.setProjectedImage((BufferedImage)image);
            this.model.createDisplayedProjectedImage();
            BufferedImage img = this.model.getDisplayedProjectedImage();
            if (img == null) {
                return;
            }
        }
        this.projectionView.zoomImage(false);
        this.projectionView.repaint();
    }

    @Override
    public boolean hasProjectedPreview() {
        return this.model.getProjectedImage() != null;
    }

    @Override
    public BufferedImage getDisplayedProjectedImage() {
        return this.model.getDisplayedProjectedImage();
    }

    @Override
    public BufferedImage getProjectedImage() {
        return this.model.getProjectedImage();
    }

    @Override
    public void onColorModelChange() {
        this.view.clearGridImages();
        this.viewSplitImages();
    }

    @Override
    public double getUnitInRefUnits() {
        return this.model.getUnitInRefUnits();
    }

    @Override
    public void setBirdEyeView(BufferedImage image) {
        if (this.view == null) {
            return;
        }
        this.view.setBirdEyeView(image);
    }

    @Override
    public Rectangle getVisibleRectangle() {
        if (this.view == null) {
            return null;
        }
        return this.view.getVisibleRectangle();
    }

    @Override
    public void setSelectedRegion(Rectangle region) {
        if (this.view == null || region == null) {
            return;
        }
        this.view.setSelectedRegion(region);
    }

    @Override
    public void onStateChange(boolean b) {
        if (this.view == null) {
            return;
        }
        this.view.onStateChange(b);
    }

    @Override
    public void setViewLocation(double rx, double ry) {
        if (this.view == null) {
            return;
        }
        this.view.setViewLocation(rx, ry);
    }

    @Override
    public void discard() {
        this.model.discard();
        if (this.model.isBigImage()) {
            this.view.setBirdEyeView(null);
        }
    }

    @Override
    public boolean isInterpolation() {
        return this.model.isInterpolation();
    }

    @Override
    public void setInterpolation(boolean interpolation) {
        this.model.setInterpolation(interpolation);
        this.paintImage();
    }

    @Override
    public Length getUnitBarLength() {
        return this.model.getUnitBarLength();
    }
}

