/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.rnd.ControlPane;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererModel;

class CodomainPane
extends ControlPane {
    private JButton contrastStretchingButton;
    private JButton planeSlicingButton;
    private JCheckBox reverseIntensity;
    private JCheckBox contrastStretching;
    private JCheckBox planeSlicing;

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        this.contrastStretchingButton = new JButton(icons.getIcon(63));
        this.contrastStretchingButton.setEnabled(false);
        this.contrastStretchingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.planeSlicingButton = new JButton(icons.getIcon(64));
        this.planeSlicingButton.setEnabled(false);
        this.planeSlicingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.reverseIntensity = new JCheckBox(this.controller.getAction(RendererControl.REVERSE_INTENSITY));
        this.planeSlicing = new JCheckBox(this.controller.getAction(RendererControl.PLANE_SLICING));
        this.contrastStretching = new JCheckBox(this.controller.getAction(RendererControl.CONTRAST_STRETCHING));
        this.setDefaultValues();
    }

    private void setDefaultValues() {
    }

    private JPanel buildControlsPane() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        p.add((Component)this.reverseIntensity, c);
        ++c.gridy;
        p.add((Component)this.contrastStretching, c);
        c.gridx += 2;
        p.add((Component)this.contrastStretchingButton, c);
        c.gridx = 0;
        ++c.gridy;
        p.add((Component)this.planeSlicing, c);
        c.gridx += 2;
        p.add((Component)this.planeSlicingButton, c);
        return p;
    }

    private void buildGUI() {
        this.setLayout(new FlowLayout(0));
        this.add(this.buildControlsPane());
    }

    @Override
    protected String getPaneName() {
        return "Device Settings";
    }

    @Override
    protected Icon getPaneIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(65);
    }

    @Override
    protected String getPaneDescription() {
        return "Selects the transformations happening in the device space.";
    }

    @Override
    protected int getPaneIndex() {
        return 2;
    }

    @Override
    protected void resetDefaultRndSettings() {
        this.reverseIntensity.removeActionListener(this.controller.getAction(RendererControl.REVERSE_INTENSITY));
        this.planeSlicing.removeActionListener(this.controller.getAction(RendererControl.PLANE_SLICING));
        this.contrastStretching.removeActionListener(this.controller.getAction(RendererControl.CONTRAST_STRETCHING));
        this.setDefaultValues();
        this.reverseIntensity.setAction(this.controller.getAction(RendererControl.REVERSE_INTENSITY));
        this.planeSlicing.setAction(this.controller.getAction(RendererControl.PLANE_SLICING));
        this.contrastStretching.setAction(this.controller.getAction(RendererControl.CONTRAST_STRETCHING));
    }

    @Override
    protected void onStateChange(boolean b) {
    }

    @Override
    protected void switchRndControl() {
        this.resetDefaultRndSettings();
    }

    CodomainPane(RendererModel model, RendererControl controller) {
        super(model, controller);
        this.initComponents();
        this.buildGUI();
    }

    void addCodomainMap(Class mapType) {
    }

    void removeCodomainMap(Class mapType) {
    }
}

