/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class SendFeedbackAction
extends TreeViewerAction {
    private static final String NAME = "Send Feedback...";
    private static final String DESCRIPTION = "Send feedback about the selected image.";

    @Override
    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        TreeImageDisplay[] selected = browser.getSelectedDisplays();
        if (selected != null && selected.length > 1) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(ho instanceof ImageData);
    }

    public SendFeedbackAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(143));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        TreeImageDisplay display = browser.getLastSelectedDisplay();
        if (display == null) {
            return;
        }
        Object object = display.getUserObject();
        if (object instanceof ImageData) {
            ImageData image = (ImageData)object;
            String text = "Image Name: " + image.getName();
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            ExperimenterData exp = TreeViewerAgent.getUserDetails();
            un.submitMessage(exp.getEmail(), text);
        }
    }
}

