/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.concur.tasks;

import org.openmicroscopy.shoola.util.concur.ControlFlowObserver;
import org.openmicroscopy.shoola.util.concur.tasks.ExecMonitor;
import org.openmicroscopy.shoola.util.concur.tasks.Future;
import org.openmicroscopy.shoola.util.concur.tasks.MultiStepTask;
import org.openmicroscopy.shoola.util.concur.tasks.ResultAssembler;

class ExecCommand
implements Runnable {
    static final int READY = 0;
    static final int EXECUTING = 1;
    static final int FINISHED = 2;
    static final int CANCELLED = 3;
    private int state;
    private Thread executor;
    private final MultiStepTask task;
    private final ResultAssembler assembler;
    private final Future future;
    private final ExecMonitor observer;
    static final int LOCK_ACQUIRED_BY_ENTER_EXECUTING = 100;
    static final int LOCK_ACQUIRED_BY_LEAVE_EXECUTING = 101;
    static final int LOCK_ACQUIRED_BY_CANCEL = 102;
    private ControlFlowObserver flowObs;

    ExecCommand(MultiStepTask t, ResultAssembler ra, Future f, ExecMonitor em) {
        if (t == null) {
            throw new NullPointerException("No task.");
        }
        if (ra == null) {
            throw new NullPointerException("No result assembler.");
        }
        if (f == null) {
            throw new NullPointerException("No future.");
        }
        if (em == null) {
            throw new NullPointerException("No execution monitor.");
        }
        this.task = t;
        this.assembler = ra;
        this.future = f;
        this.observer = em;
        this.state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void exec() {
        int step = 0;
        Object result = null;
        Throwable abortCause = null;
        try {
            this.observer.onStart();
            while (!this.task.isDone()) {
                if (this.executor.isInterrupted()) {
                    throw new InterruptedException();
                }
                Object partialResult = this.task.doStep();
                if (this.executor.isInterrupted()) {
                    throw new InterruptedException();
                }
                this.assembler.add(partialResult);
                this.observer.update(++step);
            }
            result = this.assembler.assemble();
            this.observer.onEnd(result);
            if (abortCause != null) {
                this.future.setException(abortCause);
            } else {
                this.future.setResult(result);
            }
        }
        catch (InterruptedException ie) {
            this.observer.onCancel();
            if (abortCause != null) {
                this.future.setException(abortCause);
            } else {
                this.future.setResult(result);
            }
        }
        catch (Throwable t) {
            abortCause = t;
            this.observer.onAbort(t);
            if (abortCause != null) {
                this.future.setException(abortCause);
            } else {
                this.future.setResult(result);
            }
            {
                catch (Throwable throwable) {
                    if (abortCause != null) {
                        this.future.setException(abortCause);
                    } else {
                        this.future.setResult(result);
                    }
                    throw throwable;
                }
            }
        }
    }

    private synchronized boolean enterExecuting() {
        if (this.flowObs != null) {
            this.flowObs.update(100);
        }
        boolean enter = true;
        switch (this.state) {
            case 0: {
                this.executor = Thread.currentThread();
                this.state = 1;
                break;
            }
            case 1: {
                throw new Error("Command is being executed.");
            }
            case 2: {
                throw new Error("Can't re-execute a command.");
            }
            case 3: {
                enter = false;
            }
        }
        return enter;
    }

    private synchronized void leaveExecuting() {
        if (this.flowObs != null) {
            this.flowObs.update(101);
        }
        if (this.executor != null) {
            boolean cancelled = this.executor.isInterrupted();
            this.executor = null;
            this.state = cancelled ? 3 : 2;
        } else {
            this.state = 2;
        }
    }

    synchronized void cancel() {
        if (this.flowObs != null) {
            this.flowObs.update(102);
        }
        switch (this.state) {
            case 0: {
                this.state = 3;
                this.future.setResult(null);
                this.observer.onCancel();
                break;
            }
            case 1: {
                break;
            }
        }
    }

    @Override
    public void run() {
        if (!this.enterExecuting()) {
            return;
        }
        try {
            this.exec();
        }
        finally {
            this.leaveExecuting();
        }
    }

    void register(ControlFlowObserver obs) {
        this.flowObs = obs;
    }

    synchronized int getState() {
        return this.state;
    }

    MultiStepTask getTask() {
        return this.task;
    }

    ResultAssembler getAssembler() {
        return this.assembler;
    }

    Future getFuture() {
        return this.future;
    }

    ExecMonitor getObserver() {
        return this.observer;
    }
}

