/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.filter.file;

import java.io.File;
import java.util.regex.Pattern;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;

public class RegExFileFilter
extends CustomizedFileFilter {
    private Pattern pattern;
    private String regEx;
    private String originalEx;

    private String parse(String ex) {
        Object newString = "";
        for (int i = 0; i < ex.length(); ++i) {
            newString = ex.charAt(i) == '*' ? (String)newString + ".*" : (ex.charAt(i) == '.' ? (String)newString + "[.]" : (ex.charAt(i) == '?' ? (String)newString + "." : (ex.charAt(i) == '{' ? (String)newString + "[{]" : (ex.charAt(i) == '}' ? (String)newString + "[}]" : (ex.charAt(i) == '(' ? (String)newString + "[(]" : (ex.charAt(i) == ')' ? (String)newString + "[)]" : (ex.charAt(i) == '_' ? (String)newString + "[_]" : (ex.charAt(i) == '+' ? (String)newString + "[+]" : (ex.charAt(i) == '-' ? (String)newString + "[-]" : (String)newString + ex.charAt(i))))))))));
        }
        return newString;
    }

    public RegExFileFilter(String regEx, boolean wildCardFilter) {
        if (regEx == null) {
            throw new IllegalArgumentException("RegEx cannot be null.");
        }
        this.originalEx = regEx;
        this.regEx = wildCardFilter ? this.parse(regEx.toLowerCase()) : regEx;
        this.pattern = Pattern.compile(this.regEx);
    }

    public RegExFileFilter(String regEx) {
        this(regEx, false);
    }

    public String getRegExpression() {
        return this.pattern.pattern();
    }

    public void setFilter(String filter, boolean wildCardFilter) {
        if (this.regEx == null) {
            throw new IllegalArgumentException("RegEx cannot be null.");
        }
        this.originalEx = filter;
        this.regEx = wildCardFilter ? this.parse(filter) : filter;
        this.pattern = Pattern.compile(this.regEx);
    }

    @Override
    public boolean accept(File file) {
        if (file == null) {
            return false;
        }
        return this.accept(file.getName());
    }

    public String[] getExtensions() {
        String[] extensions = new String[]{this.originalEx};
        return extensions;
    }

    @Override
    public String getMIMEType() {
        return "";
    }

    @Override
    public String getExtension() {
        return this.originalEx;
    }

    @Override
    public String getDescription() {
        return this.originalEx;
    }

    @Override
    public boolean accept(String name) {
        if (name == null) {
            return false;
        }
        return this.pattern.matcher(name.toLowerCase()).matches();
    }
}

