/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.image.roi;

import org.openmicroscopy.shoola.util.image.roi.ROI3D;
import org.openmicroscopy.shoola.util.image.roi.ROI4D;
import org.openmicroscopy.shoola.util.math.geom2D.PlaneArea;
import org.openmicroscopy.shoola.util.mem.Copiable;
import org.openmicroscopy.shoola.util.mem.CopiableArray;

public class ROI5D
extends CopiableArray {
    public ROI5D(int size) {
        super(size);
    }

    @Override
    protected CopiableArray makeNew(int size) {
        return new ROI5D(size);
    }

    @Override
    public void set(Copiable roi4D, int channel) {
        if (!(roi4D instanceof ROI4D)) {
            throw new IllegalArgumentException();
        }
        super.set(roi4D, channel);
    }

    public void setChannel(ROI4D stackAcrossTimeROI, int channel) {
        this.set(stackAcrossTimeROI, channel);
    }

    public ROI4D getChannel(int channel) {
        return (ROI4D)this.get(channel);
    }

    public PlaneArea getPlaneArea(int z, int t, int channel) {
        ROI4D stackAcrossTimeROI = (ROI4D)this.get(channel);
        if (stackAcrossTimeROI == null) {
            return null;
        }
        ROI3D stackROI = (ROI3D)stackAcrossTimeROI.get(t);
        if (stackROI == null) {
            return null;
        }
        return stackROI.getPlaneArea(z);
    }

    public void setPlaneArea(PlaneArea pa, int z, int t, int channel) {
        ROI3D stackROI;
        ROI4D stackAcrossTimeROI = (ROI4D)this.get(channel);
        if (stackAcrossTimeROI != null && (stackROI = (ROI3D)stackAcrossTimeROI.get(t)) != null) {
            stackROI.setPlaneArea(pa, z);
        }
    }
}

