/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourIcon;
import org.openmicroscopy.shoola.util.ui.colourpicker.LookupTableIconUtil;
import org.openmicroscopy.shoola.util.ui.colourpicker.LookupTableItem;

public class LookupTableListRenderer
extends JLabel
implements ListCellRenderer {
    private static final Dimension ICON_DIM = new Dimension(96, 24);
    private static ColourIcon icon = new ColourIcon(LookupTableListRenderer.ICON_DIM.width, LookupTableListRenderer.ICON_DIM.height);
    private Border lineBorder = BorderFactory.createLineBorder(Color.gray, 1);
    private Border emptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!(value instanceof LookupTableItem)) {
            return this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
        this.setOpaque(true);
        LookupTableItem item = (LookupTableItem)value;
        if (value == LookupTableItem.SEPARATOR) {
            return new JSeparator(0);
        }
        this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        this.setBorder(cellHasFocus ? this.lineBorder : this.emptyBorder);
        if (item.hasLookupTable()) {
            Icon icon = LookupTableIconUtil.getLUTIcon(item.getFilename(), ICON_DIM);
            this.setIcon(icon);
            this.setText(item.getLabel());
        } else {
            Color newCol = new Color(item.getColor().getRed(), item.getColor().getGreen(), item.getColor().getBlue());
            icon.setColour(newCol);
            this.setIcon(icon);
            this.setVerticalAlignment(0);
            this.setIconTextGap(40);
            this.setText(item.getLabel());
        }
        return this;
    }
}

