/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re.quantum;

import ome.model.core.Pixels;
import ome.model.display.QuantumDef;
import ome.model.enums.PixelsType;
import omeis.providers.re.quantum.QuantizationException;
import omeis.providers.re.quantum.QuantumStrategy;

public class BinaryMaskQuantizer
extends QuantumStrategy {
    public BinaryMaskQuantizer(QuantumDef qd, Pixels pixels) {
        super(qd, pixels);
        PixelsType type = pixels.getPixelsType();
        if (!"bit".equals(type.getValue())) {
            throw new IllegalArgumentException("The type " + type.getValue() + " != 'bit'.");
        }
    }

    @Override
    public int quantize(double value) throws QuantizationException {
        if (value == 0.0) {
            return 0;
        }
        if (value == 1.0) {
            return 255;
        }
        throw new QuantizationException("The value " + value + " is not 0.0 or 1.0.");
    }

    @Override
    protected void onWindowChange() {
    }
}

