/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hpsf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import loci.poi.hpsf.ClassID;
import loci.poi.hpsf.HPSFRuntimeException;
import loci.poi.hpsf.IllegalPropertySetDataException;
import loci.poi.hpsf.MutableProperty;
import loci.poi.hpsf.Property;
import loci.poi.hpsf.Section;
import loci.poi.hpsf.TypeWriter;
import loci.poi.hpsf.Util;
import loci.poi.hpsf.VariantSupport;
import loci.poi.hpsf.WritingNotSupportedException;

public class MutableSection
extends Section {
    private boolean dirty = true;
    private List preprops;
    private byte[] sectionBytes;

    public MutableSection() {
        this.dirty = true;
        this.formatID = null;
        this.offset = -1L;
        this.preprops = new LinkedList();
    }

    public MutableSection(Section s) {
        this.setFormatID(s.getFormatID());
        Property[] pa = s.getProperties();
        Property[] mpa = new MutableProperty[pa.length];
        for (int i = 0; i < pa.length; ++i) {
            mpa[i] = new MutableProperty(pa[i]);
        }
        this.setProperties(mpa);
        this.setDictionary(s.getDictionary());
    }

    public void setFormatID(ClassID formatID) {
        this.formatID = formatID;
    }

    public void setFormatID(byte[] formatID) {
        ClassID fid = this.getFormatID();
        if (fid == null) {
            fid = new ClassID();
            this.setFormatID(fid);
        }
        fid.setBytes(formatID);
    }

    public void setProperties(Property[] properties) {
        this.properties = properties;
        this.preprops = new LinkedList();
        for (int i = 0; i < properties.length; ++i) {
            this.preprops.add(properties[i]);
        }
        this.dirty = true;
    }

    public void setProperty(int id, String value) {
        this.setProperty(id, 31L, value);
        this.dirty = true;
    }

    public void setProperty(int id, int value) {
        this.setProperty(id, 3L, new Integer(value));
        this.dirty = true;
    }

    public void setProperty(int id, long value) {
        this.setProperty(id, 20L, new Long(value));
        this.dirty = true;
    }

    public void setProperty(int id, boolean value) {
        this.setProperty(id, 11L, new Boolean(value));
        this.dirty = true;
    }

    public void setProperty(int id, long variantType, Object value) {
        MutableProperty p = new MutableProperty();
        p.setID(id);
        p.setType(variantType);
        p.setValue(value);
        this.setProperty(p);
        this.dirty = true;
    }

    public void setProperty(Property p) {
        long id = p.getID();
        this.removeProperty(id);
        this.preprops.add(p);
        this.dirty = true;
    }

    public void removeProperty(long id) {
        Iterator i = this.preprops.iterator();
        while (i.hasNext()) {
            if (((Property)i.next()).getID() != id) continue;
            i.remove();
            break;
        }
        this.dirty = true;
    }

    protected void setPropertyBooleanValue(int id, boolean value) {
        this.setProperty(id, 11L, new Boolean(value));
    }

    @Override
    public int getSize() {
        if (this.dirty) {
            try {
                this.size = this.calcSize();
                this.dirty = false;
            }
            catch (HPSFRuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new HPSFRuntimeException(ex);
            }
        }
        return this.size;
    }

    private int calcSize() throws WritingNotSupportedException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.write(out);
        out.close();
        this.sectionBytes = Util.pad4(out.toByteArray());
        return this.sectionBytes.length;
    }

    public int write(OutputStream out) throws WritingNotSupportedException, IOException {
        if (!this.dirty && this.sectionBytes != null) {
            out.write(this.sectionBytes);
            return this.sectionBytes.length;
        }
        ByteArrayOutputStream propertyStream = new ByteArrayOutputStream();
        ByteArrayOutputStream propertyListStream = new ByteArrayOutputStream();
        int position = 0;
        position += 8 + this.getPropertyCount() * 2 * 4;
        int codepage = -1;
        if (this.getProperty(0L) != null) {
            Object p1 = this.getProperty(1L);
            if (p1 != null) {
                if (!(p1 instanceof Integer)) {
                    throw new IllegalPropertySetDataException("The codepage property (ID = 1) must be an Integer object.");
                }
            } else {
                this.setProperty(1, 2L, new Integer(1200));
            }
            codepage = this.getCodepage();
        }
        Collections.sort(this.preprops, new Comparator(){

            public int compare(Object o1, Object o2) {
                Property p1 = (Property)o1;
                Property p2 = (Property)o2;
                if (p1.getID() < p2.getID()) {
                    return -1;
                }
                if (p1.getID() == p2.getID()) {
                    return 0;
                }
                return 1;
            }
        });
        ListIterator i = this.preprops.listIterator();
        while (i.hasNext()) {
            MutableProperty p = (MutableProperty)i.next();
            long id = p.getID();
            TypeWriter.writeUIntToStream(propertyListStream, p.getID());
            TypeWriter.writeUIntToStream(propertyListStream, position);
            if (id != 0L) {
                position += p.write(propertyStream, this.getCodepage());
                continue;
            }
            if (codepage == -1) {
                throw new IllegalPropertySetDataException("Codepage (property 1) is undefined.");
            }
            position += MutableSection.writeDictionary(propertyStream, this.dictionary, codepage);
        }
        propertyStream.close();
        propertyListStream.close();
        byte[] pb1 = propertyListStream.toByteArray();
        byte[] pb2 = propertyStream.toByteArray();
        TypeWriter.writeToStream(out, 8 + pb1.length + pb2.length);
        TypeWriter.writeToStream(out, this.getPropertyCount());
        out.write(pb1);
        out.write(pb2);
        int streamLength = 8 + pb1.length + pb2.length;
        return streamLength;
    }

    private static int writeDictionary(OutputStream out, Map dictionary, int codepage) throws IOException {
        int length = TypeWriter.writeUIntToStream(out, dictionary.size());
        for (Long key : dictionary.keySet()) {
            String value = (String)dictionary.get(key);
            if (codepage == 1200) {
                int sLength = value.length() + 1;
                if (sLength % 2 == 1) {
                    ++sLength;
                }
                length += TypeWriter.writeUIntToStream(out, key);
                length += TypeWriter.writeUIntToStream(out, sLength);
                byte[] ca = value.getBytes(VariantSupport.codepageToEncoding(codepage));
                for (int j = 2; j < ca.length; j += 2) {
                    out.write(ca[j + 1]);
                    out.write(ca[j]);
                    length += 2;
                }
                sLength -= value.length();
                while (sLength > 0) {
                    out.write(0);
                    out.write(0);
                    length += 2;
                    --sLength;
                }
                continue;
            }
            length += TypeWriter.writeUIntToStream(out, key);
            length += TypeWriter.writeUIntToStream(out, value.length() + 1);
            byte[] ba = value.getBytes(VariantSupport.codepageToEncoding(codepage));
            for (int j = 0; j < ba.length; ++j) {
                out.write(ba[j]);
                ++length;
            }
            out.write(0);
            ++length;
        }
        return length;
    }

    @Override
    public int getPropertyCount() {
        return this.preprops.size();
    }

    @Override
    public Property[] getProperties() {
        this.properties = this.preprops.toArray(new Property[0]);
        return this.properties;
    }

    @Override
    public Object getProperty(long id) {
        this.getProperties();
        return super.getProperty(id);
    }

    public void setDictionary(Map dictionary) throws IllegalPropertySetDataException {
        if (dictionary != null) {
            Iterator<Object> i = dictionary.keySet().iterator();
            while (i.hasNext()) {
                if (i.next() instanceof Long) continue;
                throw new IllegalPropertySetDataException("Dictionary keys must be of type Long.");
            }
            i = dictionary.values().iterator();
            while (i.hasNext()) {
                if (i.next() instanceof String) continue;
                throw new IllegalPropertySetDataException("Dictionary values must be of type String.");
            }
            this.dictionary = dictionary;
            this.setProperty(0, -1L, dictionary);
            Integer codepage = (Integer)this.getProperty(1L);
            if (codepage == null) {
                this.setProperty(1, 2L, new Integer(1200));
            }
        } else {
            this.removeProperty(0L);
        }
    }

    public void setProperty(int id, Object value) {
        if (value instanceof String) {
            this.setProperty(id, (String)value);
        } else if (value instanceof Long) {
            this.setProperty(id, (Long)value);
        } else if (value instanceof Integer) {
            this.setProperty(id, (Integer)value);
        } else if (value instanceof Short) {
            this.setProperty(id, ((Short)value).intValue());
        } else if (value instanceof Boolean) {
            this.setProperty(id, (Boolean)value);
        } else if (value instanceof Date) {
            this.setProperty(id, 64L, value);
        } else {
            throw new HPSFRuntimeException("HPSF does not support properties of type " + value.getClass().getName() + ".");
        }
    }

    public void clear() {
        Property[] properties = this.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            Property p = properties[i];
            this.removeProperty(p.getID());
        }
    }

    public void setCodepage(int codepage) {
        this.setProperty(1, 2L, new Integer(codepage));
    }
}

