/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ome.xml.model.Dichroic;
import ome.xml.model.Filter;
import ome.xml.model.enums.FilterType;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleController;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleTreeElement;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;

public class MDEHelper {
    public static final String APPLICATION_NAME = "MDE";
    public static final String VERSION = "1.1.0";
    public static final String SELECTOR = "#";

    public static String printList(String string, Map<String, List<TagData>> list) {
        String result = "\t## " + string + " ##\n";
        if (list == null || list.isEmpty()) {
            return result;
        }
        for (Map.Entry<String, List<TagData>> entry : list.entrySet()) {
            result = result + "\t" + entry.getKey() + " :\n ";
            for (TagData t : entry.getValue()) {
                result = result + "\t\t" + t.tagToString() + "\n";
            }
        }
        return result;
    }

    public static HashMap<String, List<TagData>> getAllData(DefaultMutableTreeNode contentTree) {
        if (contentTree == null) {
            return null;
        }
        HashMap<String, List<TagData>> result = new HashMap<String, List<TagData>>();
        if (((ModuleTreeElement)contentTree.getUserObject()).isContainer()) {
            for (int i = 0; i < contentTree.getChildCount(); ++i) {
                HashMap<String, List<TagData>> r = MDEHelper.getAllData((DefaultMutableTreeNode)contentTree.getChildAt(i));
                if (r == null || r.isEmpty()) continue;
                result.putAll(r);
            }
        } else {
            Enumeration<TreeNode> e = contentTree.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                List<TagData> res;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                if (((ModuleTreeElement)node.getUserObject()).isContainer() || (res = ((ModuleTreeElement)node.getUserObject()).getData().getTagList()) == null || res.isEmpty()) continue;
                String id = MDEHelper.generateTreePathForKey(node);
                result.put(id, res);
            }
        }
        return result;
    }

    public static HashMap<String, List<TagData>> getInput(DefaultMutableTreeNode contentTree) {
        if (contentTree == null) {
            return null;
        }
        HashMap<String, List<TagData>> result = new HashMap<String, List<TagData>>();
        if (((ModuleTreeElement)contentTree.getUserObject()).isContainer()) {
            for (int i = 0; i < contentTree.getChildCount(); ++i) {
                HashMap<String, List<TagData>> r = MDEHelper.getInput((DefaultMutableTreeNode)contentTree.getChildAt(i));
                if (r == null || r.isEmpty()) continue;
                result.putAll(r);
            }
        } else {
            Enumeration<TreeNode> e = contentTree.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                List<TagData> res;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                if (((ModuleTreeElement)node.getUserObject()).isContainer() || (res = ((ModuleTreeElement)node.getUserObject()).getData().getInput()) == null || res.isEmpty()) continue;
                String id = MDEHelper.generateTreePathForKey(node);
                result.put(id, res);
            }
        }
        return result;
    }

    private static String generateTreePathForKey(DefaultMutableTreeNode node) {
        Object res = ((ModuleTreeElement)node.getUserObject()).getElementName();
        while (node.getParent() != null) {
            res = ((ModuleTreeElement)((DefaultMutableTreeNode)node.getParent()).getUserObject()).getElementName() + SELECTOR + (String)res;
            node = (DefaultMutableTreeNode)node.getParent();
        }
        return res;
    }

    public static void resetInput(DefaultMutableTreeNode contentTree) {
        if (contentTree == null) {
            return;
        }
        ImporterAgent.getRegistry().getLogger().debug(null, "[MDE] reset input of object tree");
        Enumeration<TreeNode> e = contentTree.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (((ModuleTreeElement)node.getUserObject()).isContainer()) continue;
            ((ModuleTreeElement)node.getUserObject()).resetInput();
        }
    }

    public static boolean compareTrees(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
        List<String> leafsN2;
        List<String> leafsN1 = MDEHelper.getAllLeafPaths(n1, "");
        if (leafsN1.containsAll(leafsN2 = MDEHelper.getAllLeafPaths(n2, "")) && leafsN1.size() == leafsN2.size()) {
            return true;
        }
        ArrayList<String> different = new ArrayList<String>();
        different.addAll(leafsN1);
        different.addAll(leafsN2);
        leafsN1.retainAll(leafsN2);
        different.removeAll(leafsN1);
        return false;
    }

    public static List<String> getAdditionalLeafsInTree(DefaultMutableTreeNode tree1, DefaultMutableTreeNode tree2) {
        List<String> leafsN2;
        List<String> leafsN1 = MDEHelper.getAllLeafPaths(tree1, "");
        if (leafsN1.containsAll(leafsN2 = MDEHelper.getAllLeafPaths(tree2, "")) && leafsN1.size() == leafsN2.size()) {
            return null;
        }
        return MDEHelper.getAdditionalLeafPaths(leafsN1, leafsN2);
    }

    public static List<String> getAdditionalLeafPaths(List<String> leafsN1, List<String> leafsN2) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : leafsN1) {
            if (leafsN2.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    public static List<String> getAllLeafPaths(DefaultMutableTreeNode tree, String parent) {
        String path = parent.equals("") ? tree.getUserObject().toString() : parent + SELECTOR + tree.getUserObject().toString();
        ArrayList<String> leafPathList = new ArrayList<String>();
        if (tree.getChildCount() == 0) {
            leafPathList.add(path);
            return leafPathList;
        }
        for (int i = 0; i < tree.getChildCount(); ++i) {
            List<String> result = MDEHelper.getAllLeafPaths((DefaultMutableTreeNode)tree.getChildAt(i), path);
            leafPathList.addAll(result);
        }
        return leafPathList;
    }

    public static List<DefaultMutableTreeNode> getListOfChilds(String type, DefaultMutableTreeNode tree) {
        if (type == null || type.equals("") || tree == null) {
            return null;
        }
        ArrayList<DefaultMutableTreeNode> list = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < tree.getChildCount(); ++i) {
            if (!((ModuleTreeElement)((DefaultMutableTreeNode)tree.getChildAt(i)).getUserObject()).getType().equals(type)) continue;
            list.add((DefaultMutableTreeNode)tree.getChildAt(i));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public static int getChildCount(String type, DefaultMutableTreeNode tree) {
        if (type == null || type.equals("") || tree == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < tree.getChildCount(); ++i) {
            if (!(((DefaultMutableTreeNode)tree.getChildAt(i)).getUserObject() instanceof ModuleTreeElement) || !((ModuleTreeElement)((DefaultMutableTreeNode)tree.getChildAt(i)).getUserObject()).getType().equals(type)) continue;
            ++count;
        }
        return count;
    }

    public static boolean compareNodes(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        if (n1 == null && n2 != null || n1 != null && n2 == null) {
            return false;
        }
        if (n1.getUserObject() != null && n2.getUserObject() != null && ((ModuleTreeElement)n1.getUserObject()).getType().equals(((ModuleTreeElement)n2.getUserObject()).getType())) {
            ModuleTreeElement mte1 = (ModuleTreeElement)n1.getUserObject();
            ModuleTreeElement mte2 = (ModuleTreeElement)n2.getUserObject();
            if (mte1.getType() != null && mte1.getType().equals(mte2.getType()) && mte1.getChildIndex() == mte2.getChildIndex()) {
                return true;
            }
        }
        return false;
    }

    private static DefaultMutableTreeNode findNode(DefaultMutableTreeNode n, DefaultMutableTreeNode tree) {
        Enumeration<TreeNode> e = tree.preorderEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode d = (DefaultMutableTreeNode)e.nextElement();
            if (!MDEHelper.compareNodes(n, d)) continue;
            return d;
        }
        return null;
    }

    public static DefaultMutableTreeNode getChildByName(DefaultMutableTreeNode tree, String name) {
        if (tree != null) {
            Enumeration<TreeNode> e = tree.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                if (!((ModuleTreeElement)node.getUserObject()).getElementName().trim().equals(name.trim())) continue;
                return node;
            }
        }
        return null;
    }

    public static List<DefaultMutableTreeNode> getChildsByType(DefaultMutableTreeNode tree, String type) {
        if (tree != null) {
            ArrayList<DefaultMutableTreeNode> listOfChilds = new ArrayList<DefaultMutableTreeNode>();
            Enumeration<TreeNode> e = tree.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                if (!((ModuleTreeElement)node.getUserObject()).getType().trim().equals(type.trim())) continue;
                listOfChilds.add(node);
            }
            return listOfChilds.size() > 0 ? listOfChilds : null;
        }
        return null;
    }

    private static DefaultMutableTreeNode getNodeByPath(DefaultMutableTreeNode tree, String path, boolean createNew) {
        if (path == null) {
            return null;
        }
        String[] nodeNames = path.split(SELECTOR);
        DefaultMutableTreeNode parent = MDEHelper.getChildByName(tree, nodeNames[0]);
        if (parent != null) {
            for (int i = 1; i < nodeNames.length; ++i) {
                DefaultMutableTreeNode child = MDEHelper.getChildByName(parent, nodeNames[i]);
                if (child == null && createNew) {
                    ImporterAgent.getRegistry().getLogger().debug(null, "-- Insert new node here " + parent.getUserObject().toString());
                    child = MDEHelper.createNode(nodeNames[i], parent);
                }
                parent = child;
            }
        }
        return parent;
    }

    private static DefaultMutableTreeNode createNode(String nodeName, DefaultMutableTreeNode parent) {
        ModuleTreeElement treeElem = ModuleController.getInstance().createElement(MDEHelper.getType(nodeName), parent);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(treeElem);
        parent.add(node);
        return node;
    }

    private static String getType(String name) {
        String result = null;
        result = name.substring(name.indexOf("[") + 1, name.lastIndexOf("]"));
        return result;
    }

    public static final Dichroic convertFilterToDichroic(Filter f) {
        Dichroic d = new Dichroic();
        d.setID(f.getID());
        d.setModel(f.getModel());
        d.setManufacturer(f.getManufacturer());
        d.setLotNumber(f.getLotNumber());
        d.setSerialNumber(f.getSerialNumber());
        d.setInstrument(f.getInstrument());
        return d;
    }

    public static final Filter convertDichroicToFilter(Dichroic d) {
        Filter f = new Filter();
        f.setID(d.getID());
        f.setModel(d.getModel());
        f.setManufacturer(d.getManufacturer());
        f.setLotNumber(d.getLotNumber());
        f.setSerialNumber(d.getSerialNumber());
        f.setInstrument(d.getInstrument());
        f.setType(FilterType.DICHROIC);
        return f;
    }

    public static boolean isEqual(ModuleContent c1, ModuleContent c2) {
        boolean result = false;
        if (c1 != null && c2 != null) {
            LinkedHashMap<String, TagData> tList1 = c1.getList();
            LinkedHashMap<String, TagData> tList2 = c2.getList();
            if (tList1 == null && tList2 == null) {
                return true;
            }
            if (tList1 == null && tList2 != null || tList1 != null && tList2 == null || tList1.size() != tList2.size()) {
                return false;
            }
            int falsePosCount = 0;
            for (Map.Entry<String, TagData> entry : tList1.entrySet()) {
                String key = entry.getKey();
                if (key.contains("User::")) continue;
                if (tList2.containsKey(key)) {
                    if (key.equals("ID")) {
                        if (entry.getValue().isEmptyValue() || tList2.get(key).isEmptyValue() || tList2.get(key).getTagValue().equals(entry.getValue().getTagValue())) continue;
                        ++falsePosCount;
                        continue;
                    }
                    if (tList2.get(key).getTagValue().equals(entry.getValue().getTagValue())) continue;
                    ++falsePosCount;
                    continue;
                }
                ++falsePosCount;
            }
            return falsePosCount <= 0;
        }
        return result;
    }

    public static void addData(DefaultMutableTreeNode tree, HashMap<String, List<TagData>> input) {
        for (Map.Entry<String, List<TagData>> entry : input.entrySet()) {
            DefaultMutableTreeNode node = MDEHelper.getNodeByPath(tree, entry.getKey(), false);
            if (node == null) continue;
            ModuleContent c = ((ModuleTreeElement)node.getUserObject()).getData();
            for (TagData t : entry.getValue()) {
                TagData newT = new TagData(t);
                newT.dataHasChanged(true);
                c.set(t.getTagName(), newT);
            }
        }
    }

    public static void replaceData(DefaultMutableTreeNode tree, HashMap<String, List<TagData>> input, boolean insertNode) {
        for (Map.Entry<String, List<TagData>> entry : input.entrySet()) {
            DefaultMutableTreeNode node = MDEHelper.getNodeByPath(tree, entry.getKey(), insertNode);
            if (node != null) {
                ModuleContent c = ((ModuleTreeElement)node.getUserObject()).getData();
                for (TagData t : entry.getValue()) {
                    c.set(t.getTagName(), new TagData(t));
                }
                continue;
            }
            ImporterAgent.getRegistry().getLogger().debug(null, "-- TODO: add new node data for " + entry.getKey() + "?? [MDEHelper::replaceData]");
        }
    }

    public static ModuleContent replaceData(ModuleContent currentC, ModuleContent newC) {
        ModuleContent result = currentC;
        if (newC == null) {
            return currentC;
        }
        if (currentC == null) {
            result = new ModuleContent(newC);
            result.setAllDataChanged();
            return result;
        }
        if (currentC.getType() != null && currentC.getType().equals(newC.getType())) {
            LinkedHashMap<String, TagData> l1 = currentC.getList();
            LinkedHashMap<String, TagData> l2 = newC.getList();
            if (l2 == null) {
                return currentC;
            }
            if (l1 == null) {
                result = new ModuleContent(newC);
                result.setAllDataChanged();
                return result;
            }
            for (Map.Entry<String, TagData> entry : l2.entrySet()) {
                String key = entry.getKey();
                TagData valIn = new TagData(entry.getValue());
                if (valIn == null || valIn.getTagValue() == null || valIn.getTagValue().equals("")) continue;
                if (l1.containsKey(key) && l1.get(key).isVisible()) {
                    valIn.dataHasChanged(true);
                    result.set(key, valIn);
                    ImporterAgent.getRegistry().getLogger().debug(null, "\t\t replace " + currentC.getType() + ":" + key + "[replaceData]");
                    continue;
                }
                ImporterAgent.getRegistry().getLogger().debug(null, "\t\t replace " + currentC.getType() + ":" + key + ": no key available [replaceData]");
            }
        }
        return result;
    }

    public static ModuleContent replaceUnchangedData(ModuleContent currentC, ModuleContent origC, ModuleContent newC) {
        ModuleContent result = currentC;
        if (newC == null) {
            return currentC;
        }
        if (currentC == null) {
            result = new ModuleContent(newC);
            result.setAllDataChanged();
            return result;
        }
        if (origC == null || origC.getList() == null || MDEHelper.isEqual(currentC, origC)) {
            return MDEHelper.replaceData(currentC, newC);
        }
        if (currentC.getType() != null && currentC.getType().equals(newC.getType())) {
            if (origC.getType() != null && !currentC.getType().equals(origC.getType())) {
                return MDEHelper.replaceData(currentC, newC);
            }
            LinkedHashMap<String, TagData> l1 = currentC.getList();
            LinkedHashMap<String, TagData> l2 = newC.getList();
            LinkedHashMap<String, TagData> l3 = origC.getList();
            if (l2 == null) {
                return currentC;
            }
            if (l1 == null) {
                result = new ModuleContent(newC);
                result.setAllDataChanged();
                return result;
            }
            for (Map.Entry<String, TagData> entry : l2.entrySet()) {
                String key = entry.getKey();
                TagData valIn = new TagData(entry.getValue());
                if (valIn == null || valIn.getTagValue() == null || valIn.getTagValue().equals("")) continue;
                if (l1.containsKey(key)) {
                    if (l1.get(key).getTagValue().trim().equals("") || l1.get(key).equalContent(l3.get(key))) {
                        valIn.dataHasChanged(true);
                        result.set(key, valIn);
                        continue;
                    }
                    ImporterAgent.getRegistry().getLogger().debug(null, "--Don't replace " + key + ": " + l1.get(key).tagToString() + " != " + l3.get(key).tagToString());
                    continue;
                }
                ImporterAgent.getRegistry().getLogger().debug(null, "\t\t replace " + currentC.getType() + ":" + key + ": no key available [MDEHelper::replaceUnchangedData]");
            }
        }
        return result;
    }

    public static ModuleContent completeData(ModuleContent currentC, ModuleContent newC) {
        ModuleContent result = new ModuleContent(currentC);
        if (newC == null) {
            return currentC;
        }
        if (currentC == null) {
            return newC;
        }
        if (currentC.getType() != null && currentC.getType().equals(newC.getType())) {
            LinkedHashMap<String, TagData> l1 = currentC.getList();
            LinkedHashMap<String, TagData> l2 = newC.getList();
            if (l2 == null) {
                return currentC;
            }
            if (l1 == null) {
                return newC;
            }
            for (Map.Entry<String, TagData> entry : l1.entrySet()) {
                if (entry.getValue() != null && entry.getValue().getTagValue() != null && !entry.getValue().getTagValue().equals("") || !l2.containsKey(entry.getKey())) continue;
                result.set(entry.getKey(), l2.get(entry.getKey()));
            }
        }
        return result;
    }

    public static void insertObjects(List<String> leafPath, DefaultMutableTreeNode tree) {
        if (leafPath == null || leafPath.isEmpty()) {
            return;
        }
        block0: for (String path : leafPath) {
            String[] nodes = path.split(SELECTOR);
            if (!tree.getUserObject().toString().equals(nodes[0]) || nodes.length <= 1) continue;
            DefaultMutableTreeNode cNode = tree;
            for (int depth = 1; depth < nodes.length; ++depth) {
                boolean found = false;
                for (int i = 0; i < cNode.getChildCount(); ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)cNode.getChildAt(i);
                    if (!child.getUserObject().toString().equals(nodes[depth])) continue;
                    cNode = child;
                    found = true;
                    break;
                }
                if (found) continue;
                cNode.add(new DefaultMutableTreeNode(ModuleController.getInstance().createElement(MDEHelper.getType(nodes[depth]), cNode)));
                continue block0;
            }
        }
    }

    public static void deleteObjects(List<String> nodeNames, DefaultMutableTreeNode tree) {
        if (nodeNames == null || nodeNames.isEmpty()) {
            return;
        }
        for (String path : nodeNames) {
            DefaultMutableTreeNode node = MDEHelper.getNodeByPath(tree, path, false);
            if (node == null) continue;
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            parent.remove(node);
        }
    }

    public static List<TagData> mergeTagDataList(List<TagData> l1, List<TagData> l2) {
        if (l1 == null && l2 == null) {
            return null;
        }
        if (l1 == null) {
            return MDEHelper.cloneTagList(l2);
        }
        if (l2 == null) {
            return MDEHelper.cloneTagList(l1);
        }
        ArrayList<TagData> res = new ArrayList();
        res = MDEHelper.cloneTagList(l2);
        for (TagData t1 : l1) {
            boolean found = false;
            for (TagData t2 : l2) {
                if (!t1.getTagName().equals(t2.getTagName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            res.add(new TagData(t1));
        }
        return res;
    }

    public static List<TagData> cloneTagList(List<TagData> l) {
        ArrayList<TagData> res = new ArrayList<TagData>();
        for (TagData t : l) {
            res.add(new TagData(t));
        }
        return res;
    }

    public static List<String> getTypes(DefaultMutableTreeNode tree) {
        ArrayList<String> typeList = new ArrayList<String>();
        Enumeration<TreeNode> e = tree.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            String type = ((ModuleTreeElement)node.getUserObject()).getType();
            if (typeList.contains(type) || !ModuleController.getInstance().configurationExists(type)) continue;
            typeList.add(type);
        }
        return typeList;
    }
}

