/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.MDEHelper;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.ImportUserData;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.MapAnnotationObject;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.NodeContainer;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;

public class FNode
extends DefaultMutableTreeNode {
    private ImportUserData importData;
    private ImportableFile iFile;
    private HashMap<String, List<TagData>> input;
    private NodeContainer container;

    public FNode(File file) {
        this.importData = null;
        this.iFile = null;
        this.setUserObject(file);
    }

    public FNode(Object object) {
        this.importData = null;
        this.iFile = null;
        this.setUserObject(object);
    }

    public FNode(File file, ImportUserData importData, ImportableFile iFile) {
        this.importData = importData;
        this.iFile = iFile;
        this.setUserObject(file);
    }

    public File getFile() {
        Object o = this.getUserObject();
        if (o instanceof File) {
            return (File)o;
        }
        return null;
    }

    public ImportableFile getImportableFile() {
        return this.iFile;
    }

    @Override
    public String toString() {
        Object ad = "";
        if (this.importData != null) {
            ad = " [Group: " + this.importData.getGroup() + ", Project: " + this.importData.getProject() + "]";
        }
        if (this.getFile() == null) {
            return (String)this.getUserObject();
        }
        return this.getFile().getName() + (String)ad;
    }

    public String getAbsolutePath() {
        if (this.getFile() == null) {
            return null;
        }
        return this.getFile().getAbsolutePath();
    }

    @Override
    public boolean getAllowsChildren() {
        if (this.getFile() == null) {
            return true;
        }
        return this.getFile().isDirectory();
    }

    public boolean hasImportData() {
        return this.importData != null;
    }

    public ImportUserData getImportData() {
        return this.importData;
    }

    public void setAnnotation(HashMap<String, List<TagData>> input) {
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] save input as mapannotation");
        if (input == null || input.isEmpty()) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] merge map annotation: No");
            return;
        }
        if (this.input == null) {
            this.input = new HashMap();
        }
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] merge map annotation: Yes");
        for (Map.Entry<String, List<TagData>> entry : input.entrySet()) {
            List<TagData> list1 = entry.getValue();
            List<TagData> list2 = this.input.get(entry.getKey());
            this.input.put(entry.getKey(), MDEHelper.mergeTagDataList(list2, list1));
        }
    }

    public MapAnnotationObject getMapAnnotation() {
        if (this.input != null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] return saved mapped annotation");
            return new MapAnnotationObject(this.input);
        }
        if (this.getContainer() != null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] read out map annotation from contentTree");
            HashMap<String, List<TagData>> input = MDEHelper.getInput(this.getContainer().getTreeNode());
            MapAnnotationObject map = new MapAnnotationObject(input);
            return map;
        }
        return null;
    }

    public void setContainer(NodeContainer cont) {
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] Replace Container");
        this.container = cont;
    }

    public void reset() {
        this.container = null;
        this.input = null;
    }

    public NodeContainer getContainer() {
        return this.container;
    }

    public HashMap<String, List<TagData>> getInput() {
        return this.input;
    }
}

