/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.actions.ColorModelAction;
import org.openmicroscopy.shoola.agents.metadata.actions.ContrastStretchingAction;
import org.openmicroscopy.shoola.agents.metadata.actions.HistogramAction;
import org.openmicroscopy.shoola.agents.metadata.actions.ManageRndSettingsAction;
import org.openmicroscopy.shoola.agents.metadata.actions.NoiseReductionAction;
import org.openmicroscopy.shoola.agents.metadata.actions.PlaneSlicingAction;
import org.openmicroscopy.shoola.agents.metadata.actions.ReverseIntensityAction;
import org.openmicroscopy.shoola.agents.metadata.actions.RndAction;
import org.openmicroscopy.shoola.agents.metadata.actions.ViewAction;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererUI;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerFactory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourObject;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPickerUtil;

class RendererControl
implements PropertyChangeListener {
    static final Integer BIT_RESOLUTION = 0;
    static final Integer FAMILY = 1;
    static final Integer COEFFICIENT = 2;
    static final Integer NOISE_REDUCTION = 3;
    static final Integer REVERSE_INTENSITY = 4;
    static final Integer PLANE_SLICING = 5;
    static final Integer CONTRAST_STRETCHING = 6;
    static final Integer HISTOGRAM = 7;
    static final Integer COLOR_MODEL = 8;
    static final Integer RND_MIN_MAX = 9;
    static final Integer RND_RESET = 10;
    static final Integer RND_UNDO = 11;
    static final Integer RND_OWNER = 12;
    static final Integer VIEW = 13;
    static final Integer APPLY_TO_ALL = 14;
    static final Integer RND_ABSOLUTE_MIN_MAX = 15;
    static final Integer SAVE = 16;
    static final Integer RND_REDO = 17;
    static final Integer COPY = 18;
    static final Integer PASTE = 19;
    private Renderer model;
    private RendererUI view;
    private Map<Integer, RndAction> actionsMap = new HashMap<Integer, RndAction>();
    private int colorPickerIndex;
    private ColourPicker colorPicker;

    private void createActions() {
        this.actionsMap.put(REVERSE_INTENSITY, new ReverseIntensityAction(this.model));
        this.actionsMap.put(PLANE_SLICING, new PlaneSlicingAction(this.model));
        this.actionsMap.put(CONTRAST_STRETCHING, new ContrastStretchingAction(this.model));
        this.actionsMap.put(NOISE_REDUCTION, new NoiseReductionAction(this.model));
        this.actionsMap.put(HISTOGRAM, new HistogramAction(this.model));
        this.actionsMap.put(COLOR_MODEL, new ColorModelAction(this.model));
        this.actionsMap.put(VIEW, new ViewAction(this.model));
        this.actionsMap.put(RND_MIN_MAX, new ManageRndSettingsAction(this.model, 0));
        this.actionsMap.put(RND_RESET, new ManageRndSettingsAction(this.model, 1));
        this.actionsMap.put(APPLY_TO_ALL, new ManageRndSettingsAction(this.model, 3));
        this.actionsMap.put(RND_ABSOLUTE_MIN_MAX, new ManageRndSettingsAction(this.model, 5));
        this.actionsMap.put(SAVE, new ManageRndSettingsAction(this.model, 6));
        ManageRndSettingsAction a = new ManageRndSettingsAction(this.model, 2);
        a.setEnabled(false);
        this.actionsMap.put(RND_UNDO, a);
        a = new ManageRndSettingsAction(this.model, 7);
        a.setEnabled(false);
        this.actionsMap.put(RND_REDO, a);
        a = new ManageRndSettingsAction(this.model, 8);
        this.actionsMap.put(COPY, a);
        a = new ManageRndSettingsAction(this.model, 9);
        a.setEnabled(false);
        this.actionsMap.put(PASTE, a);
    }

    private void attachListeners() {
        this.model.addPropertyChangeListener(this);
    }

    void showColorPicker(int channel) {
        this.showColorPicker(channel, null);
    }

    void showColorPicker(int channel, Point location) {
        this.colorPickerIndex = channel;
        Color c = this.view.getChannelColor(channel);
        String lut = this.view.getLookupTable(channel);
        Collection<String> luts = this.view.getAvailableLookupTables();
        boolean revInt = this.view.getReverseIntensity(channel);
        MetadataViewerAgent.getAvailableUserGroups();
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        if (this.colorPicker == null) {
            this.colorPicker = new ColourPicker(f, c, luts, lut, revInt);
            this.colorPicker.setPreviewVisible(true);
            this.colorPicker.addPropertyChangeListener(this);
        } else {
            this.colorPicker.reinit(c, null, lut, revInt);
        }
        if (!this.colorPicker.isShowing()) {
            if (location == null) {
                UIUtilities.centerAndShow(this.colorPicker);
            } else {
                UIUtilities.showOnScreen(this.colorPicker, location);
            }
        }
    }

    RendererControl() {
    }

    void initialize(Renderer model, RendererUI view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.model = model;
        this.view = view;
        this.createActions();
        this.attachListeners();
    }

    Action getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void addPropertyListener(PropertyChangeListener observer) {
        this.model.addPropertyChangeListener(observer);
    }

    void setInputInterval(double s, double e) {
        this.model.setInputInterval(s, e);
    }

    void setInputInterval(double s, double e, int channel) {
        this.model.setChannelWindow(channel, s, e);
    }

    boolean isIntegerPixelData() {
        return this.model.isIntegerPixelData();
    }

    void setCodomainInterval(int s, int e) {
        this.model.setCodomainInterval(s, e);
    }

    void setSelectedXYPlane(int z, int t) {
        this.setSelectedXYPlane(z, t, -1);
    }

    void setSelectedXYPlane(int z, int t, int bin) {
        this.model.setSelectedXYPlane(z, t, bin);
    }

    void setChannelSelection(int index, boolean active) {
        this.model.setChannelSelection(index, active);
    }

    void setChannelFamily(int channel, String family) {
        this.model.setFamily(channel, family);
        this.view.onCurveChange();
    }

    void setCurveCoefficient(int channel, double k) {
        this.model.setCurveCoefficient(channel, k);
        this.view.onCurveChange();
    }

    void updatePasteAction() {
        boolean enabled = MetadataViewerFactory.hasRndSettingsCopied(this.model.getRefImage().getId());
        this.actionsMap.get(PASTE).setEnabled(enabled);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean value;
        String name = evt.getPropertyName();
        if ("canRedo".equals(name)) {
            value = (Boolean)evt.getNewValue();
            this.actionsMap.get(RND_REDO).setEnabled(value);
        }
        if ("canUndo".equals(name)) {
            value = (Boolean)evt.getNewValue();
            this.actionsMap.get(RND_UNDO).setEnabled(value);
        }
        if ("bit_resolution".equals(name)) {
            Integer oldValue = (Integer)evt.getOldValue();
            Integer newValue = (Integer)evt.getNewValue();
            if (newValue.equals(oldValue)) {
                return;
            }
            this.model.setBitResolution(newValue);
        }
        if ("channelSelected".equals(name)) {
            Map map = (Map)evt.getNewValue();
            if (map == null) {
                return;
            }
            if (map.size() != 1) {
                return;
            }
            Map.Entry entry = map.entrySet().iterator().next();
            Integer index = (Integer)entry.getKey();
            this.setChannelSelection(index, (Boolean)entry.getValue());
        } else if ("channelColour".equals(name)) {
            this.showColorPicker((Integer)evt.getNewValue());
        } else if ("inputInterval".equals(name)) {
            this.view.setInputInterval();
        } else if ("rangeInput".equals(name)) {
            Boolean b = (Boolean)evt.getNewValue();
            this.view.setInputRange(b);
        } else if ("colour".equals(name)) {
            if (this.colorPickerIndex != -1) {
                ColourObject co = (ColourObject)evt.getNewValue();
                ColourObject old = (ColourObject)evt.getOldValue();
                this.handleColorPicker(false, co.preview, this.colorPickerIndex, co.color, old != null ? old.color : null, co.lut, old != null ? old.lut : null, co.revInt);
            }
        } else if ("cancelColourPicker".equals(name)) {
            if (this.colorPickerIndex != -1) {
                this.handleColorPicker(true, false, this.colorPickerIndex, null, null, null, null, false);
            }
            this.colorPicker.dispose();
            this.colorPicker = null;
        } else if ("closeColourPicker".equals(name)) {
            this.colorPicker.dispose();
            this.colorPicker = null;
        } else if ("zSelected".equals(name)) {
            this.view.setZSection((Integer)evt.getNewValue());
        } else if ("tSelected".equals(name)) {
            this.view.setTimepoint((Integer)evt.getNewValue());
        }
        if ("saveSettings".equals(name)) {
            this.actionsMap.get(SAVE).setEnabled(false);
        } else {
            boolean settingsModified;
            this.actionsMap.get(SAVE).setEnabled((settingsModified = this.model.isModified()) && this.model.canAnnotate());
        }
        boolean pasteEnabled = MetadataViewerFactory.hasRndSettingsCopied(this.model.getRefImage().getId());
        this.actionsMap.get(PASTE).setEnabled(pasteEnabled);
    }

    private void handleColorPicker(boolean reset, boolean preview, int index, Color newColor, Color oldColor, String newLut, String oldLut, boolean revInt) {
        if (reset) {
            this.model.resetLookupTable(index);
            this.model.setChannelColor(index, null, true);
        } else {
            if (!ColourPickerUtil.sameLookuptable(newLut, oldLut)) {
                this.model.setLookupTable(index, newLut, preview);
            }
            if (newColor != null && !ColourPickerUtil.sameColor(newColor, oldColor)) {
                this.model.setChannelColor(index, newColor, preview);
            }
            this.model.setReverseIntensity(index, revInt, preview);
        }
    }
}

