/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MoveToAction
extends TreeViewerAction {
    public static final String NAME = "Move to Group";
    public static final String DESCRIPTION = "Select the group where to move the data.";
    private GroupData group;

    private void setPermissions() {
        IconManager im = IconManager.getInstance();
        ImageIcon icon = im.getIcon(112);
        String desc = "";
        switch (this.group.getPermissions().getPermissionsLevel()) {
            case 0: {
                desc = "Private Group";
                icon = im.getIcon(130);
                break;
            }
            case 1: {
                desc = "Collaborators can only read your data.";
                icon = im.getIcon(131);
                break;
            }
            case 2: {
                desc = "Collaborators can read and annotate your data.";
                icon = im.getIcon(132);
                break;
            }
            case 3: {
                desc = "Collaborators can read, annotate, delete, etc., your data.";
                icon = im.getIcon(164);
                break;
            }
            case 4: {
                desc = "Public";
                icon = im.getIcon(133);
                break;
            }
            case 5: {
                desc = "Public";
                icon = im.getIcon(133);
            }
        }
        this.putValue("SmallIcon", icon);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(desc));
    }

    public MoveToAction(TreeViewer model, GroupData group) {
        super(model);
        if (group == null) {
            throw new IllegalArgumentException("No group.");
        }
        this.group = group;
        this.name = group.getName() + "...";
        this.putValue("Name", this.name);
        this.setPermissions();
        this.setEnabled(TreeViewerAgent.canCreate());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        this.model.moveTo(this.group, browser.getSelectedDataObjects());
    }
}

