/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.config;

import com.google.common.collect.MapMaker;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import omero.gateway.Gateway;
import omero.log.Logger;
import org.openmicroscopy.shoola.env.config.Entry;
import org.openmicroscopy.shoola.env.config.ObjectEntry;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.views.DataServicesView;
import org.openmicroscopy.shoola.env.data.views.DataViewsFactory;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.UserNotifier;

class RegistryImpl
implements Registry {
    private final Map<String, Object> entriesMap = new MapMaker().makeMap();
    private EventBus eb;
    private Logger logger;
    private TaskBar tb;
    private UserNotifier un;
    private OmeroImageService is;
    private OmeroMetadataService ms;
    private OmeroDataService os;
    private AdminService admin;
    private Gateway gateway;
    private Set<String> cmdLineArgs = new HashSet<String>();

    RegistryImpl() {
    }

    @Override
    public void bind(String name, Object value) {
        if (name != null) {
            ObjectEntry entry = new ObjectEntry(name);
            entry.setContent(value);
            this.entriesMap.put(name, entry);
        }
    }

    @Override
    public Object lookup(String name) {
        Entry entry = (Entry)this.entriesMap.get(name);
        Object ret = null;
        if (entry != null) {
            ret = entry.getValue();
        }
        return ret;
    }

    @Override
    public EventBus getEventBus() {
        return this.eb;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public TaskBar getTaskBar() {
        return this.tb;
    }

    @Override
    public UserNotifier getUserNotifier() {
        return this.un;
    }

    @Override
    public OmeroImageService getImageService() {
        return this.is;
    }

    @Override
    public OmeroDataService getDataService() {
        return this.os;
    }

    @Override
    public OmeroMetadataService getMetadataService() {
        return this.ms;
    }

    @Override
    public AdminService getAdminService() {
        return this.admin;
    }

    @Override
    public DataServicesView getDataServicesView(Class<?> view) {
        return DataViewsFactory.makeView(view);
    }

    void addEntry(Entry e) {
        this.entriesMap.put(e.getName(), e);
    }

    void setEventBus(EventBus eb) {
        this.eb = eb;
    }

    void setImageService(OmeroImageService is) {
        this.is = is;
    }

    void setMetadataService(OmeroMetadataService ms) {
        this.ms = ms;
    }

    void setAdminService(AdminService admin) {
        this.admin = admin;
    }

    void setTaskBar(TaskBar tb) {
        this.tb = tb;
    }

    void setLogger(Logger logger) {
        this.logger = logger;
    }

    void setUserNotifier(UserNotifier un) {
        this.un = un;
    }

    void setOS(OmeroDataService os) {
        this.os = os;
    }

    @Override
    public Gateway getGateway() {
        return this.gateway;
    }

    void setGateway(Gateway gateway) {
        this.gateway = gateway;
    }

    @Override
    public Collection<String> getCmdLineArgs() {
        return this.cmdLineArgs;
    }

    @Override
    public void addCmdLineArgs(Collection<String> args) {
        this.cmdLineArgs.addAll(args);
    }
}

