/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.chooser;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import loci.formats.gui.ComboFileFilter;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.GroupData;
import omero.gateway.model.MapAnnotationData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.apache.commons.collections4.CollectionUtils;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.fsimporter.IconManager;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.actions.ImporterAction;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.FileSelectionTable;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ImportLocationSettings;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.LocationDialog;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.QuotaCanvas;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.SkipComputePanel;
import org.openmicroscopy.shoola.agents.fsimporter.util.ObjectToCreate;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImportLocationDetails;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.agents.util.SelectionWizard;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.DiskQuota;
import org.openmicroscopy.shoola.env.data.model.FileObject;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.env.data.model.ImportableObject;
import org.openmicroscopy.shoola.util.ui.ClosableTabbedPaneComponent;
import org.openmicroscopy.shoola.util.ui.NotificationDialog;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.GenericFileChooser;

public class ImportDialog
extends ClosableTabbedPaneComponent
implements ActionListener,
PropertyChangeListener {
    public static final String PROPERTY_GROUP_CHANGED = "groupChanged";
    public static final String CREATE_OBJECT_PROPERTY = "createObject";
    public static final String LOAD_TAGS_PROPERTY = "loadTags";
    public static final String CANCEL_SELECTION_PROPERTY = "cancelSelection";
    public static final String IMPORT_PROPERTY = "import";
    public static final String START_IMPORT_PROPERTY = "startImport";
    public static final String REFRESH_LOCATION_PROPERTY = "refreshLocation";
    public static final String REFRESH_FILE_LIST = "refreshMetaList";
    public static final String ADD_AND_REFRESH_FILE_LIST = "addAndRefreshMetaList";
    public static final String ADD_MAP_ANNOTATION = "addMapAnnotation";
    public static final String SHOW_METADATA_DIALOG = "showMetaDataEditor";
    public static final String REFRESH_TITLE = "refreshDialogTitle";
    private static final int CMD_IMPORT = 1;
    private static final int CMD_CLOSE = 2;
    private static final int CMD_RESET = 3;
    private static final int CMD_APPLY_TO_ALL = 4;
    private static final int CMD_TAG = 5;
    private static final int CMD_REFRESH_FILES = 6;
    private static final int CMD_MDE = 7;
    private static final String TEXT_NAMING_PARTIAL_PATH = "Partial Path+File's name with";
    private static final String TEXT_NAMING_FULL_PATH = "Full Path+File's name";
    private static final String TITLE = "Select Data to Import";
    private static final String TEXT_IMPORT = "Import";
    private static final String TEXT_MDE = " MDE >>";
    private static final String TOOLTIP_IMPORT = "Import the selected files or directories";
    private static final String TEXT_FILE_NAMING = "File Naming & Tags";
    private static final String TEXT_SKIP_COMPUTE_TITLE = "Import Speedup";
    private static final String TEXT_SKIP_COMPUTE = "Shorten the import by skipping...";
    private static final String TEXT_METADATA_DEFAULTS = "Metadata Defaults";
    private static final String TEXT_DIRECTORIES_BEFORE_FILE = "Directories before File";
    private static final String TEXT_FREE_SPACE = "Free Space ";
    private static final String TEXT_SAVE = "Save";
    private static final String TEXT_TAGS_DETAILS = "Select the Tags to add or remove, \nor Create new Tags";
    private static final String TEXT_TAGS_SELECTION = "Tags Selection";
    private static final String TOOLTIP_ADD_TAGS = "Add tags.";
    private static final String TEXT_OVERRIDE_FILE_NAMING = "Override default File naming. Instead use";
    private static final String TEXT_CLOSE = "Close";
    private static final String TOOLTIP_CLOSE = "Close the dialog and do not import.";
    private static final String TEXT_SHOW_THUMBNAILS = "Show Thumbnails when imported";
    private static final String TOOLTIP_REMAINING_FORMAT = "%s%% of Remaining Space";
    private static final String LOAD_THUMBNAIL = "/options/LoadThumbnail";
    private static final String TOOLTIP_REFRESH_FILES = "Refresh the file chooser list.";
    private static final String TEXT_REFRESH_FILES = "Refresh";
    private static final String TITLE_FILE_LIMIT_EXCEEDED = "File limit exceeded";
    private static final String FILE_LIMIT_WILDCARD = "@@FILE_LIMIT@@";
    private static final String TEXT_FILE_LIMIT_EXCEEDED = "The import is limited to @@FILE_LIMIT@@ files at once.\n\nFor importing a large number of files you may\nconsider using the command line tools.";
    private static final List<String> WARNING = new ArrayList<String>();
    private static final int COLUMN_WIDTH = 200;
    private int option;
    private FileSelectionTable table;
    private GenericFileChooser chooser;
    private JButton closeButton;
    private JButton cancelImportButton;
    private JButton importButton;
    private JButton showMDEButton;
    private JButton mdeImportButton;
    private JButton mdeCancelImportButton;
    private JButton refreshFilesButton;
    private JRadioButton partialName;
    private JRadioButton fullName;
    private JCheckBox overrideName;
    private NumericalTextField numberOfFolders;
    private JButton tagButton;
    private List<JTextField> pixelsSize;
    private JPanel tagsPane;
    private Map<JButton, TagAnnotationData> tagsMap;
    private Map<String, List<MapAnnotationData>> mapAnnotation;
    private ActionListener tagSelectionListener;
    private TreeImageDisplay selectedContainer;
    private Collection<TreeImageDisplay> objects = new HashSet<TreeImageDisplay>();
    private JTabbedPane tabbedPane;
    private int type;
    private JCheckBox showThumbnails;
    private List<FileFilter> bioFormatsFileFilters;
    private FileFilter bioFormatsFileFiltersCombined;
    private JPanel diskSpacePane;
    private QuotaCanvas canvas;
    private JLabel sizeImportLabel;
    private JFrame owner;
    private SkipComputePanel skipComputePanel;
    private boolean refreshLocation;
    private boolean reload;
    private LocationDialog locationDialog;
    private LocationDialog detachedDialog;
    private FileFilter currentFilter;
    private Importer model;

    private void addFiles(ImportLocationSettings importSettings) {
        File[] files = this.chooser.getSelectedFiles();
        if (files == null || files.length == 0) {
            return;
        }
        ArrayList<FileObject> fileList = new ArrayList<FileObject>();
        ArrayList<File> errors = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            this.checkFile(files[i], fileList, errors);
        }
        if (errors.size() > 0) {
            NotificationDialog dialog = new NotificationDialog(this.owner, TEXT_IMPORT, this.getMessage(errors), true);
            dialog.pack();
            UIUtilities.centerAndShow(dialog);
        }
        this.chooser.setSelectedFile(new File("."));
        this.table.addFiles(fileList, importSettings);
        this.enablesButtons(this.table.hasFilesToImport());
    }

    private String getMessage(List<File> errors) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html><body>");
        Iterator<File> i = errors.iterator();
        buffer.append("<p>The following files cannot be imported due to invalid characters in the path.<br>");
        while (i.hasNext()) {
            buffer.append(i.next().getAbsolutePath());
        }
        buffer.append("</body><html>");
        return buffer.toString();
    }

    private void showLocationDialog() {
        if (this.locationDialog.centerLocation() == 5) {
            this.addFiles(this.locationDialog.getImportSettings());
        }
    }

    private int countFiles(File file) {
        if (file.isDirectory()) {
            int count = 0;
            for (File child : file.listFiles()) {
                count += this.countFiles(child);
            }
            return count;
        }
        return 1;
    }

    private void handleEnterKeyPressed(Object source) {
        JComponent c;
        if ((source instanceof JList || source instanceof JTable) && (c = (JComponent)source).isFocusOwner()) {
            this.showLocationDialog();
        }
    }

    private void handleTagsSelection(Collection<TagAnnotationData> tags) {
        Collection<TagAnnotationData> set = this.tagsMap.values();
        HashMap<String, TagAnnotationData> newTags = new HashMap<String, TagAnnotationData>();
        for (TagAnnotationData tag : set) {
            if (tag.getId() >= 0L) continue;
            newTags.put(tag.getTagValue(), tag);
        }
        ArrayList<TagAnnotationData> toKeep = new ArrayList<TagAnnotationData>();
        for (TagAnnotationData tag : tags) {
            if (tag.getId() < 0L) {
                if (newTags.containsKey(tag.getTagValue())) continue;
                toKeep.add(tag);
                continue;
            }
            toKeep.add(tag);
        }
        toKeep.addAll(newTags.values());
        this.tagsMap.clear();
        this.tagsPane.removeAll();
        Iterator<TagAnnotationData> i = toKeep.iterator();
        IconManager icons = IconManager.getInstance();
        JPanel p = this.initRow();
        int width = 0;
        while (i.hasNext()) {
            TagAnnotationData tag;
            tag = i.next();
            JPanel entry = this.buildTagEntryPanel(tag, icons.getIcon(6));
            if (width + entry.getPreferredSize().width >= 200) {
                this.tagsPane.add(p);
                p = this.initRow();
                width = 0;
            } else {
                width += entry.getPreferredSize().width;
                width += 2;
            }
            p.add(entry);
        }
        if (p.getComponentCount() > 0) {
            this.tagsPane.add(p);
        }
        this.tagsPane.validate();
        this.tagsPane.repaint();
    }

    private JPanel initRow() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        return p;
    }

    private JPanel buildTagEntryPanel(TagAnnotationData tag, Icon icon) {
        JButton tagButton = new JButton(icon);
        UIUtilities.unifiedButtonLookAndFeel(tagButton);
        tagButton.addActionListener(this.tagSelectionListener);
        this.tagsMap.put(tagButton, tag);
        JPanel tagPanel = new JPanel();
        JLabel tagLabel = new JLabel(tag.getTagValue());
        tagPanel.setLayout(new FlowLayout(0, 0, 0));
        tagPanel.add(tagLabel);
        tagPanel.add(tagButton);
        return tagPanel;
    }

    private void showSelectionWizard(Class<TagAnnotationData> type, Collection<Object> available, Collection<Object> selected, boolean addCreation) {
        IconManager icons = IconManager.getInstance();
        Registry reg = ImporterAgent.getRegistry();
        String title = "";
        String text = "";
        ImageIcon icon = null;
        if (TagAnnotationData.class.equals(type)) {
            title = TEXT_TAGS_SELECTION;
            text = TEXT_TAGS_DETAILS;
            icon = icons.getIcon(5);
        }
        SelectionWizard wizard = new SelectionWizard(reg.getTaskBar().getFrame(), available, selected, type, addCreation, ImporterAgent.getUserDetails());
        wizard.setAcceptButtonText(TEXT_SAVE);
        wizard.setTitle(title, text, icon);
        wizard.addPropertyChangeListener(this);
        UIUtilities.centerAndShow(wizard);
    }

    /*
     * WARNING - void declaration
     */
    private void initComponents(FileFilter[] filters, ImporterAction importerAction) {
        Object f2;
        JTable t;
        this.canvas = new QuotaCanvas();
        this.sizeImportLabel = new JLabel();
        this.diskSpacePane = new JPanel();
        this.diskSpacePane.setLayout(new FlowLayout(0, 5, 0));
        this.diskSpacePane.add(UIUtilities.setTextFont(TEXT_FREE_SPACE));
        this.diskSpacePane.add(this.canvas);
        this.showThumbnails = new JCheckBox(TEXT_SHOW_THUMBNAILS);
        this.showThumbnails.setVisible(false);
        Registry registry = ImporterAgent.getRegistry();
        Boolean loadThumbnails = (Boolean)registry.lookup(LOAD_THUMBNAIL);
        if (loadThumbnails != null && loadThumbnails.booleanValue()) {
            this.showThumbnails.setVisible(true);
            this.showThumbnails.setSelected(loadThumbnails);
        }
        if (!this.isFastConnection()) {
            this.showThumbnails.setSelected(false);
        }
        long groupId = -1L;
        if (this.model.getSelectedGroup() != null) {
            groupId = this.model.getSelectedGroup().getGroupId();
        }
        if (groupId < 0L) {
            groupId = ImporterAgent.getUserDetails().getGroupId();
        }
        this.locationDialog = new LocationDialog(this.owner, this.selectedContainer, this.type, this.objects, this.model, groupId, true);
        this.locationDialog.addPropertyChangeListener(this);
        this.addPropertyChangeListener(this.locationDialog);
        int plugin = ImporterAgent.runAsPlugin();
        if (plugin == 3 || plugin == 1) {
            this.detachedDialog = new LocationDialog(this.owner, this.selectedContainer, this.type, this.objects, this.model, groupId, false);
            this.detachedDialog.addPropertyChangeListener(this);
        }
        this.tagSelectionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagAnnotationData tag;
                Object src = e.getSource();
                if (src instanceof JButton && (tag = ImportDialog.this.tagsMap.get(src)) != null) {
                    ImportDialog.this.tagsMap.remove(src);
                    ImportDialog.this.handleTagsSelection(ImportDialog.this.tagsMap.values());
                }
            }
        };
        this.tabbedPane = new JTabbedPane();
        this.numberOfFolders = new NumericalTextField();
        this.numberOfFolders.setMinimum(0.0);
        this.numberOfFolders.setText("0");
        this.numberOfFolders.setColumns(3);
        this.numberOfFolders.addPropertyChangeListener(this);
        this.tagsMap = new LinkedHashMap<JButton, TagAnnotationData>();
        this.mapAnnotation = new LinkedHashMap<String, List<MapAnnotationData>>();
        IconManager icons = IconManager.getInstance();
        this.refreshFilesButton = new JButton(TEXT_REFRESH_FILES);
        this.refreshFilesButton.setBackground(UIUtilities.BACKGROUND);
        this.refreshFilesButton.setToolTipText(TOOLTIP_REFRESH_FILES);
        this.refreshFilesButton.setActionCommand("6");
        this.refreshFilesButton.addActionListener(this);
        this.tagButton = new JButton(icons.getIcon(3));
        UIUtilities.unifiedButtonLookAndFeel(this.tagButton);
        this.tagButton.addActionListener(this);
        this.tagButton.setActionCommand("5");
        this.tagButton.setToolTipText(TOOLTIP_ADD_TAGS);
        this.tagsPane = new JPanel();
        this.tagsPane.setLayout(new BoxLayout(this.tagsPane, 1));
        this.overrideName = new JCheckBox(TEXT_OVERRIDE_FILE_NAMING);
        this.overrideName.setToolTipText(UIUtilities.formatToolTipText(WARNING));
        this.overrideName.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        this.fullName = new JRadioButton(TEXT_NAMING_FULL_PATH);
        group.add(this.fullName);
        this.partialName = new JRadioButton();
        this.partialName.setText(TEXT_NAMING_PARTIAL_PATH);
        this.partialName.setSelected(true);
        group.add(this.partialName);
        this.table = new FileSelectionTable(this);
        this.table.addPropertyChangeListener(this);
        this.chooser = new GenericFileChooser();
        JList list = (JList)UIUtilities.findComponent(this.chooser, JList.class);
        KeyAdapter ka = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ImportDialog.this.handleEnterKeyPressed(e.getSource());
                }
            }
        };
        if (list != null) {
            list.addKeyListener(ka);
        }
        if (list == null && (t = (JTable)UIUtilities.findComponent(this.chooser, JTable.class)) != null) {
            t.addKeyListener(ka);
        }
        try {
            f2 = UIUtilities.getDefaultFolder();
            if (f2 != null) {
                this.chooser.setCurrentDirectory((File)f2);
            }
        }
        catch (Exception f2) {
            // empty catch block
        }
        this.chooser.addPropertyChangeListener(this);
        this.chooser.setMultiSelectionEnabled(true);
        this.chooser.setFileSelectionMode(2);
        this.chooser.setControlButtonsAreShown(false);
        this.chooser.setApproveButtonText(TEXT_IMPORT);
        this.chooser.setApproveButtonToolTipText(TOOLTIP_IMPORT);
        this.bioFormatsFileFilters = new ArrayList<FileFilter>();
        if (filters != null) {
            void var14_17;
            this.chooser.setAcceptAllFileFilterUsed(false);
            f2 = filters;
            int n = ((FileFilter[])f2).length;
            boolean bl = false;
            while (var14_17 < n) {
                FileFilter fileFilter = f2[var14_17];
                if (fileFilter instanceof ComboFileFilter) {
                    FileFilter[] extensionFilters;
                    this.bioFormatsFileFiltersCombined = fileFilter;
                    ComboFileFilter comboFilter = (ComboFileFilter)fileFilter;
                    for (FileFilter combinedFilter : extensionFilters = comboFilter.getFilters()) {
                        this.bioFormatsFileFilters.add(combinedFilter);
                    }
                    break;
                }
                ++var14_17;
            }
            this.chooser.addChoosableFileFilter(this.bioFormatsFileFiltersCombined);
            for (FileFilter fileFilter : this.bioFormatsFileFilters) {
                this.chooser.addChoosableFileFilter(fileFilter);
            }
            this.chooser.setFileFilter(this.bioFormatsFileFiltersCombined);
        } else {
            this.chooser.setAcceptAllFileFilterUsed(true);
        }
        this.closeButton = new JButton(TEXT_CLOSE);
        this.closeButton.setToolTipText(TOOLTIP_CLOSE);
        this.closeButton.setActionCommand("2");
        this.closeButton.addActionListener(this);
        this.cancelImportButton = new JButton(importerAction);
        importerAction.setEnabled(false);
        this.mdeCancelImportButton = new JButton(importerAction);
        this.importButton = new JButton(TEXT_IMPORT);
        this.importButton.setToolTipText(TOOLTIP_IMPORT);
        this.importButton.setActionCommand("1");
        this.importButton.addActionListener(this);
        this.importButton.setEnabled(false);
        this.mdeImportButton = new JButton(TEXT_IMPORT);
        this.mdeImportButton.setToolTipText(TOOLTIP_IMPORT);
        this.mdeImportButton.setActionCommand("1");
        this.mdeImportButton.addActionListener(this);
        this.mdeImportButton.setEnabled(false);
        this.showMDEButton = new JButton(TEXT_MDE);
        this.showMDEButton.setActionCommand("7");
        this.showMDEButton.addActionListener(this);
        this.showMDEButton.setEnabled(false);
        this.pixelsSize = new ArrayList<JTextField>();
        for (int i = 0; i < 3; ++i) {
            JTextField field = new JTextField();
            field.setColumns(2);
            field.setToolTipText("Pixel size in micrometer, must be > 0");
            field.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent jComponent) {
                    String input = ((JTextField)jComponent).getText();
                    if (input == null || input.trim().length() == 0) {
                        return true;
                    }
                    try {
                        double value = Double.parseDouble(input);
                        return value > 0.0;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }

                @Override
                public boolean shouldYieldFocus(JComponent input) {
                    if (!super.shouldYieldFocus(input)) {
                        ((JTextField)input).setText("");
                    }
                    return true;
                }
            });
            this.pixelsSize.add(field);
        }
        List<Component> boxes = UIUtilities.findComponents(this.chooser, JComboBox.class);
        if (boxes != null) {
            Component filterBox = null;
            for (JComboBox jComboBox : boxes) {
                Object o = jComboBox.getItemAt(0);
                if (!(o instanceof FileFilter)) continue;
                filterBox = jComboBox;
                break;
            }
            if (filterBox != null) {
                filterBox.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        String value = KeyEvent.getKeyText(e.getKeyCode());
                        JComboBox box = (JComboBox)e.getSource();
                        int n = box.getItemCount();
                        FileFilter selectedFilter = null;
                        for (int j = 0; j < n; ++j) {
                            FileFilter filter = (FileFilter)box.getItemAt(j);
                            String d = filter.getDescription();
                            if (!d.startsWith(value)) continue;
                            selectedFilter = filter;
                            break;
                        }
                        if (selectedFilter != null) {
                            box.setSelectedItem(selectedFilter);
                        }
                    }
                });
            }
        }
    }

    private JPanel buildToolBarRight() {
        JPanel bar = new JPanel(new FlowLayout(2));
        bar.add(this.cancelImportButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.importButton);
        bar.add(Box.createHorizontalStrut(10));
        if (ImporterAgent.isMDEImport()) {
            bar.add(this.showMDEButton);
            bar.add(Box.createHorizontalStrut(10));
        }
        return bar;
    }

    private JPanel buildToolBarLeft() {
        JPanel bar = new JPanel(new FlowLayout(0));
        bar.add(this.closeButton);
        int plugin = ImporterAgent.runAsPlugin();
        if (plugin != 3 && plugin != 1) {
            bar.add(Box.createHorizontalStrut(5));
            bar.add(this.refreshFilesButton);
        }
        return bar;
    }

    private JPanel buildPathComponent() {
        JLabel directoriesLabel = new JLabel(TEXT_DIRECTORIES_BEFORE_FILE);
        JPanel pathPanel = new JPanel();
        pathPanel.setLayout(new FlowLayout(0));
        pathPanel.add(this.numberOfFolders);
        pathPanel.add(directoriesLabel);
        return pathPanel;
    }

    private JXTaskPane buildPane(String title, JComponent view) {
        JXTaskPane pane = new JXTaskPane();
        Font font = pane.getFont();
        pane.setFont(font.deriveFont(font.getStyle(), font.getSize() - 2));
        pane.setCollapsed(true);
        pane.setTitle(title);
        pane.add((Component)view);
        return pane;
    }

    private JPanel buildPixelSizeComponent() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createTitledBorder("Pixels Size Defaults"));
        JLabel l = new JLabel();
        l.setText("Used if no values included in the file:");
        p.add(UIUtilities.buildComponentPanel(l));
        JPanel row = new JPanel();
        row.setLayout(new FlowLayout(0));
        l = new JLabel();
        l.setText("X: ");
        row.add(l);
        row.add(this.pixelsSize.get(0));
        l = new JLabel();
        l.setText("Y: ");
        row.add(l);
        row.add(this.pixelsSize.get(1));
        l = new JLabel();
        l.setText("Z: ");
        row.add(l);
        row.add(this.pixelsSize.get(2));
        p.add(row);
        return UIUtilities.buildComponentPanel(p);
    }

    private JComponent buildNamingComponent() {
        JPanel content = new JPanel();
        content.setBorder(BorderFactory.createTitledBorder("File Naming"));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.fullName);
        panel.add(this.partialName);
        JPanel pp = new JPanel();
        pp.setLayout(new BoxLayout(pp, 1));
        pp.add(UIUtilities.buildComponentPanel(panel));
        pp.add(this.buildPathComponent());
        GridBagConstraints c = new GridBagConstraints();
        content.setLayout(new GridBagLayout());
        c.fill = 2;
        c.weightx = 0.0;
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 0;
        content.add((Component)this.overrideName, c);
        c.gridwidth = 1;
        ++c.gridy;
        content.add(Box.createHorizontalStrut(15), c);
        ++c.gridx;
        content.add((Component)pp, c);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(content);
        p.add(this.buildAnnotationComponent());
        return UIUtilities.buildComponentPanel(p);
    }

    private JComponent buildSkipFlagsComponent() {
        this.skipComputePanel = new SkipComputePanel();
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)new JLabel(TEXT_SKIP_COMPUTE), "North");
        content.add((Component)this.skipComputePanel, "Center");
        return UIUtilities.buildComponentPanel(content);
    }

    private JPanel buildAnnotationComponent() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JLabel l = new JLabel();
        l.setText("Add tag to images");
        JPanel tagPanel = new JPanel(new FlowLayout(0));
        tagPanel.add(l);
        tagPanel.add(this.tagButton);
        l = new JLabel();
        l.setText(": ");
        tagPanel.add(l);
        tagPanel.add(this.tagsPane);
        p.add(tagPanel);
        return UIUtilities.buildComponentPanel(p);
    }

    private JComponent buildOptionsPane() {
        JPanel options = new JPanel();
        options.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        options.add((Component)this.buildPane(TEXT_FILE_NAMING, this.buildNamingComponent()), c);
        c.gridx = 0;
        c.gridy = 1;
        options.add((Component)this.buildPane(TEXT_SKIP_COMPUTE_TITLE, this.buildSkipFlagsComponent()), c);
        c.gridx = 0;
        c.gridy = 2;
        options.add((Component)this.buildPane(TEXT_METADATA_DEFAULTS, this.buildPixelSizeComponent()), c);
        c.gridx = 0;
        c.gridy = 3;
        c.weighty = 1.0;
        options.add((Component)new JLabel(" "), c);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(options);
        return scrollPane;
    }

    private JPanel buildQuotaPane() {
        JPanel row = new JPanel();
        row.setLayout(new FlowLayout(0, 0, 0));
        row.add(UIUtilities.buildComponentPanelRight(this.diskSpacePane, 0, 0, true));
        row.add(UIUtilities.setTextFont("Import size: "));
        row.add(UIUtilities.buildComponentPanel(this.sizeImportLabel, 0, 0, true));
        row.setBorder(null);
        return row;
    }

    private void buildGUI() {
        boolean supportsWindowDecorations;
        JSplitPane pane;
        this.setLayout(new BorderLayout(0, 0));
        JPanel p = new JPanel();
        p.setBorder(null);
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.buildQuotaPane());
        p.add(this.table);
        this.tabbedPane.add("Files to import", p);
        if (!ImporterAgent.isOfflineImport()) {
            this.tabbedPane.add("Options", this.buildOptionsPane());
        }
        double[][] tablePanelDesign = new double[][]{{-2.0, 10.0, 5.0, -1.0}, {-2.0, -1.0}};
        JPanel tablePanel = new JPanel((LayoutManager)new TableLayout((double[][])tablePanelDesign));
        tablePanel.add((Component)this.table.buildControls(), "0, 1, LEFT, CENTER");
        tablePanel.add((Component)this.tabbedPane, "2, 1, 3, 1");
        int plugin = ImporterAgent.runAsPlugin();
        if (plugin == 3 || plugin == 1) {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            JLabel label = UIUtilities.setTextFont("Select where to import the image(s).");
            panel.add(UIUtilities.buildComponentPanel(label));
            panel.add(this.locationDialog.getContentPane());
            pane = new JSplitPane(1, panel, tablePanel);
        } else {
            pane = new JSplitPane(1, this.chooser, tablePanel);
        }
        JPanel mainPanel = new JPanel();
        double[][] mainPanelDesign = new double[][]{{-1.0}, {-2.0, -1.0}};
        mainPanel.setLayout((LayoutManager)new TableLayout((double[][])mainPanelDesign));
        mainPanel.setBackground(UIUtilities.BACKGROUND);
        mainPanel.add((Component)pane, "0, 1");
        this.add((Component)mainPanel, "Center");
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 0));
        bar.add(this.buildToolBarLeft());
        bar.add(this.buildToolBarRight());
        controls.add(new JSeparator());
        controls.add(bar);
        this.add((Component)controls, "South");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.getRootPane().setWindowDecorationStyle(6);
        }
    }

    private boolean isFastConnection() {
        int value = (Integer)ImporterAgent.getRegistry().lookup("/connection/speed");
        return value == 0;
    }

    private int handleFilesSelection(File[] files) {
        return files == null ? 0 : files.length;
    }

    public void importFiles() {
        Integer number;
        List<ImportableFile> files;
        this.option = 1;
        this.importButton.setEnabled(false);
        this.mdeImportButton.setEnabled(false);
        File dir = this.chooser.getCurrentDirectory();
        if (dir != null) {
            UIUtilities.setDefaultFolder(dir.toString());
        }
        if ((files = this.table.getFilesToImport()).size() == 0) {
            return;
        }
        ImportableObject object = new ImportableObject(files, this.overrideName.isSelected());
        Iterator<ImportableFile> i = files.iterator();
        if (!this.reload) {
            while (i.hasNext()) {
                ImportableFile file = i.next();
                if (!file.isFolderAsContainer() && file.isDatasetCreated() || ImportableObject.isHCSFile(file.getFile())) continue;
                this.reload = true;
                break;
            }
        }
        if (ImporterAgent.isMDEImport()) {
            object.setMapAnnotation(this.mapAnnotation);
        }
        object.setScanningDepth(ImporterAgent.getScanningDepth());
        Boolean loadThumbnails = (Boolean)ImporterAgent.getRegistry().lookup(LOAD_THUMBNAIL);
        if (loadThumbnails != null) {
            object.setLoadThumbnail(loadThumbnails);
        }
        if (!this.isFastConnection()) {
            object.setLoadThumbnail(false);
        }
        if (this.showThumbnails.isVisible()) {
            object.setLoadThumbnail(this.showThumbnails.isSelected());
        }
        if (this.tagsMap.size() > 0) {
            Iterator<TagAnnotationData> j = this.tagsMap.values().iterator();
            ArrayList<TagAnnotationData> l = new ArrayList<TagAnnotationData>();
            while (j.hasNext()) {
                l.add(j.next());
            }
            object.setTags(l);
        }
        if (this.partialName.isSelected() && (number = (Integer)this.numberOfFolders.getValueAsNumber()) != null && number >= 0) {
            object.setDepthForName(number);
        }
        Iterator<JTextField> ij = this.pixelsSize.iterator();
        double[] size = new double[3];
        int index = 0;
        int count = 0;
        while (ij.hasNext()) {
            JTextField nf = ij.next();
            try {
                double n = Double.parseDouble(nf.getText());
                size[index] = n > 0.0 ? n : 1.0;
                ++count;
            }
            catch (Exception e) {
                size[index] = 1.0;
            }
            ++index;
        }
        if (count > 0) {
            object.setPixelsSize(size);
        }
        if (!ImporterAgent.isOfflineImport()) {
            object.setSkipChoices(this.skipComputePanel.getChoices());
        }
        this.firePropertyChange(IMPORT_PROPERTY, null, object);
        this.table.removeAllFiles();
        this.tagsMap.clear();
        this.mapAnnotation.clear();
        this.tagsPane.removeAll();
        this.tagsPane.repaint();
    }

    private void checkFile(File f, List<FileObject> l, List<File> errors) {
        File[] list;
        if (f == null) {
            return;
        }
        if (f.isFile()) {
            if (this.isFileImportable(f)) {
                try {
                    f.length();
                    l.add(new FileObject(f));
                }
                catch (InvalidPathException e) {
                    errors.add(f);
                }
            }
        } else if (f.isDirectory() && (list = f.listFiles()) != null && list.length > 0 && this.isFileImportable(f)) {
            try {
                f.length();
                l.add(new FileObject(f));
            }
            catch (InvalidPathException e) {
                errors.add(f);
            }
        }
    }

    private boolean isFileImportable(File f) {
        return f != null;
    }

    private TreeImageDisplay checkContainer(TreeImageDisplay container) {
        if (container == null) {
            return null;
        }
        Object ho = container.getUserObject();
        if (ho instanceof DatasetData || ho instanceof ProjectData || ho instanceof ScreenData) {
            return container;
        }
        return null;
    }

    public ImportDialog(JFrame owner, FileFilter[] filters, TreeImageDisplay selectedContainer, Collection<TreeImageDisplay> objects, int type, ImporterAction importerAction, Importer model) {
        super(0, TITLE, TITLE);
        this.owner = owner;
        if (objects != null) {
            this.objects.addAll(objects);
        }
        this.type = type;
        this.model = model;
        this.selectedContainer = this.checkContainer(selectedContainer);
        this.setClosable(false);
        this.setCloseVisible(false);
        this.initComponents(filters, importerAction);
        this.buildGUI();
    }

    public int getType() {
        return this.type;
    }

    boolean isSingleGroup() {
        return ImporterAgent.getAvailableUserGroups().size() <= 1;
    }

    boolean canImportAs() {
        return this.model.canImportAs();
    }

    void onSelectionChanged() {
        if (this.canvas == null) {
            return;
        }
        long size = this.table.getSizeFilesInQueue();
        this.canvas.setSizeInQueue(size);
        int remaining = (int)Math.round(this.canvas.getPercentageToImport() * 100.0);
        String tooltip = String.format(TOOLTIP_REMAINING_FORMAT, remaining);
        this.sizeImportLabel.setText(UIUtilities.formatFileSize(size));
        this.sizeImportLabel.setToolTipText(tooltip);
    }

    String getDisplayedFileName(String fullPath) {
        if (fullPath == null || !this.partialName.isSelected()) {
            return fullPath;
        }
        Integer number = (Integer)this.numberOfFolders.getValueAsNumber();
        return UIUtilities.getDisplayedFileName(fullPath, number);
    }

    boolean useFolderAsContainer() {
        return this.type != 1;
    }

    public boolean isRefreshLocation() {
        return this.refreshLocation;
    }

    public void reset(Collection<TreeImageDisplay> objects, int type, long currentGroupId, long userID) {
        TreeImageDisplay selected = null;
        if (this.selectedContainer != null && objects != null) {
            Iterator<TreeImageDisplay> i = objects.iterator();
            Object ho = this.selectedContainer.getUserObject();
            long id = -1L;
            if (ho instanceof DataObject) {
                id = ((DataObject)ho).getId();
            }
            block0: while (i.hasNext()) {
                TreeImageDisplay node = i.next();
                Object nho = node.getUserObject();
                if (nho.getClass().equals(ho.getClass()) && nho instanceof DataObject && ((DataObject)nho).getId() == id) {
                    selected = node;
                    break;
                }
                List l = node.getChildrenDisplay();
                for (TreeImageDisplay child : l) {
                    Object cho = child.getUserObject();
                    if (!cho.getClass().equals(ho.getClass()) || !(cho instanceof DataObject) || ((DataObject)cho).getId() != id) continue;
                    selected = child;
                    continue block0;
                }
            }
        }
        this.reset(selected, objects, type, currentGroupId, userID);
    }

    public void reset(TreeImageDisplay selectedContainer, Collection<TreeImageDisplay> objects, int type, long currentGroupId, long userID) {
        this.canvas.setVisible(true);
        this.selectedContainer = this.checkContainer(selectedContainer);
        this.objects.clear();
        if (objects != null) {
            this.objects.addAll(objects);
        }
        this.type = type;
        File[] files = this.chooser.getSelectedFiles();
        this.table.allowAddition(files != null && files.length > 0);
        this.handleTagsSelection(new ArrayList<TagAnnotationData>());
        this.tabbedPane.setSelectedIndex(0);
        FileFilter[] filters = this.chooser.getChoosableFileFilters();
        if (filters != null && filters.length > 0) {
            if (this.currentFilter == null) {
                this.currentFilter = filters[0];
            }
            this.chooser.setFileFilter(this.currentFilter);
        }
        this.locationDialog.reset(this.selectedContainer, this.type, this.objects, currentGroupId, userID);
        if (this.detachedDialog != null) {
            this.detachedDialog.reset(this.selectedContainer, this.type, this.objects, currentGroupId, userID);
        }
        this.tagsPane.removeAll();
        this.tagsMap.clear();
    }

    public int showDialog() {
        UIUtilities.setLocationRelativeToAndShow(this.getParent(), this);
        return this.option;
    }

    public int centerDialog() {
        UIUtilities.centerAndShow(this);
        return this.option;
    }

    public void setTags(Collection<TagAnnotationData> tags) {
        if (tags == null) {
            return;
        }
        Collection<TagAnnotationData> set = this.tagsMap.values();
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<Object> available = new ArrayList<Object>();
        ArrayList<Object> selected = new ArrayList<Object>();
        for (TagAnnotationData tag : set) {
            if (tag.getId() <= 0L) continue;
            ids.add(tag.getId());
        }
        for (TagAnnotationData tag : tags) {
            if (ids.contains(tag.getId())) {
                selected.add(tag);
                continue;
            }
            available.add(tag);
        }
        this.showSelectionWizard(TagAnnotationData.class, available, selected, true);
    }

    public void setDiskSpace(DiskQuota quota) {
        if (quota == null) {
            return;
        }
        long free = quota.getAvailableSpace();
        long used = quota.getUsedSpace();
        if (free <= 0L || used < 0L) {
            return;
        }
        this.canvas.setPercentage(quota);
        this.canvas.setVisible(true);
    }

    public void onDataObjectSaved(DataObject d, DataObject parent) {
        if (d instanceof ProjectData) {
            this.locationDialog.createProject(d);
            if (this.detachedDialog != null) {
                this.detachedDialog.createProject(d);
            }
        } else if (d instanceof ScreenData) {
            this.locationDialog.createScreen(d);
            if (this.detachedDialog != null) {
                this.detachedDialog.createScreen(d);
            }
        } else if (d instanceof DatasetData) {
            this.locationDialog.createDataset((DatasetData)d);
            if (this.detachedDialog != null) {
                this.detachedDialog.createDataset((DatasetData)d);
            }
        }
    }

    public boolean reloadHierarchies() {
        return this.reload;
    }

    public void setSelectedGroup(GroupData group) {
        this.locationDialog.setSelectedGroup(group);
        if (this.detachedDialog != null) {
            this.detachedDialog.setSelectedGroup(group);
        }
    }

    public void addImageJFiles(List<FileObject> list, ImportLocationSettings settings) {
        int plugin = ImporterAgent.runAsPlugin();
        if (plugin != 3 && plugin != 1) {
            return;
        }
        if (CollectionUtils.isEmpty(list)) {
            boolean active = this.locationDialog.isActiveWindow();
            list = new ArrayList<FileObject>();
            if (active) {
                ImagePlus p = WindowManager.getCurrentImage();
                if (p == null) {
                    IJ.log((String)"Please open an image first.");
                    return;
                }
                FileObject f = new FileObject(p);
                int[] values = WindowManager.getIDList();
                String path = f.getAbsolutePath();
                if (path != null && values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        FileObject ff;
                        p = WindowManager.getImage((int)values[i]);
                        if (p == null || !path.equals((ff = new FileObject(p)).getAbsolutePath())) continue;
                        f.addAssociatedFile(ff);
                    }
                }
                list.add(f);
            } else {
                ArrayList<String> paths = new ArrayList<String>();
                int[] values = WindowManager.getIDList();
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        FileObject f;
                        String path;
                        ImagePlus p = WindowManager.getImage((int)values[i]);
                        if (p == null || paths.contains(path = (f = new FileObject(p)).getAbsolutePath())) continue;
                        paths.add(path);
                        list.add(f);
                        for (int j = 0; j < values.length; ++j) {
                            p = WindowManager.getImage((int)values[j]);
                            FileObject ff = new FileObject(p);
                            if (!path.equals(ff.getAbsolutePath())) continue;
                            f.addAssociatedFile(ff);
                        }
                    }
                }
            }
        }
        if (CollectionUtils.isEmpty(list)) {
            ImporterAgent.getRegistry().getUserNotifier().notifyInfo("Image Selection", "No images opened.");
            return;
        }
        if (settings == null) {
            settings = this.locationDialog.getImportSettings();
        }
        this.table.addFiles(list, settings);
        this.enablesButtons(this.table.hasFilesToImport());
    }

    public ImportLocationSettings createLocationDialog() {
        if (this.detachedDialog == null) {
            return null;
        }
        if (this.detachedDialog.centerLocation() == 5) {
            return this.detachedDialog.getImportSettings();
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src;
        String name = evt.getPropertyName();
        if ("add".equals(name)) {
            this.showLocationDialog();
            this.firePropertyChange(REFRESH_FILE_LIST, null, this.table.getFilesToImport());
        } else if ("remove".equals(name)) {
            int n = this.handleFilesSelection(this.chooser.getSelectedFiles());
            this.table.allowAddition(n > 0);
            this.enablesButtons(this.table.hasFilesToImport());
            this.firePropertyChange(REFRESH_FILE_LIST, null, this.table.getFilesToImport());
        } else if ("SelectedFilesChangedProperty".equals(name)) {
            int n = this.handleFilesSelection(this.chooser.getSelectedFiles());
            this.table.allowAddition(n > 0);
        } else if ("textUpdated".equals(name)) {
            Integer number;
            if (this.partialName.isSelected() && (number = (Integer)this.numberOfFolders.getValueAsNumber()) != null && number >= 0) {
                this.table.applyToAll();
            }
        } else if ("selectedItems".equals(name)) {
            Map m = (Map)evt.getNewValue();
            if (m == null || m.size() != 1) {
                return;
            }
            Set set = m.entrySet();
            for (Map.Entry entry : set) {
                Class type = (Class)entry.getKey();
                if (!TagAnnotationData.class.getName().equals(type.getName())) continue;
                this.handleTagsSelection((Collection)entry.getValue());
            }
        } else if (PROPERTY_GROUP_CHANGED.equals(name) || REFRESH_LOCATION_PROPERTY.equals(name)) {
            this.firePropertyChange(name, evt.getOldValue(), evt.getNewValue());
        } else if (CREATE_OBJECT_PROPERTY.equals(name)) {
            ObjectToCreate o = (ObjectToCreate)evt.getNewValue();
            this.onDataObjectSaved(o.getChild(), null);
        } else if ("addToQueue".equals(name) && (src = evt.getSource()) != this.detachedDialog) {
            this.addImageJFiles(null, null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int commandId = Integer.parseInt(evt.getActionCommand());
        switch (commandId) {
            case 1: {
                this.firePropertyChange(START_IMPORT_PROPERTY, (Object)false, (Object)true);
                break;
            }
            case 2: {
                this.firePropertyChange(CANCEL_SELECTION_PROPERTY, (Object)false, (Object)true);
                break;
            }
            case 3: {
                this.partialName.setSelected(false);
                this.table.resetFilesName();
                break;
            }
            case 4: {
                this.table.applyToAll();
                break;
            }
            case 5: {
                this.firePropertyChange(LOAD_TAGS_PROPERTY, (Object)false, (Object)true);
                break;
            }
            case 6: {
                this.refreshLocation = false;
                this.currentFilter = this.chooser.getFileFilter();
                this.chooser.rescanCurrentDirectory();
                this.chooser.repaint();
                ImportLocationDetails details = new ImportLocationDetails(this.getType());
                this.firePropertyChange(REFRESH_LOCATION_PROPERTY, null, details);
                break;
            }
            case 7: {
                this.firePropertyChange(SHOW_METADATA_DIALOG, false, true);
            }
        }
    }

    public FileFilter getFileFilter() {
        return this.chooser != null ? this.chooser.getFileFilter() : null;
    }

    public void setMapAnnotation(String fileName, List<MapAnnotationData> map) {
        this.mapAnnotation.put(fileName, map);
    }

    public void deleteMapAnnotations() {
        this.mapAnnotation.clear();
    }

    public JButton getImportButton() {
        return this.mdeImportButton;
    }

    public JButton getCancelImportButton() {
        return this.mdeCancelImportButton;
    }

    private void enablesButtons(boolean enable) {
        this.importButton.setEnabled(enable && ImporterAgent.canCreate());
        this.mdeImportButton.setEnabled(enable && ImporterAgent.canCreate());
        this.showMDEButton.setEnabled(enable);
    }

    @Override
    public boolean isClosable() {
        return false;
    }

    static {
        WARNING.add("NOTE: Some file formats do not include the file name in their metadata, ");
        WARNING.add("and disabling this option may result in files being imported without a ");
        WARNING.add("reference to their file name e.g. myfile.lsm [image001]'");
        WARNING.add("would show up as 'image001' with this optioned turned off.");
    }
}

