/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.view;

import ij.ImagePlus;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ROIData;
import omero.gateway.model.ScreenData;
import omero.log.LogMessage;
import omero.model.Image;
import omero.model.ImageI;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.openmicroscopy.shoola.agents.fsimporter.AnnotationDataLoader;
import org.openmicroscopy.shoola.agents.fsimporter.DataLoader;
import org.openmicroscopy.shoola.agents.fsimporter.DataObjectCreator;
import org.openmicroscopy.shoola.agents.fsimporter.DiskSpaceLoader;
import org.openmicroscopy.shoola.agents.fsimporter.ImagesImporter;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.MeasurementsSaver;
import org.openmicroscopy.shoola.agents.fsimporter.ROISaver;
import org.openmicroscopy.shoola.agents.fsimporter.TagsLoader;
import org.openmicroscopy.shoola.agents.fsimporter.util.FileImportComponentI;
import org.openmicroscopy.shoola.agents.fsimporter.util.ObjectToCreate;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.env.data.model.FileObject;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.env.data.model.ImportableObject;
import org.openmicroscopy.shoola.env.data.model.ResultsObject;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.roi.io.ROIReader;

class ImporterModel {
    private int state;
    protected Importer component;
    private Collection tags;
    private Map<Integer, ImagesImporter> loaders;
    private long groupId;
    private long experimenterId;
    private SecurityContext ctx;
    private boolean master;
    private int displayMode;
    private long userId;
    private DataLoader containerLoader;
    private ResultsObject object;

    private void initialize() {
        this.groupId = -1L;
        this.experimenterId = -1L;
        this.userId = -1L;
        this.state = 1;
        this.loaders = new HashMap<Integer, ImagesImporter>();
        this.checkDefaultDisplayMode();
    }

    private void checkDefaultDisplayMode() {
        Integer value = (Integer)ImporterAgent.getRegistry().lookup("DataDisplay");
        if (value == null) {
            this.setDisplayMode(1);
        } else {
            this.setDisplayMode(value);
        }
    }

    private boolean canRetrieveAll() {
        GroupData group = this.getGroup(this.getGroupId());
        if (group == null) {
            return false;
        }
        if (1 == group.getPermissions().getPermissionsLevel()) {
            if (ImporterAgent.isAdministrator()) {
                return true;
            }
            Set<ExperimenterData> leaders = group.getLeaders();
            Iterator<ExperimenterData> i = leaders.iterator();
            long userID = this.getExperimenterId();
            while (i.hasNext()) {
                ExperimenterData exp = i.next();
                if (exp.getId() != userID) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private GroupData getGroup(long groupId) {
        Collection groups = ImporterAgent.getAvailableUserGroups();
        if (groups == null) {
            return null;
        }
        for (GroupData group : groups) {
            if (group.getId() != groupId) continue;
            return group;
        }
        return null;
    }

    ImporterModel(long groupId, int displayMode) {
        this(groupId, false, displayMode);
    }

    ImporterModel(long groupId, boolean master, int displayMode) {
        this.master = master;
        this.initialize();
        this.setGroupId(groupId);
        this.setDisplayMode(displayMode);
    }

    void setGroupId(long groupId) {
        this.groupId = groupId;
        ExperimenterData exp = ImporterAgent.getUserDetails();
        if (groupId < 0L) {
            this.groupId = exp.getDefaultGroup().getGroupId();
        }
        this.ctx = new SecurityContext(this.groupId);
        this.experimenterId = exp.getId();
        this.tags = null;
    }

    long getGroupId() {
        return this.groupId;
    }

    long getExperimenterId() {
        return this.experimenterId;
    }

    boolean isMaster() {
        return this.master;
    }

    void initialize(Importer component) {
        this.component = component;
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    void discard() {
        if (this.loaders.size() > 0) {
            Iterator<ImagesImporter> i = this.loaders.values().iterator();
            while (i.hasNext()) {
                i.next().cancel();
            }
            this.loaders.clear();
        }
        this.state = 3;
    }

    void cancel(int loaderID) {
        ImagesImporter loader = this.loaders.get(loaderID);
        if (loader != null) {
            this.loaders.remove(loaderID);
        }
    }

    FileFilter[] getSupportedFormats() {
        return ImporterAgent.getRegistry().getImageService().getSupportedFileFormats();
    }

    void fireImportData(ImportableObject data, int loaderID) {
        if (data == null) {
            return;
        }
        ImagesImporter loader = new ImagesImporter(this.component, data, loaderID);
        this.loaders.put(loaderID, loader);
        loader.load();
        this.state = 4;
    }

    void importCompleted(int loaderID) {
        this.state = 2;
        ImagesImporter loader = this.loaders.get(loaderID);
        if (loader != null) {
            ImportableObject io = loader.getImportableObject();
            try {
                ImporterAgent.getRegistry().getImageService().closeImport(io);
            }
            catch (Exception e) {
                LogMessage msg = new LogMessage();
                msg.print("Import closure");
                msg.print((Throwable)e);
                ImporterAgent.getRegistry().getLogger().warn((Object)this, msg);
            }
        }
    }

    Collection getTags() {
        return this.tags;
    }

    void setTags(Collection tags) {
        this.tags = tags;
    }

    void fireTagsLoading() {
        if (this.tags != null) {
            return;
        }
        TagsLoader loader = new TagsLoader(this.component, this.ctx, this.canRetrieveAll());
        loader.load();
    }

    void fireDiskSpaceLoading() {
        DiskSpaceLoader loader = new DiskSpaceLoader(this.component, this.ctx);
        loader.load();
    }

    void fireContainerLoading(Class rootType, boolean refreshImport, boolean changeGroup, ExperimenterData user) {
        if (!ProjectData.class.equals((Object)rootType) && !ScreenData.class.equals((Object)rootType)) {
            return;
        }
        if (this.containerLoader != null && this.state == 5) {
            this.containerLoader.cancel();
        }
        this.state = 5;
        this.containerLoader = new DataLoader(this.component, this.ctx, rootType, refreshImport, changeGroup);
        this.containerLoader.load();
    }

    void fireImportLogFileLoading(long fileSetID, int index) {
        AnnotationDataLoader loader = new AnnotationDataLoader(this.component, this.ctx, fileSetID, index);
        loader.load();
    }

    void fireDataCreation(ObjectToCreate data) {
        SecurityContext ctx = new SecurityContext(data.getGroup().getId());
        ctx.setServerInformation(this.ctx.getServerInformation());
        ctx.setExperimenter(data.getExperimenter());
        DataObjectCreator loader = new DataObjectCreator(this.component, ctx, data.getChild(), data.getParent());
        loader.load();
    }

    boolean isSingleGroup() {
        Collection l = ImporterAgent.getAvailableUserGroups();
        return l.size() <= 1;
    }

    int getDisplayMode() {
        return this.displayMode;
    }

    void setDisplayMode(int value) {
        if (value < 0) {
            this.checkDefaultDisplayMode();
            return;
        }
        switch (value) {
            case 0: 
            case 1: {
                this.displayMode = value;
                break;
            }
            default: {
                this.displayMode = 1;
            }
        }
        if (this.tags != null) {
            this.tags.clear();
            this.tags = null;
        }
    }

    SecurityContext getSecurityContext() {
        return this.ctx;
    }

    void fireImportResultLoading(Collection<DataObject> pixels, Class<?> type, Object component, ExperimenterData user) {
        long currentUser;
        if (user != null && (currentUser = ImporterAgent.getUserDetails().getId()) != user.getId()) {
            this.ctx.setExperimenter(user);
            this.ctx.sudo();
        }
    }

    boolean requestThumbnails(Object component) {
        if (component instanceof FileImportComponentI) {
            ImportableFile impf = ((FileImportComponentI)component).getImportableFile();
            for (ImagesImporter imp : this.loaders.values()) {
                ImportableObject io = imp.getImportableObject();
                for (ImportableFile f : io.getFiles()) {
                    if (!impf.toString().equals(f.toString()) || !io.skipThumbnails()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    long getImportFor() {
        if (!this.canImportAs() || this.userId < 0L) {
            return this.experimenterId;
        }
        return this.userId;
    }

    void setImportFor(long userId) {
        if (this.canImportAs()) {
            this.userId = userId;
        }
    }

    boolean canImportAs() {
        if (ImporterAgent.isImportAs()) {
            return true;
        }
        return CollectionUtils.isNotEmpty(this.getGroupsLeaderOf());
    }

    boolean isSystemGroup(long id, String key) {
        return ImporterAgent.getRegistry().getAdminService().isSecuritySystemGroup(id, key);
    }

    Set<GroupData> getGroupsLeaderOf() {
        HashSet<GroupData> values = new HashSet<GroupData>();
        Collection<GroupData> groups = this.getAvailableGroups();
        Iterator<GroupData> i = groups.iterator();
        ExperimenterData exp2 = ImporterAgent.getUserDetails();
        long id = exp2.getId();
        while (i.hasNext()) {
            GroupData g = i.next();
            Set<ExperimenterData> leaders = g.getLeaders();
            if (!CollectionUtils.isNotEmpty(leaders)) continue;
            for (ExperimenterData exp2 : leaders) {
                if (exp2.getId() != id) continue;
                values.add(g);
            }
        }
        return values;
    }

    Collection<GroupData> getAvailableGroups() {
        return ImporterAgent.getAvailableUserGroups();
    }

    void saveROI(FileImportComponentI c, List<ImageData> images) {
        FileObject object = c.getOriginalFile();
        if (object.isImagePlus() && CollectionUtils.isNotEmpty(images)) {
            List<ROIData> rois;
            int index;
            ROIReader reader = new ROIReader();
            SecurityContext ctx = new SecurityContext(c.getGroupID());
            ImagePlus img = (ImagePlus)object.getFile();
            List<FileObject> files = object.getAssociatedFiles();
            HashMap<Integer, List<ROIData>> indexes = new HashMap<Integer, List<ROIData>>();
            boolean mif = false;
            if (CollectionUtils.isNotEmpty(files)) {
                mif = true;
                for (FileObject o : files) {
                    if (!o.isImagePlus()) continue;
                    index = o.getIndex();
                    rois = reader.readImageJROI(-1L, (ImagePlus)o.getFile());
                    indexes.put(index, rois);
                    if (index >= 0) continue;
                    mif = false;
                }
            }
            for (ImageData data : images) {
                File f;
                long id = data.getId();
                index = data.getSeries();
                rois = null;
                if (indexes.containsKey(index)) {
                    rois = (List<ROIData>)indexes.get(index);
                    this.linkRoisToImage(id, rois);
                } else if (!mif) {
                    rois = reader.readImageJROI(id, img);
                }
                if (CollectionUtils.isEmpty(rois)) {
                    rois = reader.readImageJROI(id);
                }
                if (CollectionUtils.isNotEmpty(rois)) {
                    ROISaver saver = new ROISaver(this.component, ctx, rois, id, c.getExperimenterID(), c);
                    saver.load();
                }
                if ((f = this.createFile(data.getName())) == null) continue;
                MeasurementsSaver ms = new MeasurementsSaver(this.component, ctx, new FileAnnotationData(f), data, c.getExperimenterID());
                ms.load();
            }
        }
    }

    private File createFile(String imageName) {
        try {
            Object name;
            String prefix = "ome_";
            File dir = Files.createTempDirectory("ome_", new FileAttribute[0]).toFile();
            String fileName = null;
            if (this.object != null) {
                fileName = this.object.getTableName();
            }
            if (CommonsLangUtils.isBlank(fileName)) {
                name = "ImageJ-" + FilenameUtils.getBaseName((String)FilenameUtils.removeExtension((String)imageName)) + "-Results-";
                name = (String)name + new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            } else {
                name = FilenameUtils.removeExtension((String)fileName);
            }
            name = (String)name + ".csv";
            File f = new File(dir, (String)name);
            ROIReader reader = new ROIReader();
            if (!reader.readResults(f)) {
                f.delete();
                dir.delete();
                return null;
            }
            dir.deleteOnExit();
            return f;
        }
        catch (Exception e) {
            ImporterAgent.getRegistry().getLogger().error((Object)this, "Cannot create file to save results" + e.getMessage());
            return null;
        }
    }

    private void linkRoisToImage(long imageID, List<ROIData> rois) {
        if (CollectionUtils.isEmpty(rois)) {
            return;
        }
        Iterator<ROIData> i = rois.iterator();
        while (i.hasNext()) {
            i.next().setImage((Image)new ImageI(imageID, false));
        }
    }

    void setResultsObject(ResultsObject object) {
        this.object = object;
    }
}

