/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.events.iviewer.SaveRelatedData;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.actions.ActivateRecentAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ActivationAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerComponent;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerModel;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerRecentObject;
import org.openmicroscopy.shoola.agents.imviewer.view.ViewerPreferences;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.util.CommonsLangUtils;

public class ImViewerFactory
implements ChangeListener,
PropertyChangeListener {
    private static final String OMERO_VIEWER_COMPRESSION = "omeroViewerCompression";
    private static final String OMERO_INTERPOLATION = "omeroViewerInterpolation";
    private static final String MENU_NAME = "Image Viewer";
    private static final String RECENT_MENU = "Open Recent";
    private static final String CLEAR_MENU = "Clear menu";
    private static final int MAX_RECENT = 10;
    private static final ImViewerFactory singleton = new ImViewerFactory();
    private Set<ImViewer> viewers = new HashSet<ImViewer>();
    private List<ImViewerRecentObject> recentViewers = new ArrayList<ImViewerRecentObject>();
    private JMenu windowMenu = new JMenu("Image Viewer");
    private JMenu recentMenu = new JMenu("Open Recent");
    private JMenuItem clearMenu = new JMenuItem("Clear menu");
    private boolean isAttached = false;
    private ImageData refImage;
    private RndProxyDef refRndDef;
    private ViewerPreferences pref;

    static void register(JMenu menu) {
        if (menu == null) {
            return;
        }
        Iterator<ImViewer> i = ImViewerFactory.singleton.viewers.iterator();
        menu.removeAll();
        while (i.hasNext()) {
            menu.add(new JMenuItem(new ActivationAction(i.next())));
        }
        int n = ImViewerFactory.singleton.recentViewers.size();
        if (n > 0) {
            Iterator<ImViewerRecentObject> j = ImViewerFactory.singleton.recentViewers.iterator();
            ImViewerFactory.singleton.recentMenu.removeAll();
            while (j.hasNext()) {
                ImViewerFactory.singleton.recentMenu.add(new JMenuItem(new ActivateRecentAction(j.next())));
            }
            ImViewerFactory.singleton.recentMenu.add(new JSeparator());
            ImViewerFactory.singleton.recentMenu.add(ImViewerFactory.singleton.clearMenu);
            menu.add(ImViewerFactory.singleton.recentMenu);
        }
    }

    static JMenu getWindowMenu() {
        return ImViewerFactory.singleton.windowMenu;
    }

    static void attachWindowMenuToTaskBar() {
        if (ImViewerFactory.singleton.isAttached) {
            return;
        }
        TaskBar tb = ImViewerAgent.getRegistry().getTaskBar();
        tb.addToMenu(0, ImViewerFactory.singleton.windowMenu);
        ImViewerFactory.singleton.isAttached = true;
    }

    public static void onGroupSwitched(boolean success) {
        if (!success) {
            return;
        }
        singleton.clear();
    }

    public static ImViewer getImageViewer(SecurityContext ctx, DataObject image, Rectangle bounds, boolean separateWindow) {
        ImViewerModel model = new ImViewerModel(ctx, image, bounds, separateWindow);
        return singleton.getViewer(model);
    }

    public static ImViewer getImageViewer(SecurityContext ctx, long imageID, Rectangle bounds, boolean separateWindow) {
        ImViewerModel model = new ImViewerModel(ctx, imageID, bounds, separateWindow);
        return singleton.getViewer(model);
    }

    public static ImViewer getImageViewer(SecurityContext ctx, long pixelsID) {
        for (ImViewerComponent imViewerComponent : ImViewerFactory.singleton.viewers) {
            if (!imViewerComponent.getModel().isSame(pixelsID, ctx)) continue;
            return imViewerComponent;
        }
        return null;
    }

    public static ImViewer getImageViewerFromImage(SecurityContext ctx, long imageID) {
        for (ImViewerComponent imViewerComponent : ImViewerFactory.singleton.viewers) {
            if (!imViewerComponent.getModel().isSameImage(imageID, ctx)) continue;
            return imViewerComponent;
        }
        return null;
    }

    public static ImViewer getImageViewerFromParent(DataObject parent) {
        if (parent == null) {
            return null;
        }
        for (ImViewerComponent imViewerComponent : ImViewerFactory.singleton.viewers) {
            if (!imViewerComponent.getModel().isSameParent(parent)) continue;
            return imViewerComponent;
        }
        return null;
    }

    public static void copyRndSettings(ImageData image, RndProxyDef refRndDef) {
        ImViewerFactory.singleton.refImage = image;
        ImViewerFactory.singleton.refRndDef = refRndDef;
        for (ImViewerComponent imViewerComponent : ImViewerFactory.singleton.viewers) {
            if (image == null || imViewerComponent.getModel().getImageID() == image.getId()) continue;
            imViewerComponent.copyRndSettings();
        }
    }

    public static void rndSettingsSaved(long pixelsID, RndProxyDef settings) {
        for (ImViewerComponent imViewerComponent : ImViewerFactory.singleton.viewers) {
            if (imViewerComponent.getModel().getPixelsID() == pixelsID) {
                imViewerComponent.onRndSettingsSaved(settings);
            }
            imViewerComponent.reloadRenderingThumbs();
        }
    }

    public static void rndSettingsChanged(long imageID) {
        for (ImViewerComponent imViewerComponent : ImViewerFactory.singleton.viewers) {
            if (imViewerComponent.getModel().getImageID() != imageID) continue;
            imViewerComponent.onSettingsChanged();
        }
    }

    public static void storeEvent(SaveRelatedData evt) {
        Iterator<ImViewer> v = ImViewerFactory.singleton.viewers.iterator();
        long pixelsID = evt.getPixelsID();
        while (v.hasNext()) {
            ImViewerComponent comp = (ImViewerComponent)v.next();
            if (comp.getModel().getPixelsID() != pixelsID) continue;
            comp.storeEvent(evt);
        }
    }

    public static List<Object> getInstancesToSave() {
        if (ImViewerFactory.singleton.viewers.size() == 0) {
            return null;
        }
        ArrayList<Object> instances = new ArrayList<Object>();
        for (ImViewerComponent imViewerComponent : ImViewerFactory.singleton.viewers) {
            if (!imViewerComponent.hasSettingsToSave()) continue;
            instances.add(imViewerComponent);
        }
        return instances;
    }

    public static void saveInstances(List<Object> instances) {
        if (instances != null) {
            Iterator<Object> i = instances.iterator();
            ArrayList<Long> ids = new ArrayList<Long>();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof ImViewerComponent)) continue;
                ImViewerComponent comp = (ImViewerComponent)o;
                comp.close(false);
                ImViewerFactory.singleton.viewers.remove(comp);
                ids.add(comp.getModel().getImageID());
            }
            ImViewerFactory.removeRecentViewers(ids);
        }
    }

    public static void setDisplayMode(int displayMode) {
        for (ImViewerComponent imViewerComponent : ImViewerFactory.singleton.viewers) {
            imViewerComponent.setDisplayMode(displayMode);
        }
    }

    static ImageData getRefImage() {
        return ImViewerFactory.singleton.refImage;
    }

    static RndProxyDef getRefSettings() {
        return ImViewerFactory.singleton.refRndDef;
    }

    static ViewerPreferences getPreferences() {
        return ImViewerFactory.singleton.pref;
    }

    static void setPreferences(ViewerPreferences pref) {
        ImViewerFactory.singleton.pref = null;
    }

    static void setCompressionLevel(int level) {
        Preferences p = Preferences.userNodeForPackage(ImViewerFactory.class);
        p.put(OMERO_VIEWER_COMPRESSION, "" + level);
    }

    static int getCompressionLevel() {
        Preferences p = Preferences.userNodeForPackage(ImViewerFactory.class);
        String value = p.get(OMERO_VIEWER_COMPRESSION, null);
        if (value != null && value.trim().length() > 0) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    public static void setInterpolation(boolean interpolation) {
        Preferences p = Preferences.userNodeForPackage(ImViewerFactory.class);
        p.put(OMERO_INTERPOLATION, "" + interpolation);
    }

    public static Boolean isInterpolation() {
        Preferences p = Preferences.userNodeForPackage(ImViewerFactory.class);
        String value = p.get(OMERO_INTERPOLATION, null);
        if (CommonsLangUtils.isNotEmpty(value)) {
            return new Boolean(value);
        }
        return null;
    }

    private static void removeRecentViewers(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        Iterator<ImViewerRecentObject> j = ImViewerFactory.singleton.recentViewers.iterator();
        ArrayList<ImViewerRecentObject> toRemove = new ArrayList<ImViewerRecentObject>();
        while (j.hasNext()) {
            ImViewerRecentObject recent = j.next();
            if (!ids.contains(recent.getImageID())) continue;
            toRemove.add(recent);
        }
        ImViewerFactory.singleton.recentViewers.removeAll(toRemove);
    }

    private ImViewerFactory() {
        this.clearMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImViewerFactory.singleton.recentViewers.clear();
            }
        });
    }

    private void clear() {
        for (ImViewerComponent imViewerComponent : this.viewers) {
            imViewerComponent.removeChangeListener(this);
            imViewerComponent.discard();
        }
        ImViewerFactory.singleton.viewers.clear();
        ImViewerFactory.singleton.recentViewers.clear();
        this.handleViewerDiscarded();
    }

    private void handleViewerDiscarded() {
        if (!ImViewerFactory.singleton.isAttached) {
            return;
        }
        if (ImViewerFactory.singleton.viewers.size() != 0) {
            return;
        }
        TaskBar tb = ImViewerAgent.getRegistry().getTaskBar();
        tb.removeFromMenu(0, ImViewerFactory.singleton.windowMenu);
        ImViewerFactory.singleton.isAttached = false;
    }

    private ImViewer getViewer(ImViewerModel model) {
        for (ImViewerComponent imViewerComponent : this.viewers) {
            if (imViewerComponent.getModel().getImageID() != model.getImageID()) continue;
            return imViewerComponent;
        }
        ImViewerComponent imViewerComponent = new ImViewerComponent(model);
        imViewerComponent.initialize();
        imViewerComponent.addChangeListener(this);
        imViewerComponent.addPropertyChangeListener(this);
        this.viewers.add(imViewerComponent);
        long id = model.getImageID();
        if (id < 0L) {
            return null;
        }
        Iterator<ImViewerRecentObject> j = this.recentViewers.iterator();
        ImViewerRecentObject toRemove = null;
        while (j.hasNext()) {
            ImViewerRecentObject obj = j.next();
            if (obj.getImageID() != id) continue;
            toRemove = obj;
        }
        if (toRemove != null) {
            this.recentViewers.remove(toRemove);
        }
        return imViewerComponent;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        ImViewerComponent comp = (ImViewerComponent)ce.getSource();
        switch (comp.getState()) {
            case 7: 
            case 19: {
                this.viewers.remove(comp);
                ImViewerFactory.removeRecentViewers(Arrays.asList(comp.getModel().getImageID()));
                this.handleViewerDiscarded();
                break;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("reventViewer".equals(name)) {
            Iterator<ImViewerRecentObject> i = this.recentViewers.iterator();
            ImViewerRecentObject v = (ImViewerRecentObject)evt.getNewValue();
            ImViewerRecentObject exist = null;
            while (i.hasNext()) {
                ImViewerRecentObject old = i.next();
                if (old.getImageID() != v.getImageID()) continue;
                exist = old;
                break;
            }
            if (exist != null) {
                this.recentViewers.remove(exist);
            }
            if (this.recentViewers.size() >= 10) {
                this.recentViewers.remove(0);
            }
            this.recentViewers.add(v);
            this.handleViewerDiscarded();
        }
    }
}

