/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ome.model.display.ChannelBinding;
import ome.services.scripts.RepoFile;
import ome.services.scripts.ScriptFileType;
import ome.services.scripts.ScriptRepoHelper;
import omeis.providers.re.lut.LutProvider;
import omeis.providers.re.lut.LutReader;
import omeis.providers.re.lut.LutReaderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LutProviderImpl
implements LutProvider {
    private static Logger log = LoggerFactory.getLogger(LutProviderImpl.class);
    protected final Map<String, LutReader> lutReaders = new HashMap<String, LutReader>();

    public LutProviderImpl(ScriptRepoHelper scriptRepoHelper, ScriptFileType lutType) {
        File root = new File(scriptRepoHelper.getScriptDir());
        Iterator scripts = FileUtils.iterateFiles((File)root, (IOFileFilter)lutType.getFileFilter(), (IOFileFilter)TrueFileFilter.TRUE);
        while (scripts.hasNext()) {
            RepoFile script = new RepoFile(root, (File)scripts.next());
            String basename = script.basename();
            try {
                this.lutReaders.put(basename, LutReaderFactory.read((File)script.file()));
                log.debug("Successfully added LUT '{}'", (Object)basename);
            }
            catch (Exception e) {
                log.warn("Cannot read lookup table: '{}'", (Object)script.fullname(), (Object)e);
            }
        }
        log.info("Successfully added {} LUTs", (Object)this.lutReaders.size());
    }

    public List<LutReader> getLutReaders(ChannelBinding[] channelBindings) {
        log.debug("Looking up LUT readers for {} channels from {} LUTs", (Object)channelBindings.length, (Object)this.lutReaders.size());
        ArrayList<LutReader> toReturn = new ArrayList<LutReader>();
        for (ChannelBinding cb : channelBindings) {
            if (!cb.getActive().booleanValue()) continue;
            toReturn.add(this.lutReaders.get(cb.getLookupTable()));
        }
        return toReturn;
    }
}

