/*
 * Decompiled with CFR 0.152.
 */
package ome.services;

import java.sql.Timestamp;
import ome.annotations.RolesAllowed;
import ome.api.ITypes;
import ome.api.JobHandle;
import ome.api.ServiceInterface;
import ome.conditions.ApiUsageException;
import ome.conditions.ValidationException;
import ome.model.IObject;
import ome.model.internal.Details;
import ome.model.jobs.Job;
import ome.model.jobs.JobStatus;
import ome.parameters.Parameters;
import ome.security.SecureAction;
import ome.services.AbstractStatefulBean;
import ome.services.procs.IProcessManager;
import ome.services.procs.Process;
import ome.services.procs.ProcessCallback;
import ome.system.EventContext;
import ome.util.ShallowCopy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class JobBean
extends AbstractStatefulBean
implements JobHandle,
ProcessCallback {
    private static final long serialVersionUID = 49809384038000069L;
    private static transient Logger log = LoggerFactory.getLogger(JobBean.class);
    private Long jobId;
    private Long resetId;
    private transient ITypes iTypes;
    private transient IProcessManager pm;

    public Class<? extends ServiceInterface> getServiceInterface() {
        return JobHandle.class;
    }

    @RolesAllowed(value={"user"})
    @Transactional
    public void passivate() {
    }

    @RolesAllowed(value={"user"})
    @Transactional
    public void activate() {
        if (this.jobId != null) {
            this.resetId = this.jobId;
            this.jobId = null;
        }
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public void close() {
    }

    @Transactional(readOnly=false)
    @RolesAllowed(value={"user"})
    public long submit(Job newJob) {
        JobStatus s;
        this.reset();
        EventContext ec = this.getCurrentEventContext();
        long ms = System.currentTimeMillis();
        Timestamp now = new Timestamp(ms);
        newJob.setUsername(ec.getCurrentUserName());
        newJob.setGroupname(ec.getCurrentGroupName());
        newJob.setType(ec.getCurrentEventType());
        newJob.setStarted(null);
        newJob.setFinished(null);
        newJob.setSubmitted(now);
        Timestamp t = newJob.getScheduledFor();
        if (t == null || t.getTime() < now.getTime()) {
            newJob.setScheduledFor(now);
        }
        if ((s = newJob.getStatus()) == null) {
            newJob.setStatus(new JobStatus("Submitted"));
        } else {
            if (s.getId() != null) {
                try {
                    s = (JobStatus)this.iQuery.get(JobStatus.class, s.getId());
                }
                catch (Exception e) {
                    throw new ApiUsageException("Unknown job status: " + s);
                }
            }
            if (s.getValue() == null) {
                throw new ApiUsageException("JobStatus must have id or value set.");
            }
            if (!s.getValue().equals("Submitted") && !s.getValue().equals("Waiting")) {
                throw new ApiUsageException("Currently only SUBMITTED and WAITING are accepted as JobStatus");
            }
        }
        String m = newJob.getMessage();
        if (m == null) {
            newJob.setMessage("");
        }
        newJob.getDetails().copy(this.sec.newTransientDetails((IObject)newJob));
        newJob = this.secureSave(newJob);
        this.jobId = newJob.getId();
        return this.jobId;
    }

    @RolesAllowed(value={"user"})
    public JobStatus attach(long id) {
        if (this.jobId == null || this.jobId != id) {
            this.reset();
            this.jobId = id;
        }
        this.checkAndRegister();
        return this.getJob().getStatus();
    }

    private void reset() {
        this.resetId = null;
        this.jobId = null;
    }

    public void setTypesService(ITypes typesService) {
        this.getBeanHelper().throwIfAlreadySet(this.iTypes, typesService);
        this.iTypes = typesService;
    }

    public void setProcessManager(IProcessManager procMgr) {
        this.getBeanHelper().throwIfAlreadySet(this.pm, procMgr);
        this.pm = procMgr;
    }

    protected void errorIfInvalidState() {
        if (this.resetId != null) {
            long reset = this.resetId;
            this.attach(reset);
        } else if (this.jobId == null) {
            throw new ApiUsageException("JobHandle not ready: Please submit() or attach() to a Job.");
        }
    }

    protected void checkAndRegister() {
        Process p = this.pm.runningProcess(this.jobId);
        if (p != null && p.isActive()) {
            p.registerCallback(this);
        }
    }

    @RolesAllowed(value={"user"})
    public Job getJob() {
        Job job = this.internalJobOnly();
        JobStatus status = job.getStatus();
        Details unloadedDetails = status.getDetails().shallowCopy();
        status.getDetails().shallowCopy(unloadedDetails);
        Job copy = (Job)new ShallowCopy().copy((IObject)job);
        copy.setStatus(job.getStatus());
        return copy;
    }

    @RolesAllowed(value={"user"})
    public Timestamp jobFinished() {
        return this.getJob().getFinished();
    }

    @RolesAllowed(value={"user"})
    public JobStatus jobStatus() {
        return this.getJob().getStatus();
    }

    @RolesAllowed(value={"user"})
    public String jobMessage() {
        return this.getJob().getMessage();
    }

    @RolesAllowed(value={"user"})
    public boolean jobRunning() {
        return "Running".equals(this.getJob().getStatus().getValue());
    }

    @RolesAllowed(value={"user"})
    public boolean jobError() {
        return "Error".equals(this.getJob().getStatus().getValue());
    }

    @Transactional(readOnly=false)
    @RolesAllowed(value={"user"})
    public void cancelJob() {
        this.setStatus("Cancelled");
    }

    @Transactional(readOnly=false)
    @RolesAllowed(value={"user"})
    public String setStatus(String status) {
        return this.setStatusAndMessage(status, null);
    }

    @Transactional(readOnly=false)
    @RolesAllowed(value={"user"})
    public String setMessage(String message) {
        return this.setStatusAndMessage(null, message);
    }

    @Transactional(readOnly=false)
    @RolesAllowed(value={"user"})
    public String setStatusAndMessage(String status, String message) {
        String rv = null;
        this.errorIfInvalidState();
        Job job = this.internalJobOnly();
        if (message != null) {
            rv = job.getMessage();
            job.setMessage(message);
        }
        if (status != null) {
            JobStatus s = (JobStatus)this.iTypes.getEnumeration(JobStatus.class, status);
            rv = job.getStatus().getValue();
            job.setStatus(s);
            Timestamp t = new Timestamp(System.currentTimeMillis());
            if (status.equals("Running")) {
                job.setStarted(t);
            } else if (status.equals("Cancelled")) {
                job.setFinished(t);
                Process p = this.pm.runningProcess(this.jobId);
                if (p != null) {
                    p.cancel();
                }
            } else if (status.equals("Finished") || status.equals("Error")) {
                job.setFinished(t);
            } else {
                throw new ValidationException("Currently unsupported: " + status);
            }
        }
        this.secureSave(job);
        return rv;
    }

    @Override
    public void processCancelled(Process proc) {
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public void processFinished(Process proc) {
        throw new UnsupportedOperationException("NYI");
    }

    private Job internalJobOnly() {
        this.errorIfInvalidState();
        this.checkAndRegister();
        Job job = (Job)this.iQuery.findByQuery("select j from Job j left outer join fetch j.status status left outer join fetch j.originalFileLinks links left outer join fetch links.child file left outer join fetch j.details.owner owner left outer join fetch owner.groupExperimenterMap map left outer join fetch map.parent where j.id = :id", new Parameters().addId(this.jobId));
        if (job == null) {
            throw new ApiUsageException("Unknown job:" + this.jobId);
        }
        return job;
    }

    private Job secureSave(Job job) {
        job = (Job)this.sec.doAction(new SecureAction(){

            @Override
            public <T extends IObject> T updateObject(T ... objs) {
                IObject result = JobBean.this.iUpdate.saveAndReturnObject((IObject)objs[0]);
                JobBean.this.iUpdate.flush();
                return (T)result;
            }
        }, (IObject[])new Job[]{job});
        return job;
    }
}

