/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter;

import java.util.LinkedHashMap;
import ome.xml.model.Experiment;
import ome.xml.model.Experimenter;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.ExperimentType;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.DataConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.OMEValueConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;

public class ExperimentConverter
extends DataConverter {
    public ExperimentConverter() {
        this.tagMap = new LinkedHashMap();
    }

    public LinkedHashMap<String, TagData> convertData(Experiment exp, Experimenter exper) {
        if (exp != null) {
            try {
                this.tagMap.put("Description", this.convertDescription(exp.getDescription(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Description", this.convertDescription(null, true));
            }
            try {
                this.tagMap.put("ExperimentType", this.convertType(exp.getType(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("ExperimentType", this.convertType(null, true));
            }
            try {
                this.tagMap.put("Experimenter Name", this.convertName(exper, true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Experimenter Name", this.convertName(null, true));
            }
        } else {
            this.tagMap.put("Description", this.convertDescription(null, true));
            this.tagMap.put("ExperimentType", this.convertType(null, true));
            this.tagMap.put("Experimenter Name", this.convertName(null, true));
        }
        return this.tagMap;
    }

    private TagData convertType(ExperimentType value, boolean prop) {
        String val = value != null ? value.getValue() : null;
        return new TagData("Experiment", "ExperimentType", val, prop, "ComboBox", OMEValueConverter.getNames(ExperimentType.class));
    }

    private ExperimentType parseExperimentType(String value) {
        if (value == null || value.equals("")) {
            return null;
        }
        ExperimentType t = null;
        try {
            t = ExperimentType.fromString((String)value);
        }
        catch (EnumerationException e) {
            ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] ExperimentType: " + value + "is not supported");
        }
        return t;
    }

    private TagData convertDescription(String value, boolean prop) {
        return new TagData("Experiment", "Description", value, prop, "TextArea");
    }

    private TagData convertName(Experimenter value, boolean prop) {
        return new TagData("Experiment", "Experimenter Name", this.getExperimenterName(value), prop, "TextField");
    }

    private String getExperimenterName(Experimenter e) {
        Object res = null;
        if (e != null) {
            String fName = e.getFirstName() != null && !e.getFirstName().equals("") ? e.getFirstName() : "";
            String lName = e.getLastName() != null && !e.getLastName().equals("") ? e.getLastName() : "";
            res = fName.equals("") ? lName : fName + " " + lName;
        }
        return res;
    }

    private TagData convertProjectName(String value, boolean prop) {
        return new TagData("Experiment", "Project Name", value, prop, "TextField");
    }

    private TagData convertGroupName(String value, boolean prop) {
        return new TagData("Experiment", "Group", value, prop, "TextField");
    }

    private TagData convertProjectPartner(String value, boolean prop) {
        return new TagData("Experiment", "Project Partner", value, prop, "TextField");
    }
}

