/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class TaggingAction
extends TreeViewerAction {
    private static final String NAME = "Tag...";
    private static final String DESCRIPTION = "Add or remove tags.";

    @Override
    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: 
            case 13: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (!TreeViewerAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof DatasetData || ho instanceof ProjectData || ho instanceof ImageData || ho instanceof ScreenData || ho instanceof PlateData || ho instanceof PlateAcquisitionData) {
            if (this.model.canAnnotate(ho)) {
                List selected = browser.getSelectedDataObjects();
                if (selected.isEmpty()) {
                    this.setEnabled(false);
                } else {
                    ArrayList<Long> ids = new ArrayList<Long>();
                    for (DataObject data : selected) {
                        if (ids.contains(data.getGroupId())) continue;
                        ids.add(data.getGroupId());
                    }
                    this.setEnabled(ids.size() == 1);
                }
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }

    public TaggingAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.description = (String)this.getValue("ShortDescription");
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(69));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.model.showTagWizard();
    }
}

