/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ome.annotations.RolesAllowed;
import ome.api.IPixels;
import ome.api.ServiceInterface;
import ome.conditions.ValidationException;
import ome.logic.AbstractLevel2Service;
import ome.model.IObject;
import ome.model.core.Channel;
import ome.model.core.Image;
import ome.model.core.LogicalChannel;
import ome.model.core.Pixels;
import ome.model.display.RenderingDef;
import ome.model.enums.DimensionOrder;
import ome.model.enums.PixelsType;
import ome.model.stats.StatsInfo;
import ome.parameters.Parameters;
import ome.system.EventContext;
import ome.util.PixelData;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class PixelsImpl
extends AbstractLevel2Service
implements IPixels {
    public static final String RENDERING_DEF_QUERY_PREFIX = "select rdef from RenderingDef as rdef left outer join fetch rdef.details.owner left outer join fetch rdef.quantization left outer join fetch rdef.model left outer join fetch rdef.waveRendering as cb left outer join fetch cb.family left outer join fetch cb.spatialDomainEnhancement left outer join fetch rdef.projections as proj left outer join fetch proj.axis left outer join fetch proj.type where ";

    public Class<? extends ServiceInterface> getServiceInterface() {
        return IPixels.class;
    }

    @RolesAllowed(value={"user"})
    public Pixels retrievePixDescription(long pixId) {
        Pixels p = (Pixels)this.iQuery.findByQuery("select p from Pixels as p left outer join fetch p.pixelsType as pt left outer join fetch p.channels as c left outer join fetch c.logicalChannel as lc left outer join fetch c.statsInfo left outer join fetch lc.photometricInterpretation left outer join fetch lc.illumination left outer join fetch lc.mode left outer join fetch lc.contrastMethod where p.id = :id", new Parameters().addId(Long.valueOf(pixId)));
        return p;
    }

    @RolesAllowed(value={"user"})
    public RenderingDef retrieveRndSettingsFor(long pixId, long userId) {
        List<IObject> list = this.retrieveAllRndSettings(pixId, userId);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (RenderingDef)list.get(0);
    }

    @RolesAllowed(value={"user"})
    public List<IObject> retrieveAllRndSettings(long pixId, long userId) {
        Parameters params = new Parameters();
        params.addLong("p_id", Long.valueOf(pixId));
        String restriction = "rdef.pixels.id = :p_id ";
        if (userId >= 0L) {
            restriction = restriction + "and rdef.details.owner.id = :o_id ";
            params.addLong("o_id", Long.valueOf(userId));
        }
        List l = this.iQuery.findAllByQuery(RENDERING_DEF_QUERY_PREFIX + restriction + "order by rdef.details.updateEvent.time desc", params);
        return l;
    }

    @RolesAllowed(value={"user"})
    public RenderingDef retrieveRndSettings(long pixId) {
        Long userId = this.sec.getEffectiveUID();
        RenderingDef rd = this.retrieveRndSettingsFor(pixId, userId);
        if (rd == null) {
            EventContext ec = this.sec.getEventContext(false);
            Pixels pixelsObj = (Pixels)this.iQuery.get(Pixels.class, pixId);
            boolean isGraphCritical = this.sec.isGraphCritical(pixelsObj.getDetails());
            long pixOwner = pixelsObj.getDetails().getOwner().getId();
            long currentUser = ec.getCurrentUserId();
            if (currentUser != pixOwner) {
                rd = this.retrieveRndSettingsFor(pixId, pixOwner);
            }
        }
        return rd;
    }

    @RolesAllowed(value={"user"})
    public RenderingDef loadRndSettings(long renderingDefId) {
        return (RenderingDef)this.iQuery.findByQuery("select rdef from RenderingDef as rdef left outer join fetch rdef.details.owner left outer join fetch rdef.quantization left outer join fetch rdef.model left outer join fetch rdef.waveRendering as cb left outer join fetch cb.family left outer join fetch cb.spatialDomainEnhancement left outer join fetch rdef.projections as proj left outer join fetch proj.axis left outer join fetch proj.type where rdef.id = :id", new Parameters().addId(Long.valueOf(renderingDefId)));
    }

    private Pixels _copyAndResizePixels(long pixelsId, Integer sizeX, Integer sizeY, Integer sizeZ, Integer sizeT, List<Integer> channelList, String methodology, boolean copyStats) {
        Pixels from = this.retrievePixDescription(pixelsId);
        Pixels to = new Pixels();
        this.outOfBoundsCheck(sizeX, "sizeX");
        this.outOfBoundsCheck(sizeY, "sizeY");
        this.outOfBoundsCheck(sizeZ, "sizeZ");
        this.outOfBoundsCheck(sizeT, "sizeT");
        if (channelList != null) {
            this.channelOutOfBounds(channelList, "channel", from);
        }
        to.setDimensionOrder(from.getDimensionOrder());
        to.setMethodology(methodology);
        to.setPhysicalSizeX(from.getPhysicalSizeX());
        to.setPhysicalSizeY(from.getPhysicalSizeY());
        to.setPhysicalSizeZ(from.getPhysicalSizeZ());
        to.setPixelsType(from.getPixelsType());
        to.setRelatedTo(from);
        to.setSizeX(sizeX != null ? sizeX : from.getSizeX());
        to.setSizeY(sizeY != null ? sizeY : from.getSizeY());
        to.setSizeZ(sizeZ != null ? sizeZ : from.getSizeZ());
        to.setSizeT(sizeT != null ? sizeT : from.getSizeT());
        to.setSizeC(Integer.valueOf(channelList != null ? channelList.size() : from.getSizeC().intValue()));
        to.setSha1("Pending...");
        if (channelList != null) {
            for (Integer channel : channelList) {
                this.copyChannel(channel, from, to, copyStats);
            }
        } else {
            for (int channel = 0; channel < from.sizeOfChannels(); ++channel) {
                this.copyChannel(channel, from, to, copyStats);
            }
        }
        return to;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public Long copyAndResizePixels(long pixelsId, Integer sizeX, Integer sizeY, Integer sizeZ, Integer sizeT, List<Integer> channelList, String methodology, boolean copyStats) {
        Pixels from = this.retrievePixDescription(pixelsId);
        Pixels to = this._copyAndResizePixels(pixelsId, sizeX, sizeY, sizeZ, sizeT, channelList, methodology, copyStats);
        Image image = from.getImage();
        image.addPixels(to);
        image = (Image)this.iUpdate.saveAndReturnObject((IObject)image);
        return image.getPixels(image.sizeOfPixels() - 1).getId();
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public Long copyAndResizeImage(long imageId, Integer sizeX, Integer sizeY, Integer sizeZ, Integer sizeT, List<Integer> channelList, String name, boolean copyStats) {
        Image iFrom = (Image)this.iQuery.get(Image.class, imageId);
        Image iTo = new Image();
        iTo.setAcquisitionDate(iFrom.getAcquisitionDate());
        iTo.setName(name);
        iTo.setObjectiveSettings(iFrom.getObjectiveSettings());
        iTo.setImagingEnvironment(iFrom.getImagingEnvironment());
        iTo.setExperiment(iFrom.getExperiment());
        iTo.setStageLabel(iFrom.getStageLabel());
        iTo.setInstrument(iFrom.getInstrument());
        Iterator i = iFrom.iteratePixels();
        while (i.hasNext()) {
            Pixels p = (Pixels)i.next();
            Pixels to = this._copyAndResizePixels(p.getId(), sizeX, sizeY, sizeZ, sizeT, channelList, null, copyStats);
            iTo.addPixels(to);
        }
        iTo = (Image)this.iUpdate.saveAndReturnObject((IObject)iTo);
        return iTo.getId();
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public Long createImage(int sizeX, int sizeY, int sizeZ, int sizeT, List<Integer> channelList, PixelsType pixelsType, String name, String description) {
        Image image = new Image();
        Pixels pixels = new Pixels();
        image.setName(name);
        image.setDescription(description);
        if (channelList == null || channelList.size() == 0) {
            throw new ValidationException("Channel list must be filled.");
        }
        pixels.setPixelsType(pixelsType);
        pixels.setSizeX(Integer.valueOf(sizeX));
        pixels.setSizeY(Integer.valueOf(sizeY));
        pixels.setSizeZ(Integer.valueOf(sizeZ));
        pixels.setSizeC(Integer.valueOf(channelList.size()));
        pixels.setSizeT(Integer.valueOf(sizeT));
        pixels.setSha1("Pending...");
        pixels.setDimensionOrder(this.getEnumeration(DimensionOrder.class, "XYZCT"));
        List<Channel> channels = this.createChannels(channelList);
        for (Channel channel : channels) {
            pixels.addChannel(channel);
        }
        image.addPixels(pixels);
        image = (Image)this.iUpdate.saveAndReturnObject((IObject)image);
        return image.getId();
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void setChannelGlobalMinMax(long pixelsId, int channelIndex, double min, double max) {
        Pixels pixels = this.retrievePixDescription(pixelsId);
        Channel channel = pixels.getChannel(channelIndex);
        StatsInfo stats = channel.getStatsInfo();
        if (stats == null) {
            stats = new StatsInfo();
            channel.setStatsInfo(stats);
        }
        stats.setGlobalMax(Double.valueOf(max));
        stats.setGlobalMin(Double.valueOf(min));
        this.iUpdate.saveAndReturnObject((IObject)channel);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void saveRndSettings(RenderingDef rndSettings) {
        this.iUpdate.saveAndReturnObject((IObject)rndSettings);
    }

    @RolesAllowed(value={"user"})
    public int getBitDepth(PixelsType pixelsType) {
        return PixelData.getBitDepth((String)pixelsType.getValue());
    }

    @RolesAllowed(value={"user"})
    @Deprecated
    public <T extends IObject> T getEnumeration(Class<T> klass, String value) {
        return (T)this.iQuery.findByString(klass, "value", value);
    }

    @RolesAllowed(value={"user"})
    @Deprecated
    public <T extends IObject> List<T> getAllEnumerations(Class<T> klass) {
        return this.iQuery.findAll(klass, null);
    }

    private void outOfBoundsCheck(Integer value, String name) {
        if (value != null && value < 0) {
            throw new ValidationException(name + ": " + value + " <= 0");
        }
    }

    private void channelOutOfBounds(List<Integer> channelList, String name, Pixels pixels) {
        if (channelList.size() == 0) {
            throw new ValidationException("Channel List is not null but size == 0");
        }
        for (int i = 0; i < channelList.size(); ++i) {
            int value = channelList.get(i);
            if (value >= 0 && value < pixels.sizeOfChannels()) continue;
            throw new ValidationException(name + ": " + i + " out of bounds");
        }
    }

    private void copyChannel(int channel, Pixels from, Pixels to, boolean copyStats) {
        Channel cFrom = from.getChannel(channel);
        Channel cTo = new Channel();
        cTo.setLogicalChannel(cFrom.getLogicalChannel());
        if (copyStats) {
            cTo.setStatsInfo(new StatsInfo(cFrom.getStatsInfo().getGlobalMin(), cFrom.getStatsInfo().getGlobalMax()));
        }
        to.addChannel(cTo);
    }

    private List<Channel> createChannels(List<Integer> channelList) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (Integer wavelength : channelList) {
            Channel channel = new Channel();
            LogicalChannel lc = new LogicalChannel();
            channel.setLogicalChannel(lc);
            channels.add(channel);
        }
        return channels;
    }
}

