/*
 * Decompiled with CFR 0.152.
 */
package ome.services;

import java.awt.Dimension;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.api.IPixels;
import ome.api.IQuery;
import ome.api.IRenderingSettings;
import ome.api.IUpdate;
import ome.conditions.ApiUsageException;
import ome.conditions.ResourceError;
import ome.conditions.ValidationException;
import ome.io.nio.ThumbnailService;
import ome.model.IObject;
import ome.model.core.Image;
import ome.model.core.Pixels;
import ome.model.display.RenderingDef;
import ome.model.display.Thumbnail;
import ome.model.internal.Details;
import ome.model.internal.Permissions;
import ome.parameters.Parameters;
import ome.security.SecuritySystem;
import ome.services.PerGroupActor;
import ome.system.EventContext;
import ome.system.OmeroContext;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThumbnailCtx {
    private static final Logger log = LoggerFactory.getLogger(ThumbnailCtx.class);
    public static final String DEFAULT_MIME_TYPE = "image/jpeg";
    private IQuery queryService;
    private IUpdate updateService;
    private IPixels pixelsService;
    private ThumbnailService thumbnailService;
    private IRenderingSettings settingsService;
    private OmeroContext applicationContext;
    private SecuritySystem securitySystem;
    private long userId;
    private Map<Long, Pixels> pixelsIdPixelsMap = new HashMap<Long, Pixels>();
    private Map<Long, Long> pixelsIdOwnerIdMap = new HashMap<Long, Long>();
    private Map<Long, RenderingDef> pixelsIdSettingsMap = new HashMap<Long, RenderingDef>();
    private Map<Long, Thumbnail> pixelsIdMetadataMap = new HashMap<Long, Thumbnail>();
    private Map<Long, Timestamp> pixelsIdSettingsLastModifiedTimeMap = new HashMap<Long, Timestamp>();
    private Map<Long, Timestamp> pixelsIdMetadataLastModifiedTimeMap = new HashMap<Long, Timestamp>();
    private Map<Long, Long> pixelsIdSettingsOwnerIdMap = new HashMap<Long, Long>();

    public ThumbnailCtx(IQuery queryService, IUpdate updateService, IPixels pixelsService, IRenderingSettings settingsService, ThumbnailService thumbnailService, OmeroContext applicationContext, SecuritySystem securitySystem, long userId) {
        this.queryService = queryService;
        this.updateService = updateService;
        this.pixelsService = pixelsService;
        this.settingsService = settingsService;
        this.thumbnailService = thumbnailService;
        this.applicationContext = applicationContext;
        this.securitySystem = securitySystem;
        this.userId = userId;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public void loadAndPrepareRenderingSettings(Set<Long> pixelsIds) {
        this.loadAndPrepareRenderingSettings(Pixels.class, pixelsIds);
    }

    private void loadAndPrepareRenderingSettings(Class<? extends IObject> klass, Set<Long> ids) {
        if (ids == null || ids.size() == 0) {
            log.warn("Preparation of null or zero length ID set requested.");
            return;
        }
        List<RenderingDef> settingsList = null;
        Set<Long> pixelsIds = null;
        if (klass.equals(Pixels.class)) {
            settingsList = this.bulkLoadRenderingSettingsByPixelsId(ids);
            pixelsIds = ids;
        } else if (klass.equals(Image.class)) {
            settingsList = this.bulkLoadRenderingSettingsByImageId(ids);
            pixelsIds = new HashSet<Long>();
            for (RenderingDef def : settingsList) {
                pixelsIds.add(def.getPixels().getId());
            }
        } else {
            throw new ApiUsageException("Unexpected preparation source type: " + klass.getName());
        }
        for (RenderingDef settings : settingsList) {
            this.prepareRenderingSettings(settings, settings.getPixels());
        }
        Set<Long> pixelsIdsWithoutSettings = this.getPixelsIdsWithoutSettings(pixelsIds);
        this.loadMissingPixels(pixelsIdsWithoutSettings);
        new PerGroupActor(this.applicationContext, this.queryService, this.securitySystem.getEventContext().getCurrentGroupId()){

            @Override
            protected void actOnOneGroup(Set<Long> pixelsIds) {
                if (ThumbnailCtx.this.isExtendedGraphCritical(pixelsIds)) {
                    for (RenderingDef settings : ThumbnailCtx.this.bulkLoadOwnerRenderingSettings(pixelsIds)) {
                        ThumbnailCtx.this.prepareRenderingSettings(settings, settings.getPixels());
                    }
                }
            }
        }.actOnByGroup(pixelsIdsWithoutSettings);
    }

    public void loadAndPrepareRenderingSettings(long pixelsId, long settingsId) {
        Pixels pixels = this.pixelsService.retrievePixDescription(pixelsId);
        RenderingDef settings = this.pixelsService.loadRndSettings(settingsId);
        if (settings == null) {
            throw new ValidationException("No rendering definition exists with ID = " + settingsId);
        }
        if (!this.settingsService.sanityCheckPixels(pixels, settings.getPixels())) {
            throw new ValidationException("The rendering definition " + settingsId + " is incompatible with pixels set " + pixels.getId());
        }
        this.prepareRenderingSettings(settings, pixels);
    }

    public void loadAndPrepareMetadata(Set<Long> pixelsIds, int longestSide) {
        Map<Dimension, Set<Long>> dimensionPools = this.createDimensionPools(longestSide);
        this.loadMetadataByDimensionPool(dimensionPools);
        this.createMissingThumbnailMetadata(dimensionPools);
    }

    public void loadAndPrepareMetadata(Set<Long> pixelsIds, Dimension dimensions) {
        this.loadAndPrepareMetadata(pixelsIds, dimensions, true);
    }

    public void loadAndPrepareMetadata(Set<Long> pixelsIds, Dimension dimensions, boolean createMissing) {
        HashMap<Dimension, Set<Long>> dimensionPools = new HashMap<Dimension, Set<Long>>();
        dimensionPools.put(dimensions, pixelsIds);
        this.loadMetadataByDimensionPool(dimensionPools);
        if (createMissing) {
            this.createMissingThumbnailMetadata(dimensionPools);
        }
    }

    public List<Thumbnail> loadAllMetadata(long pixelsId) {
        Parameters params = new Parameters();
        params.addId(Long.valueOf(pixelsId));
        params.addLong("o_id", Long.valueOf(this.userId));
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.loadAllMetadata");
        List toReturn = this.queryService.findAllByQuery("select t from Thumbnail as t join t.pixels p join fetch t.details.updateEvent where t.details.owner.id = :o_id and p.id = :id", params);
        if (toReturn.isEmpty()) {
            toReturn = this.queryService.findAllByQuery("select t from Thumbnail as t join t.pixels p join fetch t.details.updateEvent where t.details.owner.id = p.details.owner.id and p.id = :id", params);
        }
        s1.stop();
        return toReturn;
    }

    public void createAndPrepareMissingRenderingSettings(Set<Long> pixelsIds) {
        if (this.securitySystem.getEventContext().getCurrentGroupId() >= 0L && this.isExtendedGraphCritical(pixelsIds)) {
            return;
        }
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.createAndPrepareMissingRenderingSettings");
        Set<Long> pixelsIdsWithoutSettings = this.getPixelsIdsWithoutSettings(pixelsIds);
        int count = pixelsIdsWithoutSettings.size();
        if (count > 0) {
            log.info(count + " pixels without settings");
            final ArrayList allImageIds = new ArrayList(count);
            new PerGroupActor(this.applicationContext, this.queryService, this.securitySystem.getEventContext().getCurrentGroupId()){

                @Override
                protected void actOnOneGroup(Set<Long> pixelsIds) {
                    if (ThumbnailCtx.this.isExtendedGraphCritical(pixelsIds)) {
                        return;
                    }
                    Set imageIds = ThumbnailCtx.this.settingsService.resetDefaultsInSet(Pixels.class, pixelsIds);
                    ThumbnailCtx.this.loadAndPrepareRenderingSettings(Image.class, imageIds);
                    allImageIds.addAll(imageIds);
                }
            }.actOnByGroup(pixelsIdsWithoutSettings);
            if (count != allImageIds.size()) {
                log.warn(String.format("Return value ID count %d does not match pixels without settings count %d", allImageIds.size(), count));
            }
        }
        s1.stop();
    }

    public boolean hasSettings(long pixelsId) {
        return this.pixelsIdSettingsMap.containsKey(pixelsId);
    }

    public boolean hasMetadata(long pixelsId) {
        return this.pixelsIdMetadataMap.containsKey(pixelsId);
    }

    public Pixels getPixels(long pixelsId) {
        Pixels pixels = this.pixelsIdPixelsMap.get(pixelsId);
        if (pixels == null) {
            throw new ResourceError(String.format("Error retrieving Pixels id:%d. Pixels set does not exist or the user id:%d has insufficient permissions to retrieve it.", pixelsId, this.userId));
        }
        return this.pixelsIdPixelsMap.get(pixelsId);
    }

    public RenderingDef getSettings(long pixelsId) {
        return this.pixelsIdSettingsMap.get(pixelsId);
    }

    public Thumbnail getMetadata(long pixelsId) throws NoThumbnail {
        Thumbnail thumbnail = this.pixelsIdMetadataMap.get(pixelsId);
        if (thumbnail == null && this.securitySystem.isGraphCritical(null)) {
            Pixels pixels = this.pixelsIdPixelsMap.get(pixelsId);
            long ownerId = pixels.getDetails().getOwner().getId();
            throw new ResourceError(String.format("The user id:%s may not be the owner id:%d. The owner has not viewed the Pixels set id:%d and thumbnail metadata is missing.", this.userId, ownerId, pixelsId));
        }
        if (thumbnail == null) {
            throw new NoThumbnail("Fatal error retrieving thumbnail metadata for Pixels set id:" + pixelsId);
        }
        return thumbnail;
    }

    public Thumbnail getMetadataSimple(long pixelsId) throws ResourceError {
        Thumbnail thumbnail = this.pixelsIdMetadataMap.get(pixelsId);
        if (thumbnail == null && this.securitySystem.isGraphCritical(null)) {
            Pixels pixels = this.pixelsIdPixelsMap.get(pixelsId);
            long ownerId = pixels.getDetails().getOwner().getId();
            throw new ResourceError(String.format("The user id:%s may not be the owner id:%d. The owner has not viewed the Pixels set id:%d and thumbnail metadata is missing.", this.userId, ownerId, pixelsId));
        }
        return thumbnail;
    }

    public boolean dirtyMetadata(long pixelsId) {
        Timestamp metadataLastUpdated = this.pixelsIdMetadataLastModifiedTimeMap.get(pixelsId);
        Timestamp settingsLastUpdated = this.pixelsIdSettingsLastModifiedTimeMap.get(pixelsId);
        if (log.isDebugEnabled()) {
            log.debug("Thumb time: " + metadataLastUpdated);
            log.debug("Settings time: " + settingsLastUpdated);
        }
        if (metadataLastUpdated == null) {
            return true;
        }
        if (settingsLastUpdated == null) {
            return false;
        }
        return settingsLastUpdated.after(metadataLastUpdated);
    }

    public boolean isThumbnailCached(long pixelsId) {
        Thumbnail metadata = this.pixelsIdMetadataMap.get(pixelsId);
        if (metadata == null) {
            return false;
        }
        try {
            boolean dirtyMetadata = this.dirtyMetadata(pixelsId);
            boolean thumbnailExists = this.thumbnailService.getThumbnailExists(metadata);
            boolean isExtendedGraphCritical = new ExtendedGraphCriticalCheck(pixelsId).isCritical;
            Long metadataOwnerId = metadata.getDetails().getOwner().getId();
            Long sessionUserId = this.securitySystem.getEffectiveUID();
            boolean isMyMetadata = sessionUserId.equals(metadataOwnerId);
            if (!dirtyMetadata) {
                if (thumbnailExists) {
                    return true;
                }
                if (!thumbnailExists && isExtendedGraphCritical) {
                    throw new ResourceError(String.format("Error retrieving Pixels id:%d. Thumbnail metadata exists but a thumbnail is not available in the cache. User id:%d has insufficient permissions to create it.", pixelsId, this.userId));
                }
            } else {
                if (thumbnailExists && !isMyMetadata) {
                    if (sessionUserId == this.userId && this.userId != metadataOwnerId) {
                        return false;
                    }
                    if (this.userId == metadataOwnerId && sessionUserId != this.userId) {
                        return false;
                    }
                    log.warn(String.format("Thumbnail metadata is dirty for Pixels Id:%d and the metadata is owned User id:%d which is not User id:%d. Ignoring this and returning the cached thumbnail.", pixelsId, metadataOwnerId, this.userId));
                    return true;
                }
                if (thumbnailExists && isExtendedGraphCritical) {
                    if (dirtyMetadata && this.userId == metadataOwnerId) {
                        return false;
                    }
                    log.warn(String.format("Thumbnail metadata is dirty for Pixels Id:%d and graph is critical for User id:%d. Ignoring this and returning the cached thumbnail.owner %d dirty %d", pixelsId, this.userId, metadataOwnerId, dirtyMetadata));
                    return true;
                }
            }
        }
        catch (IOException e) {
            String s = "Could not check if thumbnail is cached: ";
            log.error(s, (Throwable)e);
            throw new ResourceError(s + e.getMessage());
        }
        return false;
    }

    public Dimension calculateXYWidths(Pixels pixels, int longestSide) {
        int sizeY;
        int sizeX = pixels.getSizeX();
        if (sizeX > (sizeY = pixels.getSizeY().intValue())) {
            float ratio = (float)longestSide / (float)sizeX;
            return new Dimension(longestSide, (int)((float)sizeY * ratio));
        }
        float ratio = (float)longestSide / (float)sizeY;
        return new Dimension((int)((float)sizeX * ratio), longestSide);
    }

    private boolean isExtendedGraphCritical(Map<Dimension, Set<Long>> dimensionPools) {
        for (Set<Long> pool : dimensionPools.values()) {
            if (!this.isExtendedGraphCritical(pool)) continue;
            return true;
        }
        return false;
    }

    public boolean isExtendedGraphCritical(Set<Long> pixelsIds) {
        EventContext ec = this.securitySystem.getEventContext();
        Permissions currentGroupPermissions = ec.getCurrentGroupPermissions();
        Permissions readOnly = Permissions.parseString((String)"rwr---");
        if (ec.getCurrentShareId() != null) {
            return true;
        }
        if (this.securitySystem.isGraphCritical(null) || currentGroupPermissions.identical(readOnly)) {
            for (Long pixelsId : pixelsIds) {
                if (this.pixelsIdOwnerIdMap == null) {
                    throw new ResourceError(String.format("Error retrieving Pixels id:%d. Pixels set does not exist or the user id:%d has insufficient permissions to retrieve it.", pixelsId, this.userId));
                }
                Long pixelsOwner = this.pixelsIdOwnerIdMap.get(pixelsId);
                if (pixelsOwner == null) {
                    throw new ResourceError(String.format("Error retrieving Pixels id:%d. Pixels set does not exist or the user id:%d has insufficient permissions to retrieve it.", pixelsId, this.userId));
                }
                if (pixelsOwner == this.userId || ec.getLeaderOfGroupsList().contains(this.userId) || ec.isCurrentUserAdmin()) continue;
                return true;
            }
        }
        return false;
    }

    private Map<Dimension, Set<Long>> createDimensionPools(int longestSide) {
        HashMap<Dimension, Set<Long>> dimensionPools = new HashMap<Dimension, Set<Long>>();
        for (Pixels pixels : this.pixelsIdPixelsMap.values()) {
            Dimension dimensions = this.calculateXYWidths(pixels, longestSide);
            this.addToDimensionPool(dimensionPools, pixels, dimensions);
        }
        return dimensionPools;
    }

    private void addToDimensionPool(Map<Dimension, Set<Long>> pools, Pixels pixels, Dimension dimensions) {
        Set<Long> pool = pools.get(dimensions);
        if (pool == null) {
            pool = new HashSet<Long>();
        }
        pool.add(pixels.getId());
        pools.put(dimensions, pool);
    }

    private Set<Long> getPixelsIdsWithoutSettings(Set<Long> pixelsIds) {
        HashSet<Long> pixelsIdsWithoutSettings = new HashSet<Long>();
        for (Long pixelsId : pixelsIds) {
            if (this.hasSettings(pixelsId)) continue;
            pixelsIdsWithoutSettings.add(pixelsId);
        }
        return pixelsIdsWithoutSettings;
    }

    private Set<Long> getPixelsIdsWithoutMetadata(Set<Long> pixelsIds) {
        HashSet<Long> pixelsIdsWithoutMetadata = new HashSet<Long>();
        for (Long pixelsId : pixelsIds) {
            if (this.hasMetadata(pixelsId)) continue;
            pixelsIdsWithoutMetadata.add(pixelsId);
        }
        return pixelsIdsWithoutMetadata;
    }

    private List<RenderingDef> bulkLoadRenderingSettingsByPixelsId(Set<Long> pixelsIds) {
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.bulkLoadRenderingSettings");
        List toReturn = this.queryService.findAllByQuery("select r from RenderingDef as r join fetch r.pixels as p join fetch r.details.updateEvent join p.details.updateEvent where r.details.owner.id = :id and r.pixels.id in (:ids) order by r.details.updateEvent.time asc", new Parameters().addId(Long.valueOf(this.userId)).addIds(pixelsIds));
        if (toReturn.isEmpty()) {
            toReturn = this.queryService.findAllByQuery("select r from RenderingDef as r join fetch r.pixels as p join fetch r.details.updateEvent join p.details.updateEvent where r.details.owner.id = p.details.owner.id and r.pixels.id in (:ids) order by r.details.updateEvent.time asc", new Parameters().addId(Long.valueOf(this.userId)).addIds(pixelsIds));
        }
        s1.stop();
        return toReturn;
    }

    private List<RenderingDef> bulkLoadRenderingSettingsByImageId(Set<Long> imageIds) {
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.bulkLoadRenderingSettings");
        List toReturn = this.queryService.findAllByQuery("select r from RenderingDef as r join fetch r.pixels as p join fetch r.details.updateEvent join fetch p.details.updateEvent where r.details.owner.id = :id and r.pixels.image.id in (:ids) order by r.details.updateEvent.time asc", new Parameters().addId(Long.valueOf(this.userId)).addIds(imageIds));
        if (toReturn.isEmpty()) {
            toReturn = this.queryService.findAllByQuery("select r from RenderingDef as r join fetch r.pixels as p join fetch r.details.updateEvent join fetch p.details.updateEvent where r.details.owner.id = p.details.owner.id and r.pixels.image.id in (:ids) order by r.details.updateEvent.time asc", new Parameters().addId(Long.valueOf(this.userId)).addIds(imageIds));
        }
        s1.stop();
        return toReturn;
    }

    private List<RenderingDef> bulkLoadOwnerRenderingSettings(Set<Long> pixelsIds) {
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.bulkLoadOwnerRenderingSettings");
        List toReturn = this.queryService.findAllByQuery("select r from RenderingDef as r join fetch r.pixels as p join fetch r.details.updateEvent join fetch p.details.updateEvent where r.details.owner.id = p.details.owner.id and r.pixels.id in (:ids) order by r.details.updateEvent.time asc", new Parameters().addIds(pixelsIds));
        s1.stop();
        return toReturn;
    }

    private List<Thumbnail> bulkLoadMetadata(Dimension dimensions, Set<Long> pixelsIds) {
        Parameters params = new Parameters();
        params.addInteger("x", Integer.valueOf((int)dimensions.getWidth()));
        params.addInteger("y", Integer.valueOf((int)dimensions.getHeight()));
        params.addLong("o_id", Long.valueOf(this.userId));
        params.addIds(pixelsIds);
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.bulkLoadMetadata");
        List toReturn = this.queryService.findAllByQuery("select t from Thumbnail as t join t.pixels p join fetch t.details.updateEvent where t.sizeX = :x and t.sizeY = :y and t.details.owner.id = :o_id and p.id in (:ids)", params);
        if (toReturn.isEmpty()) {
            toReturn = this.queryService.findAllByQuery("select t from Thumbnail as t join t.pixels p join fetch t.details.updateEvent where t.sizeX = :x and t.sizeY = :y and t.details.owner.id = p.details.owner.id and p.id in (:ids)", params);
        }
        s1.stop();
        return toReturn;
    }

    private List<Thumbnail> bulkLoadOwnerMetadata(Dimension dimensions, Set<Long> pixelsIds) {
        Parameters params = new Parameters();
        params.addInteger("x", Integer.valueOf((int)dimensions.getWidth()));
        params.addInteger("y", Integer.valueOf((int)dimensions.getHeight()));
        params.addIds(pixelsIds);
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.bulkLoadOwnerMetadata");
        List toReturn = this.queryService.findAllByQuery("select t from Thumbnail as t join t.pixels as p join fetch t.details.updateEvent where t.sizeX = :x and t.sizeY = :y and t.details.owner.id = p.details.owner.id and t.pixels.id in (:ids)", params);
        s1.stop();
        return toReturn;
    }

    private void loadMetadataByDimensionPool(Map<Dimension, Set<Long>> dimensionPools) {
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.loadMetadataByDimensionPool");
        for (final Dimension dimensions : dimensionPools.keySet()) {
            Set<Long> pool = dimensionPools.get(dimensions);
            List<Thumbnail> thumbnailList = this.bulkLoadMetadata(dimensions, pool);
            for (Thumbnail metadata : thumbnailList) {
                this.prepareMetadata(metadata, metadata.getPixels().getId());
            }
            new PerGroupActor(this.applicationContext, this.queryService, this.securitySystem.getEventContext().getCurrentGroupId()){

                @Override
                protected void actOnOneGroup(Set<Long> pixelsIds) {
                    if (ThumbnailCtx.this.isExtendedGraphCritical(pixelsIds)) {
                        List thumbnailList = ThumbnailCtx.this.bulkLoadOwnerMetadata(dimensions, pixelsIds);
                        for (Thumbnail metadata : thumbnailList) {
                            ThumbnailCtx.this.prepareMetadata(metadata, metadata.getPixels().getId());
                        }
                    }
                }
            }.actOnByGroup(this.getPixelsIdsWithoutMetadata(pool));
        }
        s1.stop();
    }

    private void loadMissingPixels(Set<Long> pixelsIds) {
        if (pixelsIds.size() > 0) {
            Parameters parameters = new Parameters();
            parameters.addIds(pixelsIds);
            if (log.isDebugEnabled()) {
                log.debug("Loading " + pixelsIds.size() + " missing Pixels.");
            }
            Slf4JStopWatch s1 = new Slf4JStopWatch("omero.loadMissingPixels");
            List pixelsWithoutSettings = this.queryService.findAllByQuery("select p from Pixels as p where id in (:ids)", parameters);
            s1.stop();
            for (Pixels pixels : pixelsWithoutSettings) {
                Long pixelsId = pixels.getId();
                this.pixelsIdPixelsMap.put(pixelsId, pixels);
                this.pixelsIdOwnerIdMap.put(pixelsId, pixels.getDetails().getOwner().getId());
            }
        }
    }

    private void prepareRenderingSettings(RenderingDef settings, Pixels pixels) {
        Long pixelsId = pixels.getId();
        this.pixelsIdPixelsMap.put(pixelsId, pixels);
        this.pixelsIdOwnerIdMap.put(pixelsId, pixels.getDetails().getOwner().getId());
        Details details = settings.getDetails();
        Timestamp timestemp = details.getUpdateEvent().getTime();
        this.pixelsIdSettingsMap.put(pixelsId, settings);
        this.pixelsIdSettingsLastModifiedTimeMap.put(pixelsId, timestemp);
        this.pixelsIdSettingsOwnerIdMap.put(pixelsId, details.getOwner().getId());
    }

    private void prepareMetadata(Thumbnail metadata, long pixelsId) {
        Timestamp t = metadata.getDetails().getUpdateEvent().getTime();
        this.pixelsIdMetadataMap.put(pixelsId, metadata);
        this.pixelsIdMetadataLastModifiedTimeMap.put(pixelsId, t);
    }

    private void createMissingThumbnailMetadata(final Map<Dimension, Set<Long>> dimensionPools) {
        if (this.securitySystem.getEventContext().getCurrentGroupId() >= 0L && this.isExtendedGraphCritical(dimensionPools)) {
            return;
        }
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.createMissingThumbnailMetadata");
        Set<Long> pixelsIdsWithoutMetadata = this.getPixelsIdsWithoutMetadata(this.pixelsIdPixelsMap.keySet());
        new PerGroupActor(this.applicationContext, this.queryService, this.securitySystem.getEventContext().getCurrentGroupId()){

            @Override
            protected void actOnOneGroup(Set<Long> pixelsIds) {
                ArrayList<Thumbnail> toSave = new ArrayList<Thumbnail>();
                HashMap temporaryDimensionPools = new HashMap();
                block0: for (Long pixelsId : pixelsIds) {
                    Pixels pixels = (Pixels)ThumbnailCtx.this.pixelsIdPixelsMap.get(pixelsId);
                    for (Dimension dimension : dimensionPools.keySet()) {
                        Set pool = (Set)dimensionPools.get(dimension);
                        if (!pool.contains(pixelsId)) continue;
                        toSave.add(ThumbnailCtx.this.createThumbnailMetadata(pixels, dimension));
                        ThumbnailCtx.this.addToDimensionPool(temporaryDimensionPools, pixels, dimension);
                        continue block0;
                    }
                }
                if (ThumbnailCtx.this.isExtendedGraphCritical(temporaryDimensionPools)) {
                    return;
                }
                log.info("New thumbnail object set size: " + toSave.size());
                log.info("Dimension pool size: " + temporaryDimensionPools.size());
                if (!toSave.isEmpty()) {
                    ThumbnailCtx.this.updateService.saveAndReturnIds((IObject[])toSave.toArray(new Thumbnail[toSave.size()]));
                    ThumbnailCtx.this.loadMetadataByDimensionPool(temporaryDimensionPools);
                }
            }
        }.actOnByGroup(pixelsIdsWithoutMetadata);
        s1.stop();
    }

    public Thumbnail createThumbnailMetadata(Pixels pixels, Dimension dimensions) {
        Pixels unloadedPixels = new Pixels(pixels.getId(), false);
        Thumbnail thumb = new Thumbnail();
        thumb.setPixels(unloadedPixels);
        thumb.setMimeType(DEFAULT_MIME_TYPE);
        thumb.setSizeX(Integer.valueOf((int)dimensions.getWidth()));
        thumb.setSizeY(Integer.valueOf((int)dimensions.getHeight()));
        return thumb;
    }

    private class ExtendedGraphCriticalCheck
    extends PerGroupActor {
        private boolean isCritical;

        private ExtendedGraphCriticalCheck(long pixelsId) {
            super(ThumbnailCtx.this.applicationContext, ThumbnailCtx.this.queryService, ThumbnailCtx.this.securitySystem.getEventContext().getCurrentGroupId());
            if (ThumbnailCtx.this.securitySystem.getEventContext().getCurrentShareId() == null) {
                this.actOnByGroup(Collections.singleton(pixelsId));
            } else {
                this.isCritical = true;
            }
        }

        @Override
        protected void actOnOneGroup(Set<Long> pixelsIds) {
            this.isCritical = ThumbnailCtx.this.isExtendedGraphCritical(pixelsIds);
        }
    }

    public static class NoThumbnail
    extends Exception {
        private static final long serialVersionUID = 8383673110828921831L;

        public NoThumbnail(String message) {
            super(message);
        }
    }
}

