/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EndpointParseException;
import IceInternal.BasicStream;
import IceInternal.Buffer;
import IceInternal.EndpointFactory;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.OpaqueEndpointI;
import IceInternal.Protocol;
import IceUtilInternal.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class EndpointFactoryManager {
    private Instance _instance;
    private List<EndpointFactory> _factories = new ArrayList<EndpointFactory>();

    EndpointFactoryManager(Instance instance) {
        this._instance = instance;
    }

    public synchronized void add(EndpointFactory factory) {
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory f = this._factories.get(i);
            if (f.type() == factory.type()) assert (false);
        }
        this._factories.add(factory);
    }

    public synchronized EndpointFactory get(short type) {
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory f = this._factories.get(i);
            if (f.type() != type) continue;
            return f;
        }
        return null;
    }

    public synchronized EndpointI create(String str, boolean oaEndpoint) {
        EndpointParseException ex;
        String[] arr = StringUtil.splitString(str, " \t\r\n");
        if (arr == null) {
            EndpointParseException e = new EndpointParseException();
            e.str = "mismatched quote";
            throw e;
        }
        if (arr.length == 0) {
            EndpointParseException e = new EndpointParseException();
            e.str = "value has no non-whitespace characters";
            throw e;
        }
        ArrayList<String> v = new ArrayList<String>(Arrays.asList(arr));
        String protocol = v.get(0);
        v.remove(0);
        if (protocol.equals("default")) {
            protocol = this._instance.defaultsAndOverrides().defaultProtocol;
        }
        EndpointFactory factory = null;
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory f = this._factories.get(i);
            if (!f.protocol().equals(protocol)) continue;
            factory = f;
        }
        if (factory != null) {
            EndpointI e = factory.create(v, oaEndpoint);
            if (!v.isEmpty()) {
                ex = new EndpointParseException();
                ex.str = "unrecognized argument `" + v.get(0) + "' in endpoint `" + str + "'";
                throw ex;
            }
            return e;
        }
        if (protocol.equals("opaque")) {
            OpaqueEndpointI ue = new OpaqueEndpointI(v);
            if (!v.isEmpty()) {
                ex = new EndpointParseException();
                ex.str = "unrecognized argument `" + v.get(0) + "' in endpoint `" + str + "'";
                throw ex;
            }
            factory = this.get(((EndpointI)ue).type());
            if (factory != null) {
                BasicStream bs = new BasicStream(this._instance, Protocol.currentProtocolEncoding, false);
                bs.writeShort(((EndpointI)ue).type());
                ((EndpointI)ue).streamWrite(bs);
                Buffer buf = bs.getBuffer();
                buf.b.position(0);
                buf.b.limit(buf.size());
                bs.readShort();
                bs.startReadEncaps();
                EndpointI e = factory.read(bs);
                bs.endReadEncaps();
                return e;
            }
            return ue;
        }
        return null;
    }

    public synchronized EndpointI read(BasicStream s) {
        short type = s.readShort();
        EndpointFactory factory = this.get(type);
        EndpointI e = null;
        s.startReadEncaps();
        e = factory != null ? factory.read(s) : new OpaqueEndpointI(type, s);
        s.endReadEncaps();
        return e;
    }

    void destroy() {
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory f = this._factories.get(i);
            f.destroy();
        }
        this._factories.clear();
    }
}

